/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class ComplexAxisAlignedBoundingBox {
    private static final int[] cos = new int[]{1, 0, -1, 0};
    private static final int[] sin = new int[]{0, 1, 0, -1};
    public Vec3[][] flatSurfaces;
    public Pair<Vec3, Vec3>[] verticals;
    public static ComplexAxisAlignedBoundingBox defaultComplexBoundingBox = new ComplexAxisAlignedBoundingBox(new Vec3[][]{{Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0)}, {Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)1.0, (double)1.0), Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0), Vec3.func_72443_a((double)1.0, (double)1.0, (double)0.0)}}, new Pair[]{Pair.of((Object)Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), (Object)Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0)), Pair.of((Object)Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0), (Object)Vec3.func_72443_a((double)1.0, (double)1.0, (double)0.0)), Pair.of((Object)Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), (Object)Vec3.func_72443_a((double)0.0, (double)1.0, (double)1.0)), Pair.of((Object)Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0), (Object)Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0))});

    public ComplexAxisAlignedBoundingBox(Vec3[][] flatSurfaces, Pair<Vec3, Vec3>[] verticals) {
        this.flatSurfaces = flatSurfaces;
        this.verticals = verticals;
    }

    public void addOffset(double x, double y, double z) {
        Vec3[][] vec3Array = this.flatSurfaces;
        int n = vec3Array.length;
        for (int i = 0; i < n; ++i) {
            Vec3[] vec3Array2;
            for (Vec3 vec : vec3Array2 = vec3Array[i]) {
                vec.field_72450_a += x;
                vec.field_72448_b += y;
                vec.field_72449_c += z;
            }
        }
        for (Vec3[] vec3Array3 : this.verticals) {
            Vec3 start = (Vec3)vec3Array3.getLeft();
            Vec3 end = (Vec3)vec3Array3.getRight();
            start.field_72450_a += x;
            start.field_72448_b += y;
            start.field_72449_c += z;
            end.field_72450_a += x;
            end.field_72448_b += y;
            end.field_72449_c += z;
        }
    }

    public void rotate(ForgeDirection dir, Axis axis) {
        int i;
        int angle = ComplexAxisAlignedBoundingBox.getAngle(dir);
        for (i = 0; i < this.flatSurfaces.length; ++i) {
            for (int j = 0; j < this.flatSurfaces[i].length; ++j) {
                this.flatSurfaces[i][j] = this.rotateVec(this.flatSurfaces[i][j], angle, axis);
            }
        }
        for (i = 0; i < this.verticals.length; ++i) {
            Vec3 start = (Vec3)this.verticals[i].getLeft();
            Vec3 end = (Vec3)this.verticals[i].getRight();
            this.verticals[i] = Pair.of((Object)this.rotateVec(start, angle, axis), (Object)this.rotateVec(end, angle, axis));
        }
    }

    private Vec3 rotateVec(Vec3 vec, int angle, Axis axis) {
        Vec3 vec3;
        int a = angle % 4;
        if (a < 0) {
            a += 4;
        }
        int s = sin[a];
        int c = cos[a];
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        switch (axis) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                vec3 = Vec3.func_72443_a((double)x, (double)(y * (double)c - z * (double)s), (double)(y * (double)s + z * (double)c));
                break;
            }
            case Y: {
                vec3 = Vec3.func_72443_a((double)(x * (double)c - z * (double)s), (double)y, (double)(x * (double)s + z * (double)c));
                break;
            }
            case Z: {
                vec3 = Vec3.func_72443_a((double)(x * (double)c - y * (double)s), (double)(x * (double)s + y * (double)c), (double)z);
            }
        }
        return vec3;
    }

    private static int getAngle(ForgeDirection dir) {
        int n;
        switch (dir) {
            case EAST: {
                n = 1;
                break;
            }
            case SOUTH: {
                n = 2;
                break;
            }
            case WEST: {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

