/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mantle.client.MProxyClient;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.RenderBlockFluid;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.modelblock.DryingRackRender;
import tconstruct.armor.modelblock.DryingRackSpecialRender;
import tconstruct.blocks.logic.DryingRackLogic;
import tconstruct.client.pages.BlockCastPage;
import tconstruct.common.TProxyCommon;
import tconstruct.smeltery.SmelteryProxyCommon;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.gui.SmelteryGui;
import tconstruct.smeltery.logic.CastingBasinLogic;
import tconstruct.smeltery.logic.CastingTableLogic;
import tconstruct.smeltery.logic.SmelteryLogic;
import tconstruct.smeltery.model.BlockRenderCastingChannel;
import tconstruct.smeltery.model.CastingBasinSpecialRender;
import tconstruct.smeltery.model.CastingBlockRender;
import tconstruct.smeltery.model.CastingTableSpecialRenderer;
import tconstruct.smeltery.model.PaneConnectedRender;
import tconstruct.smeltery.model.PaneRender;
import tconstruct.smeltery.model.SmelteryRender;
import tconstruct.smeltery.model.TankItemRenderer;
import tconstruct.smeltery.model.TankRender;
import tconstruct.tools.TinkerTools;

public class SmelteryProxyClient
extends SmelteryProxyCommon {
    @Override
    public void initialize() {
        this.registerRenderer();
        this.registerGuiHandler();
        this.registerManualIcons();
        this.registerManualRecipes();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    void registerRenderer() {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new TankRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new CastingBlockRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new DryingRackRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new PaneRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new PaneConnectedRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockFluid());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderCastingChannel());
        TankItemRenderer tankItemRenderer = new TankItemRenderer();
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)TinkerSmeltery.lavaTank), (IItemRenderer)tankItemRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)TinkerSmeltery.lavaTankNether), (IItemRenderer)tankItemRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new SmelteryRender());
        ClientRegistry.bindTileEntitySpecialRenderer(CastingTableLogic.class, (TileEntitySpecialRenderer)new CastingTableSpecialRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(CastingBasinLogic.class, (TileEntitySpecialRenderer)new CastingBasinSpecialRender());
        ClientRegistry.bindTileEntitySpecialRenderer(DryingRackLogic.class, (TileEntitySpecialRenderer)new DryingRackSpecialRender());
    }

    void registerManualIcons() {
        MantleClientRegistry.registerManualIcon((String)"smelterybook", (ItemStack)new ItemStack(TinkerTools.manualBook, 1, 2));
        MantleClientRegistry.registerManualIcon((String)"smeltery", (ItemStack)new ItemStack(TinkerSmeltery.smeltery));
        MantleClientRegistry.registerManualIcon((String)"blankcast", (ItemStack)new ItemStack(TinkerTools.blankPattern, 1, 1));
        MantleClientRegistry.registerManualIcon((String)"castingtable", (ItemStack)new ItemStack(TinkerSmeltery.searedBlock));
        MantleClientRegistry.registerManualIcon((String)"lavatank", (ItemStack)new ItemStack(TinkerSmeltery.lavaTank));
        MantleClientRegistry.registerManualIcon((String)"searedbrick", (ItemStack)new ItemStack(TinkerSmeltery.smeltery, 1, 2));
        MantleClientRegistry.registerManualIcon((String)"drain", (ItemStack)new ItemStack(TinkerSmeltery.smeltery, 1, 1));
        MantleClientRegistry.registerManualIcon((String)"faucet", (ItemStack)new ItemStack(TinkerSmeltery.searedBlock, 1, 1));
        MantleClientRegistry.registerManualIcon((String)"bloodbucket", (ItemStack)new ItemStack(TinkerSmeltery.buckets, 1, 16));
        MantleClientRegistry.registerManualIcon((String)"emeraldbucket", (ItemStack)new ItemStack(TinkerSmeltery.buckets, 1, 15));
        MantleClientRegistry.registerManualIcon((String)"gluebucket", (ItemStack)new ItemStack(TinkerSmeltery.buckets, 1, 25));
        MantleClientRegistry.registerManualIcon((String)"slimebucket", (ItemStack)new ItemStack(TinkerSmeltery.buckets, 1, 24));
        MantleClientRegistry.registerManualIcon((String)"enderbucket", (ItemStack)new ItemStack(TinkerSmeltery.buckets, 1, 23));
        MantleClientRegistry.registerManualIcon((String)"quartzbucket", (ItemStack)new ItemStack(TinkerSmeltery.buckets, 1, 26));
        MProxyClient.registerManualPage((String)"blockcast", BlockCastPage.class);
    }

    void registerManualRecipes() {
        ItemStack sand = new ItemStack((Block)Blocks.field_150354_m, 1, 0);
        ItemStack gravel = new ItemStack(Blocks.field_150351_n, 1, 0);
        ItemStack clay = new ItemStack(Items.field_151119_aD, 1, 0);
        ItemStack glass = new ItemStack(Blocks.field_150359_w, 1, 0);
        ItemStack grout = new ItemStack(TinkerTools.craftedSoil, 2, 1);
        ItemStack searedbrick = new ItemStack(TinkerTools.materials, 1, 2);
        ItemStack searedbrickBlock = new ItemStack(TinkerSmeltery.smeltery, 1, 2);
        ItemStack plankSlab = new ItemStack((Block)Blocks.field_150376_bx, 1, 0);
        MantleClientRegistry.registerManualSmallRecipe((String)"grout", (ItemStack)grout, (ItemStack[])new ItemStack[]{sand, gravel, null, clay});
        MantleClientRegistry.registerManualFurnaceRecipe((String)"searedbrick", (ItemStack)searedbrick, (ItemStack)grout);
        MantleClientRegistry.registerManualSmallRecipe((String)"searedbricks", (ItemStack)new ItemStack(TinkerSmeltery.smeltery, 1, 2), (ItemStack[])new ItemStack[]{searedbrick, searedbrick, searedbrick, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterycontroller", (ItemStack)new ItemStack(TinkerSmeltery.smeltery, 1, 0), (ItemStack[])new ItemStack[]{searedbrick, searedbrick, searedbrick, searedbrick, null, searedbrick, searedbrick, searedbrick, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"dryingrack", (ItemStack)new ItemStack(TinkerArmor.dryingRack, 1, 0), (ItemStack[])new ItemStack[]{null, null, null, plankSlab, plankSlab, plankSlab, null, null, null});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterydrain", (ItemStack)new ItemStack(TinkerSmeltery.smeltery, 1, 1), (ItemStack[])new ItemStack[]{searedbrick, null, searedbrick, searedbrick, null, searedbrick, searedbrick, null, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterytank1", (ItemStack)new ItemStack(TinkerSmeltery.lavaTank, 1, 0), (ItemStack[])new ItemStack[]{searedbrick, searedbrick, searedbrick, searedbrick, glass, searedbrick, searedbrick, searedbrick, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterytank2", (ItemStack)new ItemStack(TinkerSmeltery.lavaTank, 1, 1), (ItemStack[])new ItemStack[]{searedbrick, glass, searedbrick, glass, glass, glass, searedbrick, glass, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterytank3", (ItemStack)new ItemStack(TinkerSmeltery.lavaTank, 1, 2), (ItemStack[])new ItemStack[]{searedbrick, glass, searedbrick, searedbrick, glass, searedbrick, searedbrick, glass, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterytable", (ItemStack)new ItemStack(TinkerSmeltery.searedBlock, 1, 0), (ItemStack[])new ItemStack[]{searedbrick, searedbrick, searedbrick, searedbrick, null, searedbrick, searedbrick, null, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelteryfaucet", (ItemStack)new ItemStack(TinkerSmeltery.searedBlock, 1, 1), (ItemStack[])new ItemStack[]{searedbrick, null, searedbrick, null, searedbrick, null, null, null, null});
        MantleClientRegistry.registerManualLargeRecipe((String)"castingchannel", (ItemStack)new ItemStack(TinkerSmeltery.castingChannel), (ItemStack[])new ItemStack[]{null, null, null, searedbrick, null, searedbrick, searedbrick, searedbrick, searedbrick});
        MantleClientRegistry.registerManualLargeRecipe((String)"smelterybasin", (ItemStack)new ItemStack(TinkerSmeltery.searedBlock, 1, 2), (ItemStack[])new ItemStack[]{searedbrick, null, searedbrick, searedbrick, null, searedbrick, searedbrick, searedbrick, searedbrick});
    }

    @Override
    protected void registerGuiHandler() {
        TProxyCommon.registerClientGuiHandler(7, this);
        TProxyCommon.registerServerGuiHandler(7, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 7) {
            return new SmelteryGui(player.field_71071_by, (SmelteryLogic)world.func_147438_o(x, y, z), world, x, y, z);
        }
        return null;
    }
}

