/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.library.weaponry.AmmoWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.client.CrosshairType;
import tconstruct.weaponry.entity.ThrowingKnifeEntity;

public class ThrowingKnife
extends AmmoWeapon {
    public ThrowingKnife() {
        super(1, "throwingknife");
    }

    @Override
    public int getPartAmount() {
        return 2;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_knife_blade";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "_knife_handle";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_knife_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "throwingknife";
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.knifeBlade;
    }

    @Override
    public Item getAccessoryItem() {
        return null;
    }

    @Override
    public int getWindupTime(ItemStack itemStack) {
        return 15;
    }

    @Override
    public float getMinWindupProgress(ItemStack itemStack) {
        return 0.6f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 1.0f;
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 10.0f;
    }

    @Override
    protected Entity createProjectile(ItemStack reference, World world, EntityPlayer player, float accuracy, int time) {
        ThrowingKnifeEntity knife = new ThrowingKnifeEntity(world, player, this.getProjectileSpeed(), accuracy, reference);
        if ((float)time >= (float)this.getWindupTime(reference) * 1.5f) {
            knife.func_70243_d(true);
        }
        return knife;
    }

    @Override
    public float getProjectileSpeed() {
        return 2.2f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrosshairType getCrosshairType() {
        return CrosshairType.SPIKE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this) {
            player.field_71158_b.field_78900_b *= 3.0f;
            player.field_71158_b.field_78902_a *= 3.0f;
        }
    }
}

