/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.ranks;

import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import serverutils.client.gui.ranks.GuiRanks;
import serverutils.client.gui.ranks.RankInst;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.TextBox;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.MouseButton;

public class GuiAddRank
extends GuiBase {
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final TextBox textBoxId;

    public GuiAddRank(final GuiRanks prev) {
        this.setSize(162, 62);
        int bwidth = this.width / 2 - 10;
        this.buttonAccept = new SimpleTextButton(this, StatCollector.func_74838_a((String)"gui.accept"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                String text = GuiAddRank.this.textBoxId.getText().toLowerCase();
                if (!text.isEmpty()) {
                    this.getGui().closeGui(true);
                    ClientUtils.execClientCommand("/ranks create " + text);
                    RankInst inst = new RankInst(text);
                    inst.group.setDisplayName((IChatComponent)new ChatComponentText(EnumChatFormatting.BOLD + StringUtils.firstUppercase(text)));
                    prev.addRank(inst);
                }
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bwidth - 9, this.height - 24, bwidth, 16);
        this.buttonCancel = new SimpleTextButton(this, StatCollector.func_74838_a((String)"gui.cancel"), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.getGui().closeGui(true);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bwidth, 16);
        this.textBoxId = new TextBox(this){

            @Override
            public void onTextChanged() {
                this.setText(StringUtils.getID(this.getText(), 14), false);
            }

            @Override
            public void onEnterPressed() {
                GuiAddRank.this.buttonAccept.onClicked(MouseButton.LEFT);
            }
        };
        this.textBoxId.setPosAndSize(8, 8, this.width - 16, 16);
        this.textBoxId.writeText("");
        this.textBoxId.ghostText = "Enter Rank Name";
        this.textBoxId.setFocused(true);
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.textBoxId);
    }
}

