/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.team;

import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.EnumTeamStatus;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.util.StringUtils;

public class CmdRequestInvite
extends CmdBase {
    public CmdRequestInvite() {
        super("request_invite", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdRequestInvite.matchFromIterable(args, EnumTeamStatus.VALID_VALUES);
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        ForgePlayer p = CommandUtils.getForgePlayer((ICommandSender)CmdRequestInvite.func_71521_c((ICommandSender)sender));
        if (p.hasTeam()) {
            throw ServerUtilities.error(sender, "serverutilities.lang.team.error.must_leave", new Object[0]);
        }
        this.checkArgs(sender, args, 1);
        ForgeTeam team = Universe.get().getTeam(args[0]);
        if (!team.isValid()) {
            throw ServerUtilities.error(sender, "error", args[0]);
        }
        team.setRequestingInvite(p, true);
        ChatComponentText component = new ChatComponentText("");
        component.func_150257_a((IChatComponent)new ChatComponentTranslation("serverutilities.lang.team.gui.members.requesting_invite", new Object[0]));
        component.func_150258_a(": ");
        component.func_150257_a(StringUtils.color(p.getDisplayName(), EnumChatFormatting.BLUE));
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team status " + p.getName() + " member"));
        for (ForgePlayer player : team.getPlayersWithStatus(EnumTeamStatus.MOD)) {
            if (!player.isOnline()) continue;
            player.getPlayer().func_145747_a((IChatComponent)new ChatComponentTranslation("serverutilities.lang.team.gui.members.requesting_invite", new Object[0]));
        }
    }
}

