/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.IGuiWrapper;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.WrappedIngredient;
import serverutils.lib.util.misc.MouseButton;

public class GuiContainerWrapper
extends GuiContainer
implements IGuiWrapper {
    private final GuiBase wrappedGui;
    private boolean drawSlots = true;
    private final List<String> tempTextList = new ArrayList<String>();

    public GuiContainerWrapper(GuiBase g, Container c) {
        super(c);
        this.wrappedGui = g;
    }

    public GuiContainerWrapper disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.wrappedGui.initGui();
        this.field_147003_i = this.wrappedGui.getX();
        this.field_147009_r = this.wrappedGui.getY();
        this.field_146999_f = this.wrappedGui.width;
        this.field_147000_g = this.wrappedGui.height;
    }

    public boolean func_73868_f() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        this.wrappedGui.updateMouseOver(mouseX, mouseY);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
        } else if (!this.wrappedGui.mousePressed(MouseButton.get(button))) {
            super.func_73864_a(mouseX, mouseY, button);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        this.wrappedGui.updateMouseOver(mouseX, mouseY);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        super.func_146286_b(mouseX, mouseY, button);
    }

    protected void func_73869_a(char keyChar, int key) {
        if (this.wrappedGui.keyPressed(key, keyChar)) {
            return;
        }
        if (key == 14) {
            this.wrappedGui.onBack();
            return;
        }
        if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(false);
            return;
        }
        super.func_73869_a(keyChar, key);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.wrappedGui.mouseScrolled(scroll / 120);
        }
    }

    public void func_146282_l() {
        if (!(Keyboard.getEventKey() == 0 && Keyboard.getEventCharacter() >= ' ' || Keyboard.getEventKeyState())) {
            this.wrappedGui.keyReleased(Keyboard.getEventKey());
        } else {
            super.func_146282_l();
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(true);
        }
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.func_146276_q_();
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(theme, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (Slot slot : this.field_147002_h.field_75151_b) {
                theme.drawContainerSlot(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 16, 16);
            }
        }
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(false);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(true);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(-this.field_147003_i), (double)(-this.field_147009_r), 0.0);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(theme, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.wrappedGui.contextMenu != null) {
            this.wrappedGui.contextMenu.addMouseOverText(this.tempTextList);
        } else {
            this.wrappedGui.addMouseOverText(this.tempTextList);
        }
        if (this.tempTextList.isEmpty()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.func_146285_a(stack, mouseX, mouseY);
            }
        } else {
            this.drawHoveringText(this.tempTextList, mouseX, Math.max(mouseY, 18), theme.getFont());
        }
        this.tempTextList.clear();
        if (this.wrappedGui.contextMenu == null) {
            this.func_146283_a(this.tempTextList, mouseX, mouseY);
        }
        GlStateManager.popMatrix();
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(false);
        }
    }

    public void func_146276_q_() {
        if (this.wrappedGui.drawDefaultBackground()) {
            super.func_146276_q_();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.wrappedGui.tick();
    }

    @Override
    public GuiBase getGui() {
        return this.wrappedGui;
    }
}

