/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.misc;

import javax.annotation.Nullable;
import serverutils.lib.util.CommonUtils;

public abstract class NullableOptional<T> {
    private static final NullableOptional<?> EMPTY = new NullableOptional<Object>(){

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        @Nullable
        public Object get() {
            throw new IllegalStateException();
        }

        @Override
        public Object getNonNull() {
            throw new NullPointerException();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "empty";
        }
    };
    private static final NullableOptional<?> NULL = new NullableOptional<Object>(){

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        @Nullable
        public Object get() {
            return null;
        }

        @Override
        public Object getNonNull() {
            throw new NullPointerException();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }
    };

    public static NullableOptional empty() {
        return EMPTY;
    }

    public static <E> NullableOptional<E> of(@Nullable E object) {
        return object == null ? (NullableOptional)CommonUtils.cast(NULL) : new Value(object);
    }

    private NullableOptional() {
    }

    public abstract boolean isPresent();

    public abstract boolean isNonNull();

    @Nullable
    public abstract T get();

    public abstract T getNonNull();

    private static class Value<E>
    extends NullableOptional<E> {
        private final E value;

        private Value(E v) {
            this.value = v;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public boolean isNonNull() {
            return true;
        }

        @Override
        public E get() {
            return this.value;
        }

        @Override
        public E getNonNull() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Value && this.value.equals(((Value)obj).value);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

