/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.statements.IActionExternal;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.rf.RedstoneFluxPlugin;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryConcatenator;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy")})
public class TileRollingMachine
extends TileMachineBase
implements IEnergyHandler,
ISidedInventory,
IHasWork {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 50;
    private static final int MAX_RECEIVE = 1000;
    private static final int MAX_ENERGY = 5000;
    private static final int SLOT_RESULT = 0;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 10);
    private final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingContainer(), 3, 3);
    private final StandaloneInventory invResult = new StandaloneInventory(1, "invResult", (IInventory)this);
    private final IInventory inv = InventoryConcatenator.make().add(this.invResult).add((IInventory)this.craftMatrix);
    private Object energyStorage;
    public boolean useLast;
    private boolean isWorking;
    private boolean paused;
    private ItemStack currentReceipe;
    private int progress;
    private final AdjacentInventoryCache cache = new AdjacentInventoryCache(this, this.tileCache, null, InventorySorter.SIZE_DECENDING);
    private final Set<IActionExternal> actions = new HashSet<IActionExternal>();

    public TileRollingMachine() {
        if (RailcraftConfig.machinesRequirePower()) {
            this.energyStorage = RedstoneFluxPlugin.createEnergyStorage(5000, 1000);
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROLLING_MACHINE;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("progress", this.progress);
        if (this.energyStorage != null) {
            ((EnergyStorage)this.energyStorage).writeToNBT(data);
        }
        this.invResult.writeToNBT("invResult", data);
        InvTools.writeInvToNBT((IInventory)this.craftMatrix, "Crafting", data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.progress = data.func_74762_e("progress");
        if (this.energyStorage != null) {
            ((EnergyStorage)this.energyStorage).readFromNBT(data);
        }
        this.invResult.readFromNBT("invResult", data);
        InvTools.readInvFromNBT((IInventory)this.craftMatrix, "Crafting", data);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ROLLING_MACHINE, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void func_70296_d() {
        this.craftMatrix.func_70296_d();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        this.balanceSlots();
        if (this.clock % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        if (this.clock % 8 == 0) {
            this.currentReceipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentReceipe != null) {
                this.findMoreStuff();
            }
        }
        if (this.currentReceipe != null && this.canMakeMore()) {
            if (this.progress >= 100) {
                this.isWorking = false;
                if (InvTools.isRoomForStack(this.currentReceipe, this.invResult)) {
                    this.currentReceipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_145850_b);
                    if (this.currentReceipe != null) {
                        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                            this.craftMatrix.func_70298_a(i, 1);
                        }
                        InvTools.moveItemStack(this.currentReceipe, this.invResult);
                    }
                    this.useLast = false;
                    this.progress = 0;
                }
            } else {
                this.isWorking = true;
                if (this.energyStorage != null) {
                    int energy = ((EnergyStorage)this.energyStorage).extractEnergy(50, true);
                    if (energy >= 50) {
                        ++this.progress;
                        ((EnergyStorage)this.energyStorage).extractEnergy(50, false);
                    }
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
            this.isWorking = false;
        }
    }

    private void balanceSlots() {
        for (IInvSlot slotA : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
            ItemStack stackA = slotA.getStackInSlot();
            if (stackA == null) continue;
            for (IInvSlot slotB : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
                ItemStack stackB;
                if (slotA.getIndex() == slotB.getIndex() || (stackB = slotB.getStackInSlot()) == null || !InvTools.isItemEqual(stackA, stackB) || stackA.field_77994_a <= stackB.field_77994_a + 1) continue;
                --stackA.field_77994_a;
                ++stackB.field_77994_a;
                return;
            }
        }
    }

    private void findMoreStuff() {
        Collection<IInventory> chests = this.cache.getAdjacentInventories();
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !stack.func_77985_e() || stack.field_77994_a != 1) continue;
            ItemStack request = InvTools.removeOneItem(chests, (IStackFilter)new ArrayStackFilter(stack));
            if (request != null) {
                ++stack.field_77994_a;
                break;
            }
            if (stack.field_77994_a <= 1) continue;
            break;
        }
    }

    @Override
    public boolean hasWork() {
        return this.isWorking;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IActionExternal action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IActionExternal action) {
        this.actions.add(action);
    }

    public boolean canMakeMore() {
        if (RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_145850_b) == null) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack slot = this.craftMatrix.func_70301_a(i);
            if (slot == null || slot.field_77994_a > 1) continue;
            return false;
        }
        return true;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!stack.func_77985_e()) {
            return false;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return false;
        }
        return this.func_70301_a(slot) != null;
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inv.func_70298_a(slot, count);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }

    public String func_145825_b() {
        return this.getName();
    }

    public Object getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean canConnectEnergy(ForgeDirection side) {
        return this.energyStorage != null;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.energyStorage == null) {
            return 0;
        }
        return ((EnergyStorage)this.energyStorage).receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.energyStorage == null) {
            return 0;
        }
        return ((EnergyStorage)this.energyStorage).getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.energyStorage == null) {
            return 0;
        }
        return ((EnergyStorage)this.energyStorage).getMaxEnergyStored();
    }

    private static class RollingContainer
    extends Container {
        private RollingContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }
}

