/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.factory.test;

import gregtech.api.factory.test.TestFactoryElement;
import gregtech.api.factory.test.TestFactoryGrid;
import gregtech.api.factory.test.TestFactoryNetwork;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.Collection;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.pipe.MTEBaseFactoryPipe;

public class TestFactoryPipe
extends MTEBaseFactoryPipe
implements TestFactoryElement {
    private TestFactoryNetwork network;

    public TestFactoryPipe(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TestFactoryPipe(TestFactoryPipe prototype) {
        super(prototype);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TestFactoryPipe(this);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74778_a("network", this.network == null ? "null" : this.network.toString());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add("Network: " + accessor.getNBTData().func_74779_i("network"));
    }

    @Override
    public boolean canConnectOnSide(ForgeDirection side) {
        return true;
    }

    @Override
    public void getNeighbours(Collection<TestFactoryElement> neighbours) {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        if (base == null || base.isDead()) {
            return;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TestFactoryElement element;
            IMetaTileEntity iMetaTileEntity;
            IGregTechTileEntity igte;
            TileEntity tileEntity = base.getTileEntityAtSide(dir);
            if (!(tileEntity instanceof IGregTechTileEntity) || (igte = (IGregTechTileEntity)tileEntity).getColorization() != base.getColorization() || !((iMetaTileEntity = igte.getMetaTileEntity()) instanceof TestFactoryElement) || !(element = (TestFactoryElement)((Object)iMetaTileEntity)).canConnectOnSide(dir.getOpposite())) continue;
            neighbours.add(element);
        }
    }

    @Override
    public void onNeighbourChanged(TestFactoryElement neighbour) {
        this.mCheckConnections = true;
    }

    @Override
    protected void checkConnections() {
        this.mConnections = 0;
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        if (base == null || base.isDead()) {
            return;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TestFactoryElement element;
            IMetaTileEntity iMetaTileEntity;
            IGregTechTileEntity igte;
            TileEntity tileEntity = base.getTileEntityAtSide(dir);
            if (!(tileEntity instanceof IGregTechTileEntity) || (igte = (IGregTechTileEntity)tileEntity).getColorization() != base.getColorization() || !((iMetaTileEntity = igte.getMetaTileEntity()) instanceof TestFactoryElement) || !(element = (TestFactoryElement)((Object)iMetaTileEntity)).canConnectOnSide(dir.getOpposite())) continue;
            this.mConnections = (byte)(this.mConnections | dir.flag);
        }
    }

    @Override
    protected void checkActive() {
        this.mIsActive = this.getBaseMetaTileEntity().getTimer() % 200L > 100L;
    }

    @Override
    public TestFactoryNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(TestFactoryNetwork network) {
        this.network = network;
        this.mCheckConnections = true;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        TestFactoryGrid.INSTANCE.addElement(this);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        TestFactoryGrid.INSTANCE.removeElement(this);
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        TestFactoryGrid.INSTANCE.addElement(this);
    }
}

