/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.hazards.HazardProtection;
import gregtech.api.items.GTGenericItem;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTUtility;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2Potion;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBreederCell
extends GTGenericItem
implements IReactorComponent {
    protected final int mHeatBonusStep;
    protected final int mHeatBonusMultiplier;
    protected ItemStack mProduct;
    protected boolean deflector = false;
    protected boolean hidden = false;
    protected boolean neiAdded = false;

    public ItemBreederCell(String aUnlocalized, String aEnglish, String aEnglishTooltip, int aHeatBonusStep, int aHeatBonusMultiplier, int aRequiredPulse, Supplier<ItemStack> aProduct) {
        super(aUnlocalized, aEnglish, aEnglishTooltip);
        this.mHeatBonusStep = aHeatBonusStep;
        this.mHeatBonusMultiplier = aHeatBonusMultiplier;
        this.func_77656_e(aRequiredPulse);
        this.setNoRepair();
        GregTechAPI.sAfterGTPostload.add(() -> {
            this.mProduct = (ItemStack)aProduct.get();
            if (!this.hidden && !this.neiAdded) {
                GTValues.RA.stdBuilder().itemInputs(new ItemStack((Item)this)).itemOutputs(this.mProduct).setNEIDesc(GTUtility.breakLines(StatCollector.func_74838_a((String)(this.deflector ? "GT5U.nei.nuclear.breeder.neutron_reflecting" : "GT5U.nei.nuclear.breeder.heat_neutral")), StatCollector.func_74837_a((String)"GT5U.nei.nuclear.breeder.reactor_hull_heat", (Object[])new Object[]{this.mHeatBonusStep, this.mHeatBonusMultiplier}), StatCollector.func_74837_a((String)"GT5U.nei.nuclear.breeder.required_pulse", (Object[])new Object[]{this.func_77612_l()}))).duration(0).eut(0).addTo(RecipeMaps.ic2NuclearFakeRecipes);
                this.neiAdded = true;
            }
        });
    }

    public ItemBreederCell setDeflector() {
        this.deflector = true;
        return this;
    }

    public ItemBreederCell setHidden() {
        this.hidden = true;
        return this;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLivingBase && !HazardProtection.isWearingFullRadioHazmat(entityLiving = (EntityLivingBase)entity)) {
            IC2Potion.radiation.applyTo(entityLiving, 20, 1);
        }
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        EnumChatFormatting enumChatFormatting;
        aList.add(StatCollector.func_74838_a((String)"gt.item.desc.breeder_tip"));
        int rDmg = aStack.func_77960_j() * 4 / this.func_77612_l();
        switch (rDmg) {
            case 0: {
                enumChatFormatting = EnumChatFormatting.DARK_GRAY;
                break;
            }
            case 1: 
            case 2: {
                enumChatFormatting = EnumChatFormatting.GRAY;
                break;
            }
            default: {
                enumChatFormatting = EnumChatFormatting.WHITE;
            }
        }
        EnumChatFormatting color2 = enumChatFormatting;
        aList.add(StatCollector.func_74837_a((String)"gt.item.desc.progress", (Object[])new Object[]{color2 + GTUtility.formatNumbers(aStack.func_77960_j()) + EnumChatFormatting.RESET, GTUtility.formatNumbers(this.func_77612_l())}));
        if (aStack.func_77960_j() > 0) {
            aList.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"gt.item.desc.haz_rad"));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77960_j() == 0 ? this.field_77777_bU : 1;
    }

    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
    }

    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        if (heatrun) {
            int myLevel = this.getNewDamage(reactor, yourStack);
            if (myLevel >= this.func_77612_l()) {
                reactor.setItemAt(youX, youY, this.mProduct.func_77946_l());
            } else {
                yourStack.func_77964_b(myLevel);
            }
        }
        return this.deflector;
    }

    protected int getNewDamage(IReactor reactor, ItemStack stack) {
        return stack.func_77960_j() + 1 + reactor.getHeat() / this.mHeatBonusStep * this.mHeatBonusMultiplier;
    }

    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return heat;
    }

    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }
}

