/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.metadata;

import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.IRecipeMetadataStorage;
import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public final class RecipeMetadataStorage
implements IRecipeMetadataStorage {
    private final Map<RecipeMetadataKey<?>, Object> metadata = new LinkedHashMap();

    public RecipeMetadataStorage() {
    }

    private RecipeMetadataStorage(Map<RecipeMetadataKey<?>, Object> metadata) {
        this.metadata.putAll(metadata);
    }

    @Override
    public <T> void store(RecipeMetadataKey<T> key, @Nullable T value) {
        this.metadata.put(key, key.cast(value));
    }

    @Override
    @Nullable
    public <T> T getMetadata(RecipeMetadataKey<T> key) {
        return key.cast(this.metadata.get(key));
    }

    @Override
    @Nullable
    @Contract(value="_, !null -> !null")
    public <T> T getMetadataOrDefault(RecipeMetadataKey<T> key, @Nullable T defaultValue) {
        return key.cast(this.metadata.getOrDefault(key, defaultValue));
    }

    @Override
    public Set<Map.Entry<RecipeMetadataKey<?>, Object>> getEntries() {
        return this.metadata.entrySet();
    }

    @Override
    public IRecipeMetadataStorage copy() {
        return new RecipeMetadataStorage(this.metadata);
    }
}

