/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.load;

import gregtech.api.enums.FluidState;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.fluid.GTFluidFactory;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class FuelLoader
implements Runnable {
    @Override
    public void run() {
        GTLog.out.println("GTMod: Initializing various Fuels.");
        ItemList.sBlueVitriol = GTFluidFactory.of("solution.bluevitriol", "Blue Vitriol Water Solution", null, FluidState.LIQUID, 295);
        ItemList.sNickelSulfate = GTFluidFactory.of("solution.nickelsulfate", "Nickel Sulfate Water Solution", null, FluidState.LIQUID, 295);
        ItemList.sGreenVitriol = GTFluidFactory.of("solution.greenvitriol", "Green Vitriol Water Solution", null, FluidState.LIQUID, 295);
        ItemList.sIndiumConcentrate = GTFluidFactory.of("indiumconcentrate", "Indium Concentrate", null, FluidState.LIQUID, 295);
        ItemList.sLeadZincSolution = GTFluidFactory.of("leadzincsolution", "Lead-Zinc Solution", null, FluidState.LIQUID, 295);
        ItemList.sRocketFuel = GTFluidFactory.of("rocket_fuel", "Rocket Fuel", null, FluidState.LIQUID, 295);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.bolt, Materials.NaquadahEnriched, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.bolt, Materials.Naquadah, 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 50000).addTo(RecipeMaps.smallNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.NaquadahEnriched, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.Naquadah, 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 250000).addTo(RecipeMaps.largeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.NaquadahEnriched, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Naquadah, 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 500000).addTo(RecipeMaps.hugeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.bolt, Materials.Naquadria, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.bolt, Materials.Naquadah, 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 250000).addTo(RecipeMaps.extremeNaquadahReactorFuels);
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.Naquadria, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.Naquadah, 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 1000000).addTo(RecipeMaps.ultraHugeNaquadahReactorFuels);
        if (Mods.BloodMagic.isModLoaded()) {
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "reinforcedSlate", 1L)).itemOutputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "blankSlate", 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 400).addTo(RecipeMaps.magicFuels);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "imbuedSlate", 1L)).itemOutputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "reinforcedSlate", 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 1000).addTo(RecipeMaps.magicFuels);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "demonicSlate", 1L)).itemOutputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "imbuedSlate", 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 8000).addTo(RecipeMaps.magicFuels);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "bloodMagicBaseItems", 1L, 27)).itemOutputs(GTModHandler.getModItem(Mods.BloodMagic.ID, "demonicSlate", 1L)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 20000).addTo(RecipeMaps.magicFuels);
        }
        if (Mods.Thaumcraft.isModLoaded()) {
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 4)).metadata(GTRecipeConstants.FUEL_VALUE, 4).metadata(GTRecipeConstants.FUEL_TYPE, 5).addTo(GTRecipeConstants.Fuel);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151062_by, 1)).metadata(GTRecipeConstants.FUEL_VALUE, 10).metadata(GTRecipeConstants.FUEL_TYPE, 5).addTo(GTRecipeConstants.Fuel);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151073_bk, 1)).metadata(GTRecipeConstants.FUEL_VALUE, 50).metadata(GTRecipeConstants.FUEL_TYPE, 5).addTo(GTRecipeConstants.Fuel);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack((Block)Blocks.field_150461_bJ, 1)).metadata(GTRecipeConstants.FUEL_VALUE, Materials.NetherStar.mFuelPower * 2).metadata(GTRecipeConstants.FUEL_TYPE, Materials.NetherStar.mFuelType).addTo(GTRecipeConstants.Fuel);
        if (Mods.EnderIO.isModLoaded()) {
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.EnderIO.ID, "bucketRocket_fuel", 1L)).metadata(GTRecipeConstants.FUEL_VALUE, 250).metadata(GTRecipeConstants.FUEL_TYPE, 1).addTo(GTRecipeConstants.Fuel);
        }
    }
}

