/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class ProcessingRotor
implements IOreRecipeRegistrator {
    public ProcessingRotor() {
        OrePrefixes.rotor.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_WORKING)) {
            ItemStack tPlate = GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L);
            ItemStack tRing = GTOreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L);
            if (GTUtility.isStackValid(tPlate) && GTUtility.isStackValid(tRing)) {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L), GTModHandler.RecipeBits.BITS_STD, new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('R'), OrePrefixes.ring.get(aMaterial), Character.valueOf('S'), OrePrefixes.screw.get(aMaterial)});
                }
                GTValues.RA.stdBuilder().itemInputs(tPlate.func_77946_l(), tRing.func_77946_l(), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L)).fluidInputs(Materials.Tin.getMolten(32L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.assemblerRecipes);
                GTValues.RA.stdBuilder().itemInputs(tPlate.func_77946_l(), tRing.func_77946_l(), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L)).fluidInputs(Materials.Lead.getMolten(48L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.assemblerRecipes);
                GTValues.RA.stdBuilder().itemInputs(tPlate.func_77946_l(), tRing.func_77946_l(), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L)).fluidInputs(Materials.SolderingAlloy.getMolten(16L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.assemblerRecipes);
            }
            if (GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) != null) {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 5L), ItemList.Shape_Extruder_Rotor.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.extruderRecipes);
            }
            if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
                GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rotor.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.rotor, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(612L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.fluidSolidifierRecipes);
            }
        }
    }
}

