/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import tectech.TecTech;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;

public class MTESmeltingModule
extends MTEBaseModule {
    private long EUt = 0L;
    private long currentParallel = 0L;
    private boolean furnaceMode = false;
    long wirelessEUt = 0L;

    public MTESmeltingModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTESmeltingModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESmeltingModule(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return this.furnaceMode ? RecipeMaps.furnaceRecipes : RecipeMaps.blastFurnaceRecipes;
    }

    @Override
    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.blastFurnaceRecipes, RecipeMaps.furnaceRecipes);
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.mSpecialValue > MTESmeltingModule.this.getHeat()) {
                    return CheckRecipeResultRegistry.insufficientHeat(recipe.mSpecialValue);
                }
                if ((long)recipe.mEUt > MTESmeltingModule.this.getProcessingVoltage()) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                MTESmeltingModule.this.wirelessEUt = (long)recipe.mEUt * (long)MTESmeltingModule.this.getActualParallel();
                if (WirelessNetworkManager.getUserEU(MTESmeltingModule.this.userUUID).compareTo(BigInteger.valueOf(MTESmeltingModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower(MTESmeltingModule.this.wirelessEUt * (long)recipe.mDuration);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                BigInteger powerForRecipe = BigInteger.valueOf(this.calculatedEut).multiply(BigInteger.valueOf(this.duration));
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTESmeltingModule.this.userUUID, powerForRecipe.negate())) {
                    return CheckRecipeResultRegistry.insufficientStartupPower(powerForRecipe);
                }
                MTESmeltingModule.this.addToPowerTally(powerForRecipe);
                if (!MTESmeltingModule.this.furnaceMode) {
                    MTESmeltingModule.this.addToRecipeTally(this.calculatedParallels);
                }
                MTESmeltingModule.this.currentParallel = this.calculatedParallels;
                MTESmeltingModule.this.EUt = this.calculatedEut;
                this.overwriteCalculatedEut(0L);
                MTESmeltingModule.this.setCurrentRecipeHeat(recipe.mSpecialValue);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTESmeltingModule.this.getSafeProcessingVoltage()).setRecipeHeat(recipe.mSpecialValue).setHeatOC(true).setHeatDiscount(true).setMachineHeat(Math.max(recipe.mSpecialValue, MTESmeltingModule.this.getHeatForOC())).setHeatDiscountMultiplier(MTESmeltingModule.this.getHeatEnergyDiscount()).setDurationDecreasePerOC(MTESmeltingModule.this.getOverclockTimeFactor());
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setUnlimitedTierSkips();
        logic.setMaxParallel(this.getActualParallel());
        logic.setSpeedBonus(this.getSpeedBonus());
        logic.setEuModifier(this.getEnergyDiscount());
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)this.createFurnaceModeButton((IWidgetBuilder<?>)builder));
    }

    protected ButtonWidget createFurnaceModeButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.furnaceMode = !this.furnaceMode;
            widget.notifyTooltipChange();
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_CELESTIAL_32x32);
            if (this.isFurnaceModeOn()) {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_FURNACE_MODE);
            } else {
                ret.add(TecTechUITextures.OVERLAY_BUTTON_FURNACE_MODE_OFF);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isFurnaceModeOn, this::setFurnaceMode), builder).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74838_a((String)(this.furnaceMode ? "fog.button.furnacemode.tooltip.02" : "fog.button.furnacemode.tooltip.01")))).setTooltipShowUpDelay(5).setPos(174, 91).setSize(16, 16);
        return (ButtonWidget)button;
    }

    private boolean isFurnaceModeOn() {
        return this.furnaceMode;
    }

    private void setFurnaceMode(boolean enabled) {
        this.furnaceMode = enabled;
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        NBT2.func_74757_a("furnaceMode", this.furnaceMode);
        super.saveNBTData(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        this.furnaceMode = NBT2.func_74767_n("furnaceMode");
        super.loadNBTData(NBT2);
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add(StatCollector.func_74837_a((String)"GT5U.infodata.progress", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET}));
        str.add(StatCollector.func_74837_a((String)"tt.infodata.multi.currently_using", (Object[])new Object[]{EnumChatFormatting.RED + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.EUt) : "0") + EnumChatFormatting.RESET}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.max_parallel", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getActualParallel())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"GT5U.infodata.parallel.current", (Object[])new Object[]{EnumChatFormatting.RESET + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.currentParallel) : "0")}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.capacity.heat", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getHeat())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.capacity.heat.effective", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getHeatForOC())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.multiplier.recipe_time", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getSpeedBonus())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.multiplier.energy", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getEnergyDiscount())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.divisor.recipe_time.non_perfect_oc", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getOverclockTimeFactor())}));
        return str.toArray(new String[0]);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Blast Furnace, Furnace").addInfo("This is a module of the Godforge").addInfo("Must be part of a Godforge to function").addInfo("Used for basic smelting operations at various temperatures").addSeparator(EnumChatFormatting.AQUA, 74).addInfo("As the first of the Godforge modules, this module performs the most basic").addInfo("thermal processing, namely smelting materials identically to a furnace or blast furnace").addInfo("The desired method of processing can be selected in the gui").addInfo("This module is specialized towards speed and high heat levels").beginStructureBlock(7, 7, 13, false).addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Singularity Reinforced Stellar Shielding Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Boundless Gravitationally Severed Structure Casing").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Hypogen Coil Block").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Celestial Matter Guidance Casing").addStructureInfo(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").toolTipFinisher(EnumChatFormatting.AQUA, 74, new String[0]);
        return tt;
    }
}

