/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.utils.LittleTileBlockPos;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraftforge.common.util.ForgeDirection;

public class LittlePlacePacket
extends CreativeCorePacket {
    public ItemStack stack;
    public LittleTileBlockPos pos;
    public boolean customPlacement;

    public LittlePlacePacket() {
    }

    public LittlePlacePacket(ItemStack stack, LittleTileBlockPos pos, boolean customPlacement) {
        this.stack = stack;
        this.pos = pos;
        this.customPlacement = customPlacement;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeInt(this.pos.getPosX());
        buf.writeInt(this.pos.getPosY());
        buf.writeInt(this.pos.getPosZ());
        buf.writeInt(this.pos.getSubX());
        buf.writeInt(this.pos.getSubY());
        buf.writeInt(this.pos.getSubZ());
        buf.writeInt(this.pos.getSide().ordinal());
        buf.writeBoolean(this.customPlacement);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        int subX = buf.readInt();
        int subY = buf.readInt();
        int subZ = buf.readInt();
        int side = buf.readInt();
        this.pos = new LittleTileBlockPos(posX, posY, posZ, subX, subY, subZ, ForgeDirection.getOrientation((int)side));
        this.customPlacement = buf.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    @Override
    public void executeServer(EntityPlayer player) {
        if (PlacementHelper.isLittleBlock(this.stack)) {
            PlacementHelper helper = PlacementHelper.getInstance(player);
            ((ItemBlockTiles)Item.func_150898_a((Block)LittleTiles.blockTile)).placeBlockAt(player, this.stack, player.field_70170_p, this.pos, helper, this.customPlacement);
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
            playerMP.field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
        }
    }
}

