/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;

public enum Enchant {
    SHARPNESS,
    SMITE,
    ARTHOPODS,
    LOOTING,
    KNOCKBACK,
    FIREASPECT,
    AQUAAFFINITY,
    RESPIRATION,
    FEATHERFALLING,
    DEPTHSTRIDER,
    PROTECTION,
    BLASTPROTECTION,
    FIREPROTECTION,
    PROJECTILEPROTECTION,
    THORNS,
    UNBREAKING,
    EFFICIENCY,
    SILKTOUCH,
    FORTUNE,
    POWER,
    PUNCH,
    FLAME,
    INFINITY,
    LURE,
    LUCKOFTHESEA;


    public static Enchantment getEnchant(Enchant type) {
        switch (type) {
            case SHARPNESS: {
                return Enchantment.field_77338_j;
            }
            case SMITE: {
                return Enchantment.field_77339_k;
            }
            case ARTHOPODS: {
                return Enchantment.field_77336_l;
            }
            case LOOTING: {
                return Enchantment.field_77335_o;
            }
            case KNOCKBACK: {
                return Enchantment.field_77337_m;
            }
            case FIREASPECT: {
                return Enchantment.field_77334_n;
            }
            case AQUAAFFINITY: {
                return Enchantment.field_77341_i;
            }
            case RESPIRATION: {
                return Enchantment.field_77340_h;
            }
            case FEATHERFALLING: {
                return Enchantment.field_77330_e;
            }
            case DEPTHSTRIDER: {
                return Enchantment.field_77330_e;
            }
            case PROTECTION: {
                return Enchantment.field_77332_c;
            }
            case BLASTPROTECTION: {
                return Enchantment.field_77327_f;
            }
            case FIREPROTECTION: {
                return Enchantment.field_77329_d;
            }
            case PROJECTILEPROTECTION: {
                return Enchantment.field_77328_g;
            }
            case THORNS: {
                return Enchantment.field_92091_k;
            }
            case UNBREAKING: {
                return Enchantment.field_77347_r;
            }
            case EFFICIENCY: {
                return Enchantment.field_77349_p;
            }
            case SILKTOUCH: {
                return Enchantment.field_77348_q;
            }
            case FORTUNE: {
                return Enchantment.field_77346_s;
            }
            case POWER: {
                return Enchantment.field_77345_t;
            }
            case FLAME: {
                return Enchantment.field_77343_v;
            }
            case INFINITY: {
                return Enchantment.field_77342_w;
            }
            case LURE: {
                return Enchantment.field_77349_p;
            }
            case LUCKOFTHESEA: {
                return Enchantment.field_77346_s;
            }
        }
        return Enchantment.field_77349_p;
    }

    public static int getLevel(Random rand, int level) {
        switch (level) {
            case 4: {
                return 21 + rand.nextInt(10);
            }
            case 3: {
                return 16 + rand.nextInt(10);
            }
            case 2: {
                return 5 + rand.nextInt(10);
            }
            case 1: {
                return 1 + rand.nextInt(5);
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    public static boolean canEnchant(EnumDifficulty difficulty, Random rand, int level) {
        if (difficulty == null) {
            difficulty = EnumDifficulty.NORMAL;
        }
        switch (difficulty) {
            case PEACEFUL: {
                return false;
            }
            case EASY: {
                return rand.nextInt(5) == 0;
            }
            case NORMAL: {
                return level >= 3 || rand.nextBoolean();
            }
            case HARD: {
                return true;
            }
        }
        return true;
    }

    public static void enchantItem(Random rand, ItemStack item, int enchantLevel) {
        boolean isBook;
        if (item == null) {
            return;
        }
        List enchants = null;
        enchants = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)item, (int)enchantLevel);
        boolean bl = isBook = item.func_77973_b() == Items.field_151122_aG;
        if (isBook) {
            item.func_150996_a((Item)Items.field_151134_bR);
            if (enchants.size() > 1) {
                enchants.remove(rand.nextInt(enchants.size()));
            }
        }
        for (EnchantmentData toAdd : enchants) {
            if (isBook) {
                Items.field_151134_bR.func_92115_a(item, toAdd);
                continue;
            }
            item.func_77966_a(toAdd.field_76302_b, toAdd.field_76303_c);
        }
    }
}

