/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board.squares;

public final class Rank
extends Enum<Rank> {
    public static final /* enum */ Rank RANK_8 = new Rank(0, "8");
    public static final /* enum */ Rank RANK_7 = new Rank(1, "7");
    public static final /* enum */ Rank RANK_6 = new Rank(2, "6");
    public static final /* enum */ Rank RANK_5 = new Rank(3, "5");
    public static final /* enum */ Rank RANK_4 = new Rank(4, "4");
    public static final /* enum */ Rank RANK_3 = new Rank(5, "3");
    public static final /* enum */ Rank RANK_2 = new Rank(6, "2");
    public static final /* enum */ Rank RANK_1 = new Rank(7, "1");
    private static Rank[] ranks_arr;
    private int value;
    private String label;
    private static final /* synthetic */ Rank[] $VALUES;

    public static Rank[] values() {
        return (Rank[])$VALUES.clone();
    }

    public static Rank valueOf(String name) {
        return Enum.valueOf(Rank.class, name);
    }

    private Rank(int value, String label) {
        this.value = value;
        this.label = label;
    }

    public static Rank rank(int value) {
        assert (value >= 0 && value <= 7);
        return ranks_arr[value];
    }

    public static Rank rank(String value) {
        for (Rank r : Rank.values()) {
            if (!r.getLabel().equalsIgnoreCase(value)) continue;
            return r;
        }
        throw new IllegalArgumentException("Rank value not found: " + value);
    }

    public int distance(Rank r) {
        return Math.abs(r.getValue() - this.getValue());
    }

    public Rank flip() {
        return Rank.rank(7 - this.value);
    }

    public String getLabel() {
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isPromotionRank() {
        return this.value == RANK_1.getValue() || this.value == RANK_8.getValue();
    }

    public Rank north() {
        if (this.value == 0) {
            return null;
        }
        return Rank.rank(this.value - 1);
    }

    public boolean northOf(Rank r) {
        return this.getValue() < r.getValue();
    }

    public Rank south() {
        if (this.value == 7) {
            return null;
        }
        return Rank.rank(this.value + 1);
    }

    public boolean southOf(Rank r) {
        return this.getValue() > r.getValue();
    }

    static {
        $VALUES = new Rank[]{RANK_8, RANK_7, RANK_6, RANK_5, RANK_4, RANK_3, RANK_2, RANK_1};
        ranks_arr = new Rank[8];
        for (int i = 0; i < 8; ++i) {
            for (Rank r : Rank.values()) {
                if (r.getValue() != i) continue;
                Rank.ranks_arr[i] = r;
            }
        }
    }
}

