/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.fluids;

import com.google.common.primitives.Ints;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.Nullable;

public interface IFluidTankLong
extends IFluidTank {
    public long fill(Fluid var1, long var2, boolean var4);

    public FluidStack drain(long var1, boolean var3);

    public long getCapacityLong();

    public long getRealCapacityLong();

    public long getFluidAmountLong();

    public FluidStack getFluidStack();

    public Fluid getStoredFluid();

    default public int getFluidAmount() {
        return Ints.saturatedCast((long)this.getFluidAmountLong());
    }

    default public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    default public int fill(FluidStack resource, boolean doFill) {
        return Ints.saturatedCast((long)this.fill(resource.getFluid(), resource.amount, doFill));
    }

    default public FluidStack getFluid() {
        return this.getFluidStack();
    }

    default public int getCapacity() {
        return Ints.saturatedCast((long)this.getCapacityLong());
    }

    default public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain((long)maxDrain, doDrain);
    }

    public void setFluid(Fluid var1, long var2);

    @Nullable
    public IFluidTankLong copy();

    public boolean isFluidEqual(@Nullable IFluidTankLong var1);

    public void saveToNBT(NBTTagCompound var1);

    public void loadFromNBT(NBTTagCompound var1);

    public static void writeToBuffer(PacketBuffer buffer, IFluidTankLong currentFluid) {
        if (currentFluid == null) {
            buffer.writeBoolean(true);
        } else {
            buffer.writeBoolean(false);
            NBTTagCompound fluidTag = new NBTTagCompound();
            currentFluid.saveToNBT(fluidTag);
            try {
                buffer.func_150786_a(fluidTag);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void readFromBuffer(PacketBuffer buffer, IFluidTankLong currentTank) throws IOException {
        currentTank.loadFromNBT(buffer.readBoolean() ? null : buffer.func_150793_b());
    }
}

