/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.handler.codec.serialization;

import java.io.Serializable;
import mcp.mobius.shadow.io.nettyopis.buffer.ByteBuf;
import mcp.mobius.shadow.io.nettyopis.buffer.ByteBufOutputStream;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandler;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandlerContext;
import mcp.mobius.shadow.io.nettyopis.handler.codec.MessageToByteEncoder;
import mcp.mobius.shadow.io.nettyopis.handler.codec.serialization.CompactObjectOutputStream;

@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(bout);
        oout.writeObject(msg);
        oout.flush();
        oout.close();
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

