/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.dimension.SpinManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityThruster;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSpinThruster
extends BlockAdvanced
implements ItemBlockDesc.IBlockShiftDesc {
    public static IIcon thrusterIcon;

    protected BlockSpinThruster(String assetName) {
        super(Material.field_151594_q);
        this.func_149711_c(0.1f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d("stone");
        this.func_149663_c(assetName);
    }

    private static boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection direction) {
        return world.func_147439_a(x, y, z).isSideSolid((IBlockAccess)world, x, y, z, direction);
    }

    public AxisAlignedBB func_149668_a(World par1World, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    public boolean func_149742_c(World par1World, int x, int y, int z) {
        return BlockSpinThruster.isBlockSolidOnSide(par1World, x - 1, y, z, ForgeDirection.EAST) || BlockSpinThruster.isBlockSolidOnSide(par1World, x + 1, y, z, ForgeDirection.WEST) || BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z - 1, ForgeDirection.SOUTH) || BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z + 1, ForgeDirection.NORTH);
    }

    public int func_149660_a(World par1World, int x, int y, int z, int par5, float par6, float par7, float par8, int par9) {
        if (par5 != 2 || BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z + 1, ForgeDirection.NORTH)) {
            // empty if block
        }
        if (par5 != 3 || BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z - 1, ForgeDirection.SOUTH)) {
            // empty if block
        }
        if (par5 != 4 || BlockSpinThruster.isBlockSolidOnSide(par1World, x + 1, y, z, ForgeDirection.WEST)) {
            // empty if block
        }
        if (par5 != 5 || BlockSpinThruster.isBlockSolidOnSide(par1World, x - 1, y, z, ForgeDirection.EAST)) {
            // empty if block
        }
        return 0;
    }

    public void func_149674_a(World par1World, int x, int y, int z, Random par5Random) {
        super.func_149674_a(par1World, x, y, z, par5Random);
        if (par1World.func_72805_g(x, y, z) == 0) {
            this.func_149726_b(par1World, x, y, z);
        }
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        BlockVec3 baseBlock;
        int metadata = par1World.func_72805_g(x, y, z);
        if (metadata == 0) {
            if (BlockSpinThruster.isBlockSolidOnSide(par1World, x - 1, y, z, ForgeDirection.EAST)) {
                metadata = 1;
                par1World.func_72921_c(x, y, z, metadata, 3);
            } else if (BlockSpinThruster.isBlockSolidOnSide(par1World, x + 1, y, z, ForgeDirection.WEST)) {
                metadata = 2;
                par1World.func_72921_c(x, y, z, metadata, 3);
            } else if (BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z - 1, ForgeDirection.SOUTH)) {
                metadata = 3;
                par1World.func_72921_c(x, y, z, metadata, 3);
            } else if (BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z + 1, ForgeDirection.NORTH)) {
                metadata = 4;
                par1World.func_72921_c(x, y, z, metadata, 3);
            }
        }
        switch (metadata) {
            case 1: {
                baseBlock = new BlockVec3(x - 1, y, z);
                break;
            }
            case 2: {
                baseBlock = new BlockVec3(x + 1, y, z);
                break;
            }
            case 3: {
                baseBlock = new BlockVec3(x, y, z - 1);
                break;
            }
            case 4: {
                baseBlock = new BlockVec3(x, y, z + 1);
                break;
            }
            default: {
                this.dropTorchIfCantStay(par1World, x, y, z);
                return;
            }
        }
        if (!par1World.field_72995_K && par1World.field_73011_w instanceof WorldProviderSpaceStation) {
            ((WorldProviderSpaceStation)par1World.field_73011_w).getSpinManager().checkSS(baseBlock, true);
        }
    }

    public void func_149695_a(World par1World, int x, int y, int z, Block par5) {
        if (this.dropTorchIfCantStay(par1World, x, y, z)) {
            int var6 = par1World.func_72805_g(x, y, z) & 7;
            boolean var7 = false;
            if (!BlockSpinThruster.isBlockSolidOnSide(par1World, x - 1, y, z, ForgeDirection.EAST) && var6 == 1) {
                var7 = true;
            }
            if (!BlockSpinThruster.isBlockSolidOnSide(par1World, x + 1, y, z, ForgeDirection.WEST) && var6 == 2) {
                var7 = true;
            }
            if (!BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z - 1, ForgeDirection.SOUTH) && var6 == 3) {
                var7 = true;
            }
            if (!BlockSpinThruster.isBlockSolidOnSide(par1World, x, y, z + 1, ForgeDirection.NORTH) && var6 == 4) {
                var7 = true;
            }
            if (var7) {
                this.func_149697_b(par1World, x, y, z, par1World.func_72805_g(x, y, z), 0);
                par1World.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
        }
        if (!par1World.field_72995_K && par1World.field_73011_w instanceof WorldProviderSpaceStation) {
            ((WorldProviderSpaceStation)par1World.field_73011_w).getSpinManager().checkSS(new BlockVec3(x, y, z), true);
        }
    }

    private boolean dropTorchIfCantStay(World par1World, int x, int y, int z) {
        if (this.func_149742_c(par1World, x, y, z)) {
            return true;
        }
        if (par1World.func_147439_a(x, y, z) == this) {
            this.func_149697_b(par1World, x, y, z, par1World.func_72805_g(x, y, z), 0);
            par1World.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
        return false;
    }

    public MovingObjectPosition func_149731_a(World par1World, int x, int y, int z, Vec3 par5Vec3, Vec3 par6Vec3) {
        int var7 = par1World.func_72805_g(x, y, z) & 7;
        float var8 = 0.3f;
        switch (var7) {
            case 1: {
                this.func_149676_a(0.0f, 0.2f, 0.19999999f, 0.6f, 0.8f, 0.8f);
                break;
            }
            case 2: {
                this.func_149676_a(0.39999998f, 0.2f, 0.19999999f, 1.0f, 0.8f, 0.8f);
                break;
            }
            case 3: {
                this.func_149676_a(0.19999999f, 0.2f, 0.0f, 0.8f, 0.8f, 0.6f);
                break;
            }
            case 4: {
                this.func_149676_a(0.19999999f, 0.2f, 0.39999998f, 0.8f, 0.8f, 1.0f);
                break;
            }
        }
        return super.func_149731_a(par1World, x, y, z, par5Vec3, par6Vec3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int x, int y, int z, Random par5Random) {
        if (par1World.field_73011_w instanceof WorldProviderSpaceStation && (((WorldProviderSpaceStation)par1World.field_73011_w).getSpinManager().thrustersFiring || par5Random.nextInt(80) == 0)) {
            int var6 = par1World.func_72805_g(x, y, z) & 7;
            double var7 = (float)x + 0.5f;
            double var9 = (float)y + 0.7f;
            double var11 = (float)z + 0.5f;
            double var13 = 0.22f;
            double var15 = 0.27f;
            switch (var6) {
                case 1: {
                    par1World.func_72869_a("smoke", var7 - (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    par1World.func_72869_a("smoke", var7 + (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    par1World.func_72869_a("smoke", var7, var9 + (double)0.22f, var11 - (double)0.27f, 0.0, 0.0, 0.0);
                    break;
                }
                case 4: {
                    par1World.func_72869_a("smoke", var7, var9 + (double)0.22f, var11 + (double)0.27f, 0.0, 0.0, 0.0);
                    break;
                }
            }
        }
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = world.func_72805_g(x, y, z);
        int change = 8 + metadata & 0xF;
        world.func_72921_c(x, y, z, change, 2);
        if (world.field_73011_w instanceof WorldProviderSpaceStation && !world.field_72995_K) {
            SpinManager worldOrbital = ((WorldProviderSpaceStation)world.field_73011_w).getSpinManager();
            worldOrbital.checkSS(new BlockVec3(x, y, z), true);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityThruster();
    }

    public void func_149725_f(World world, int x, int y, int z, int metadata) {
        if (!world.field_72995_K) {
            int facing = metadata & 8;
            if (world.field_73011_w instanceof WorldProviderSpaceStation) {
                SpinManager worldOrbital = ((WorldProviderSpaceStation)world.field_73011_w).getSpinManager();
                BlockVec3 baseBlock = new BlockVec3(x, y, z);
                worldOrbital.removeThruster(baseBlock, facing == 0);
                worldOrbital.updateSpinSpeed();
            }
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

