/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.recipe;

import appeng.api.AEApi;
import appeng.api.util.AEColor;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.RocketFuels;
import micdoodle8.mods.galacticraft.core.blocks.BlockEnclosed;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.EntityTier1Rocket;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemBasic;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeManagerGC {
    public static ArrayList<ItemStack> aluminumIngots = new ArrayList();

    public static void loadRecipes() {
        if (CompatibilityManager.isBCraftTransportLoaded()) {
            RecipeManagerGC.addBuildCraftCraftingRecipes();
        }
        if (CompatibilityManager.isIc2Loaded()) {
            RecipeManagerGC.addIndustrialCraft2Recipes();
        }
        if (CompatibilityManager.isAppEngLoaded()) {
            RecipeManagerGC.addAppEngRecipes();
        }
        RecipeManagerGC.addUniversalRecipes();
        RecipeManagerGC.addExNihiloRecipes();
    }

    /*
     * WARNING - void declaration
     */
    private static void addUniversalRecipes() {
        void var8_26;
        void var8_24;
        String[] t2Fuels = new String[]{"fluid.rocketfuelmixa", "fluid.rocketfuelmixb", "fluid.rocketfuelmixc", "fluid.rocketfuelmixd", "nitrofuel", "rocket_fuel"};
        String[] t4Fuels = new String[]{"fluid.rocketfuelmixa", "fluid.rocketfuelmixc", "fluid.rocketfuelmixd", "rocket_fuel"};
        String[] t6Fuels = new String[]{"fluid.rocketfuelmixa", "fluid.rocketfuelmixc", "rocket_fuel"};
        String[] t8Fuels = new String[]{"fluid.rocketfuelmixa", "rocket_fuel"};
        for (String fluidName : t2Fuels) {
            RocketFuels.addFuel(EntityTier1Rocket.class, fluidName);
            RocketFuels.addFuel(EntityTier2Rocket.class, fluidName);
            RocketFuels.addFuel(EntityCargoRocket.class, fluidName);
        }
        for (String fluidName : t4Fuels) {
            RocketFuels.addFuel(EntityTier3Rocket.class, fluidName);
        }
        if (Loader.isModLoaded((String)"GalaxySpace")) {
            try {
                Class<?> rocketT4 = Class.forName("galaxyspace.core.entity.rocket.EntityTier4Rocket");
                Class<?> rocketT5 = Class.forName("galaxyspace.core.entity.rocket.EntityTier5Rocket");
                Class<?> rocketT6 = Class.forName("galaxyspace.core.entity.rocket.EntityTier6Rocket");
                Class<?> rocketT7 = Class.forName("galaxyspace.core.entity.rocket.EntityTier7Rocket");
                Class<?> clazz = Class.forName("galaxyspace.core.entity.rocket.EntityTier8Rocket");
                for (String fluidName : t4Fuels) {
                    RocketFuels.addFuel(rocketT4, fluidName);
                }
                for (String fluidName : t6Fuels) {
                    RocketFuels.addFuel(rocketT5, fluidName);
                    RocketFuels.addFuel(rocketT6, fluidName);
                }
                for (String fluidName : t8Fuels) {
                    RocketFuels.addFuel(rocketT7, fluidName);
                    RocketFuels.addFuel(clazz, fluidName);
                }
            }
            catch (ClassNotFoundException e) {
                GCLog.severe("A GalaxySpace rocket class wasn't found although the mod is installed!");
                GCLog.exception(e);
            }
        }
        if (Loader.isModLoaded((String)"GalacticraftAmunRa")) {
            try {
                Class<?> shuttleRocket = Class.forName("de.katzenpapst.amunra.entity.spaceship.EntityShuttle");
                for (String string : t8Fuels) {
                    RocketFuels.addFuel(shuttleRocket, string);
                }
            }
            catch (ClassNotFoundException e) {
                GCLog.severe("The Amun-Ra shuttle rocket class wasn't found although the mod is installed!");
                GCLog.exception(e);
            }
        }
        Object meteoricIronIngot = ConfigManagerCore.recipesRequireGCAdvancedMetals ? GCItems.meteoricIronIngot : "ingotMeteoricIron";
        String meteoricIronPlate = ConfigManagerCore.recipesRequireGCAdvancedMetals ? new ItemStack(GCItems.meteoricIronIngot, 1, 1) : "compressedMeteoricIron";
        String deshIngot = ConfigManagerCore.recipesRequireGCAdvancedMetals ? new ItemStack(MarsItems.marsItemBasic, 1, 2) : "ingotDesh";
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCBlocks.basicBlock, 1, 5), new ItemStack(GCItems.basicItem, 1, 3), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCBlocks.basicBlock, 1, 6), new ItemStack(GCItems.basicItem, 1, 4), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCBlocks.basicBlock, 1, 7), new ItemStack(GCItems.basicItem, 1, 5), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCItems.meteorChunk, 1, 0), new ItemStack(GCItems.meteorChunk, 1, 1), 0.1f);
        FurnaceRecipes.func_77602_a().func_151396_a(GCItems.meteoricIronRaw, new ItemStack(GCItems.meteoricIronIngot), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCBlocks.blockMoon, 1, 0), new ItemStack(GCItems.basicItem, 1, 3), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCBlocks.blockMoon, 1, 1), new ItemStack(GCItems.basicItem, 1, 4), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCBlocks.blockMoon, 1, 2), new ItemStack(GCItems.cheeseCurd), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCItems.canister, 1, 0), new ItemStack(GCItems.basicItem, 3, 4), 1.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(GCItems.canister, 1, 1), new ItemStack(GCItems.basicItem, 3, 3), 1.0f);
        RecipeUtil.addRecipe(new ItemStack(GCItems.rocketEngine, 1, 1), new Object[]{"ZYZ", "ZWZ", "XVX", Character.valueOf('V'), GCItems.oxygenVent, Character.valueOf('W'), new ItemStack(GCItems.fuelCanister, 1, 1), Character.valueOf('X'), GCItems.heavyPlatingTier1, Character.valueOf('Y'), new ItemStack(Blocks.field_150325_L, 1, 4), Character.valueOf('Z'), meteoricIronPlate});
        aluminumIngots.addAll(OreDictionary.getOres((String)"ingotAluminum"));
        ArrayList<ItemStack> addedList = new ArrayList<ItemStack>();
        for (ItemStack ingotNew : OreDictionary.getOres((String)"ingotAluminium")) {
            boolean flag = false;
            for (ItemStack ingotDone : aluminumIngots) {
                if (!ItemStack.func_77989_b((ItemStack)ingotNew, (ItemStack)ingotDone)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            addedList.add(ingotNew);
            OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)ingotNew);
        }
        if (addedList.size() > 0) {
            aluminumIngots.addAll(addedList);
            addedList.clear();
        }
        for (ItemStack ingotNew : OreDictionary.getOres((String)"ingotNaturalAluminum")) {
            for (ItemStack ingotDone : aluminumIngots) {
                if (ItemStack.func_77989_b((ItemStack)ingotNew, (ItemStack)ingotDone)) continue;
                addedList.add(ingotNew);
            }
        }
        if (addedList.size() > 0) {
            aluminumIngots.addAll(addedList);
        }
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.aluminumWire, 6), new Object[]{"WWW", "CCC", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('C'), "ingotAluminum"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.aluminumWire, 1, 1), new Object[]{"X", "Y", "Z", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), new ItemStack(GCBlocks.aluminumWire, 1), Character.valueOf('Z'), "ingotAluminum"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.aluminumWire, 1, 1), new Object[]{"Z", "Y", "X", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), new ItemStack(GCBlocks.aluminumWire, 1), Character.valueOf('Z'), "ingotAluminum"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineBase, 1, 0), new Object[]{"WWW", "XZX", "XYX", Character.valueOf('W'), "ingotCopper", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('Z'), Blocks.field_150460_al});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineTiered, 1, 0), new Object[]{"SSS", "BBB", "SSS", Character.valueOf('B'), new ItemStack(GCItems.battery, 1, GCItems.battery.func_77612_l()), Character.valueOf('S'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineTiered, 1, 4), new Object[]{"XXX", "XZX", "WYW", Character.valueOf('W'), "compressedAluminum", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "waferBasic", Character.valueOf('Z'), Blocks.field_150460_al});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineTiered, 1, 8), new Object[]{"BSB", "SWS", "BSB", Character.valueOf('B'), new ItemStack(GCBlocks.machineTiered, 1, 0), Character.valueOf('S'), "compressedSteel", Character.valueOf('W'), "waferAdvanced"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineTiered, 1, 12), new Object[]{"XXX", "XZX", "WYW", Character.valueOf('W'), meteoricIronIngot, Character.valueOf('X'), new ItemStack(GCItems.heavyPlatingTier1), Character.valueOf('Y'), "waferAdvanced", Character.valueOf('Z'), new ItemStack(GCBlocks.machineTiered, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineBase, 1, 12), new Object[]{"WXW", "WYW", "WZW", Character.valueOf('W'), "ingotAluminum", Character.valueOf('X'), Blocks.field_150467_bQ, Character.valueOf('Y'), "ingotCopper", Character.valueOf('Z'), "waferBasic"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineBase2, 1, 0), new Object[]{"WXW", "WYW", "VZV", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire), Character.valueOf('W'), "compressedSteel", Character.valueOf('X'), Blocks.field_150467_bQ, Character.valueOf('Y'), "compressedBronze", Character.valueOf('Z'), "waferAdvanced"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineBase2, 1, 4), new Object[]{"WXW", "UYU", "VZV", Character.valueOf('U'), Blocks.field_150430_aB, Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire), Character.valueOf('W'), "ingotAluminum", Character.valueOf('X'), Blocks.field_150442_at, Character.valueOf('Y'), Blocks.field_150460_al, Character.valueOf('Z'), Blocks.field_150429_aA});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.machineBase2, 1, 8), new Object[]{"SSS", "BBB", "SSS", Character.valueOf('B'), new ItemStack(GCItems.oxTankHeavy, 1, GCItems.oxTankHeavy.func_77612_l()), Character.valueOf('S'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.battery, 1, 100), new Object[]{" T ", "TRT", "TCT", Character.valueOf('T'), "compressedTin", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), Items.field_151044_h});
        RecipeUtil.addRecipe(new ItemStack(GCItems.rocketEngine, 1), new Object[]{" YV", "XWX", "XZX", Character.valueOf('V'), Blocks.field_150430_aB, Character.valueOf('W'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('X'), GCItems.heavyPlatingTier1, Character.valueOf('Y'), Items.field_151033_d, Character.valueOf('Z'), GCItems.oxygenVent});
        RecipeUtil.addRecipe(new ItemStack(GCItems.rocketEngine, 1), new Object[]{"VY ", "XWX", "XZX", Character.valueOf('V'), Blocks.field_150430_aB, Character.valueOf('W'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('X'), GCItems.heavyPlatingTier1, Character.valueOf('Y'), Items.field_151033_d, Character.valueOf('Z'), GCItems.oxygenVent});
        RecipeUtil.addRecipe(new ItemStack(GCItems.partNoseCone, 1), new Object[]{" Y ", " X ", "X X", Character.valueOf('X'), GCItems.heavyPlatingTier1, Character.valueOf('Y'), Blocks.field_150429_aA});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenPipe, 6), new Object[]{"XXX", "   ", "XXX", Character.valueOf('X'), Blocks.field_150410_aZ});
        RecipeUtil.addRecipe(new ItemStack(GCItems.oxTankLight, 1, GCItems.oxTankLight.func_77612_l()), new Object[]{"YZY", "YXY", "YYY", Character.valueOf('X'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('Y'), "compressedAluminum", Character.valueOf('Z'), GCBlocks.oxygenPipe});
        RecipeUtil.addRecipe(new ItemStack(GCItems.oxTankLight, 1, GCItems.oxTankLight.func_77612_l()), new Object[]{"YZY", "YXY", "YYY", Character.valueOf('X'), new ItemStack(GCItems.canister, 1, 1), Character.valueOf('Y'), "compressedAluminum", Character.valueOf('Z'), GCBlocks.oxygenPipe});
        RecipeUtil.addRecipe(new ItemStack(GCItems.sensorGlasses, 1), new Object[]{"ZWZ", "Z Z", "XYX", Character.valueOf('W'), Items.field_151045_i, Character.valueOf('X'), GCItems.sensorLens, Character.valueOf('Y'), meteoricIronIngot, Character.valueOf('Z'), Items.field_151007_F});
        RecipeUtil.addRecipe(new ItemStack(GCItems.sensorLens, 1), new Object[]{"ZXZ", "XYX", "ZXZ", Character.valueOf('X'), Blocks.field_150410_aZ, Character.valueOf('Y'), meteoricIronPlate, Character.valueOf('Z'), Items.field_151137_ax});
        if (!ConfigManagerCore.alternateCanisterRecipe) {
            RecipeUtil.addRecipe(new ItemStack(GCItems.canister, 2, 0), new Object[]{"X X", "X X", "XXX", Character.valueOf('X'), "ingotTin"});
            RecipeUtil.addRecipe(new ItemStack(GCItems.canister, 2, 1), new Object[]{"X X", "X X", "XXX", Character.valueOf('X'), "ingotCopper"});
        } else {
            RecipeUtil.addRecipe(new ItemStack(GCItems.canister, 2, 0), new Object[]{"XXX", "X  ", "XXX", Character.valueOf('X'), "ingotTin"});
            RecipeUtil.addRecipe(new ItemStack(GCItems.canister, 2, 1), new Object[]{"XXX", "X  ", "XXX", Character.valueOf('X'), "ingotCopper"});
        }
        RecipeUtil.addRecipe(new ItemStack(GCItems.oxMask, 1), new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150410_aZ, Character.valueOf('Y'), Items.field_151028_Y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.canvas, 1), new Object[]{" XY", "XXX", "YX ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), Items.field_151007_F});
        RecipeUtil.addRecipe(new ItemStack(GCItems.parachute, 1, 0), new Object[]{"XXX", "Y Y", " Y ", Character.valueOf('X'), GCItems.canvas, Character.valueOf('Y'), Items.field_151007_F});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, 1), new Object[]{"XYX", Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, 14), new Object[]{"XYX", Character.valueOf('Y'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, 15), new Object[]{"XYX", Character.valueOf('Y'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.oxygenGear), new Object[]{" Y ", "YXY", "Y Y", Character.valueOf('X'), GCItems.oxygenConcentrator, Character.valueOf('Y'), GCBlocks.oxygenPipe});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.basicBlock, 4, 3), new Object[]{"   ", " XY", "   ", Character.valueOf('X'), new ItemStack(Blocks.field_150348_b, 4, 0), Character.valueOf('Y'), "compressedTin"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.basicBlock, 4, 4), new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), new ItemStack(Blocks.field_150348_b, 4, 0), Character.valueOf('Y'), "compressedTin"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.flag), new Object[]{"XYY", "XYY", "X  ", Character.valueOf('X'), GCItems.flagPole, Character.valueOf('Y'), GCItems.canvas});
        boolean bl = false;
        while (var8_24 < 16) {
            CraftingManager.func_77594_a().func_77596_b(new ItemStack(GCItems.parachute, 1, ItemParaChute.getParachuteDamageValueFromDye((int)var8_24)), new Object[]{new ItemStack(Items.field_151100_aR, 1, (int)var8_24), new ItemStack(GCItems.parachute, 1, 0)});
            ++var8_24;
        }
        RecipeUtil.addRecipe(new ItemStack(GCItems.partFins, 1), new Object[]{" Y ", "XYX", "X X", Character.valueOf('X'), GCItems.heavyPlatingTier1, Character.valueOf('Y'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.landingPad, 9, 0), new Object[]{"YYY", "XXX", Character.valueOf('X'), Blocks.field_150339_S, Character.valueOf('Y'), "compressedIron"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.landingPad, 9, 1), new Object[]{"YYY", "XXX", Character.valueOf('X'), Blocks.field_150339_S, Character.valueOf('Y'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.partBuggy, 1, 0), new Object[]{" W ", "WXW", " W ", Character.valueOf('W'), Items.field_151116_aA, Character.valueOf('X'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.partBuggy, 1, 1), new Object[]{"  Y", " ZY", "XXX", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "compressedSteel", Character.valueOf('Z'), "compressedIron"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.partBuggy, 1, 2), new Object[]{"XXX", "YZY", "XXX", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "compressedIron", Character.valueOf('Z'), Blocks.field_150486_ae});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenDetector, 1), new Object[]{"WWW", "YVY", "ZUZ", Character.valueOf('U'), "compressedAluminum", Character.valueOf('V'), "waferBasic", Character.valueOf('W'), "compressedSteel", Character.valueOf('X'), GCItems.oxygenFan, Character.valueOf('Y'), GCItems.oxygenVent, Character.valueOf('Z'), Items.field_151137_ax});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenDistributor, 1), new Object[]{"WXW", "YZY", "WXW", Character.valueOf('W'), "compressedSteel", Character.valueOf('X'), GCItems.oxygenFan, Character.valueOf('Y'), GCItems.oxygenVent, Character.valueOf('Z'), "compressedAluminum"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenSealer, 1), new Object[]{"UZU", "YXY", "UZU", Character.valueOf('U'), "compressedAluminum", Character.valueOf('V'), GCBlocks.aluminumWire, Character.valueOf('W'), "compressedSteel", Character.valueOf('X'), GCItems.oxygenFan, Character.valueOf('Y'), GCItems.oxygenVent, Character.valueOf('Z'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenCollector, 1), new Object[]{"WWW", "YXZ", "UVU", Character.valueOf('U'), "compressedAluminum", Character.valueOf('V'), GCItems.oxygenConcentrator, Character.valueOf('W'), "compressedSteel", Character.valueOf('X'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('Y'), GCItems.oxygenFan, Character.valueOf('Z'), GCItems.oxygenVent});
        RecipeUtil.addRecipe(new ItemStack(GCItems.oxygenFan, 1), new Object[]{"Z Z", " Y ", "ZXZ", Character.valueOf('X'), Items.field_151137_ax, Character.valueOf('Y'), "waferBasic", Character.valueOf('Z'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.oxygenConcentrator, 1), new Object[]{"ZWZ", "WYW", "ZXZ", Character.valueOf('W'), "compressedTin", Character.valueOf('X'), GCItems.oxygenVent, Character.valueOf('Y'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('Z'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelPickaxe, 1), new Object[]{"YYY", " X ", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelAxe, 1), new Object[]{"YY ", "YX ", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelAxe, 1), new Object[]{" YY", " XY", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelHoe, 1), new Object[]{" YY", " X ", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelHoe, 1), new Object[]{"YY ", " X ", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelSpade, 1), new Object[]{" Y ", " X ", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelSword, 1), new Object[]{" Y ", " Y ", " X ", Character.valueOf('Y'), "compressedSteel", Character.valueOf('X'), Items.field_151055_y});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelBoots, 1), new Object[]{"X X", "X X", Character.valueOf('X'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelChestplate, 1), new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelLeggings, 1), new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.steelHelmet, 1), new Object[]{"XXX", "X X", Character.valueOf('X'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCItems.flagPole, 2, 0), new Object[]{"X", "X", "X", Character.valueOf('X'), "compressedSteel"});
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(GCItems.oxygenVent, 1), new Object[]{"compressedTin", "compressedTin", "compressedTin", "compressedSteel"}));
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.airLockFrame, 4, 0), new Object[]{"XXX", "YZY", "XXX", Character.valueOf('X'), "compressedAluminum", Character.valueOf('Y'), "compressedSteel", Character.valueOf('Z'), GCItems.oxygenConcentrator});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.airLockFrame, 1, 1), new Object[]{"YYY", "WZW", "YYY", Character.valueOf('W'), meteoricIronPlate, Character.valueOf('Y'), "compressedSteel", Character.valueOf('Z'), new ItemStack(GCItems.basicItem, 1, 13)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 1, 20), new Object[]{"WVW", "YXY", "YZY", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "compressedBronze", Character.valueOf('Z'), "waferBasic", Character.valueOf('W'), Items.field_151137_ax, Character.valueOf('V'), GCItems.oxygenVent});
        RecipeUtil.addRecipe(new ItemStack(GCItems.oilCanister, 1, GCItems.oilCanister.func_77612_l()), new Object[]{"WXW", "WYW", "WZW", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), Blocks.field_150359_w, Character.valueOf('Z'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('W'), "compressedTin"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.refinery), new Object[]{" Z ", "WZW", "XYX", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), Blocks.field_150460_al, Character.valueOf('Z'), new ItemStack(GCItems.canister, 1, 1), Character.valueOf('W'), Blocks.field_150348_b});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenCompressor, 1, 0), new Object[]{"XWX", "WZW", "XYX", Character.valueOf('W'), "compressedAluminum", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "compressedBronze", Character.valueOf('Z'), GCItems.oxygenConcentrator});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.oxygenCompressor, 1, 4), new Object[]{"XVX", "WZW", "XYX", Character.valueOf('V'), GCItems.oxygenFan, Character.valueOf('W'), "compressedAluminum", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), Blocks.field_150429_aA, Character.valueOf('Z'), GCItems.oxygenConcentrator});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.fuelLoader), new Object[]{"XXX", "XZX", "WYW", Character.valueOf('W'), "compressedAluminum", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "waferBasic", Character.valueOf('Z'), new ItemStack(GCItems.canister, 1, 0)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 2, 0), new Object[]{"XXX", "YYY", "ZZZ", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('Y'), "waferSolar", Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 0)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 1, 1), new Object[]{"XXX", "YYY", "XXX", Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 0), Character.valueOf('Y'), new ItemStack(GCBlocks.aluminumWire, 1, 0)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.solarPanel, 1, 0), new Object[]{"XYX", "XZX", "VWV", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('W'), "waferBasic", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 1), Character.valueOf('Z'), GCItems.flagPole});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.solarPanel, 1, 4), new Object[]{"XYX", "XZX", "VWV", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('W'), "waferAdvanced", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 1), Character.valueOf('Z'), GCItems.flagPole});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.cargoLoader, 1, 0), new Object[]{"XWX", "YZY", "XXX", Character.valueOf('W'), Blocks.field_150438_bZ, Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "compressedAluminum", Character.valueOf('Z'), Blocks.field_150486_ae});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.cargoLoader, 1, 4), new Object[]{"XXX", "YZY", "XWX", Character.valueOf('W'), Blocks.field_150438_bZ, Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "compressedAluminum", Character.valueOf('Z'), Blocks.field_150486_ae});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.glowstoneTorch, 4), new Object[]{"Y", "X", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151114_aO});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 1, 19), new Object[]{" X ", "YUY", "ZWZ", Character.valueOf('U'), Items.field_151107_aW, Character.valueOf('W'), "waferBasic", Character.valueOf('X'), "compressedAluminum", Character.valueOf('Y'), "compressedIron", Character.valueOf('Z'), Items.field_151137_ax});
        RecipeUtil.addRecipe(new ItemStack(GCItems.wrench), new Object[]{"  Y", " X ", "X  ", Character.valueOf('X'), "compressedBronze", Character.valueOf('Y'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(Blocks.field_150428_aP), new Object[]{"P  ", "T  ", "   ", Character.valueOf('P'), new ItemStack(Blocks.field_150423_aK), Character.valueOf('T'), new ItemStack(GCBlocks.unlitTorch)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.brightLamp), new Object[]{"XYX", "YZY", "XYX", Character.valueOf('X'), deshIngot, Character.valueOf('Y'), Items.field_151114_aO, Character.valueOf('Z'), new ItemStack(GCItems.battery, 1, 0)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.spinThruster), new Object[]{"   ", "YWZ", "PXP", Character.valueOf('W'), "waferAdvanced", Character.valueOf('X'), meteoricIronIngot, Character.valueOf('Y'), new ItemStack(GCItems.fuelCanister, 1, 1), Character.valueOf('Z'), new ItemStack(GCItems.rocketEngine, 1, 0), Character.valueOf('P'), "compressedSteel"});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.screen), new Object[]{"XYX", "YGY", "XYX", Character.valueOf('X'), "compressedSteel", Character.valueOf('Y'), "waferBasic", Character.valueOf('G'), Blocks.field_150359_w});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.telemetry), new Object[]{"XFX", "XWX", "YYY", Character.valueOf('W'), "waferBasic", Character.valueOf('X'), "compressedTin", Character.valueOf('Y'), "compressedCopper", Character.valueOf('F'), new ItemStack(GCItems.basicItem, 1, 19)});
        RecipeUtil.addBlockRecipe(new ItemStack(GCBlocks.basicBlock, 1, 9), "ingotCopper", new ItemStack(GCItems.basicItem, 1, 3));
        RecipeUtil.addBlockRecipe(new ItemStack(GCBlocks.basicBlock, 1, 10), "ingotTin", new ItemStack(GCItems.basicItem, 1, 4));
        RecipeUtil.addBlockRecipe(new ItemStack(GCBlocks.basicBlock, 1, 11), "ingotAluminum", new ItemStack(GCItems.basicItem, 1, 5));
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.basicBlock, 1, 12), new Object[]{"YYY", "YYY", "YYY", Character.valueOf('Y'), meteoricIronIngot});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 9, 3), new Object[]{"X", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 9)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 9, 4), new Object[]{"X", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 10)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.basicItem, 9, 5), new Object[]{"X", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 11)});
        RecipeUtil.addRecipe(new ItemStack(GCItems.meteoricIronIngot, 9, 0), new Object[]{"X", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 12)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.cheeseBlock, 1), new Object[]{"YYY", "YXY", "YYY", Character.valueOf('X'), Items.field_151117_aB, Character.valueOf('Y'), GCItems.cheeseCurd});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.tinStairs1, 4), new Object[]{"  X", " XX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.tinStairs1, 4), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.tinStairs2, 4), new Object[]{"  X", " XX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 3)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.tinStairs2, 4), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 3)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.moonStoneStairs, 4), new Object[]{"  X", " XX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.moonStoneStairs, 4), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.moonBricksStairs, 4), new Object[]{"  X", " XX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 14)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.moonBricksStairs, 4), new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 14)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.slabGCHalf, 6, 0), new Object[]{"XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.slabGCHalf, 6, 1), new Object[]{"XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 3)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.slabGCHalf, 6, 2), new Object[]{"XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.slabGCHalf, 6, 3), new Object[]{"XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 14)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.wallGC, 6, 0), new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.wallGC, 6, 1), new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 3)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.wallGC, 6, 2), new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.wallGC, 6, 3), new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(GCBlocks.blockMoon, 1, 14)});
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(GCItems.basicItem, 1, 15), new Object[]{new ItemStack(GCItems.canister, 1, 0), Items.field_151034_e, Items.field_151034_e}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(GCItems.basicItem, 1, 16), new Object[]{new ItemStack(GCItems.canister, 1, 0), Items.field_151172_bF, Items.field_151172_bF}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(GCItems.basicItem, 1, 17), new Object[]{new ItemStack(GCItems.canister, 1, 0), Items.field_151127_ba, Items.field_151127_ba}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(GCItems.basicItem, 1, 18), new Object[]{new ItemStack(GCItems.canister, 1, 0), Items.field_151174_bG, Items.field_151174_bG}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(new ItemStack(GCItems.meteorChunk, 3), new Object[]{GCItems.meteoricIronRaw}));
        int n = 3;
        while (var8_26 < 6) {
            if (ItemBasic.names[var8_26].contains("ingot")) {
                CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.basicItem, 1, (int)(var8_26 + 3)), ItemBasic.names[var8_26], ItemBasic.names[var8_26]);
            }
            ++var8_26;
        }
        if (OreDictionary.getOres((String)"ingotBronze").size() > 0) {
            CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.basicItem, 1, 10), "ingotBronze", "ingotBronze");
        }
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.basicItem, 1, 10), new ItemStack(GCItems.basicItem, 1, 6), new ItemStack(GCItems.basicItem, 1, 7));
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.basicItem, 1, 11), Items.field_151042_j, Items.field_151042_j);
        CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.meteoricIronIngot, 1, 1), meteoricIronIngot);
        CompressorRecipes.addRecipe(new ItemStack(GCItems.heavyPlatingTier1, 2, 0), "XYZ", "XYZ", Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 9), Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 8), Character.valueOf('Z'), new ItemStack(GCItems.basicItem, 1, 10));
    }

    public static void setConfigurableRecipes() {
        ItemStack solarPanels = new ItemStack(GCItems.basicItem, 9, 12);
        ItemStack basicWafers = new ItemStack(GCItems.basicItem, 3, 13);
        ItemStack advancedWafers = new ItemStack(GCItems.basicItem, 1, 14);
        CircuitFabricatorRecipes.removeRecipe(solarPanels);
        CircuitFabricatorRecipes.removeRecipe(basicWafers);
        CircuitFabricatorRecipes.removeRecipe(advancedWafers);
        ArrayList silicons = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon);
        int siliconCount = silicons.size();
        for (int j = 0; j <= siliconCount; ++j) {
            ItemStack silicon;
            if (j == 0) {
                silicon = new ItemStack(GCItems.basicItem, 1, 2);
            } else {
                silicon = (ItemStack)silicons.get(j - 1);
                if (silicon.func_77973_b() == GCItems.basicItem && silicon.func_77960_j() == 2) continue;
            }
            CircuitFabricatorRecipes.addRecipe(solarPanels, new ItemStack[]{new ItemStack(Items.field_151045_i), silicon, silicon, new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151100_aR, 1, 4)});
            CircuitFabricatorRecipes.addRecipe(basicWafers, new ItemStack[]{new ItemStack(Items.field_151045_i), silicon, silicon, new ItemStack(Items.field_151137_ax), new ItemStack(Blocks.field_150429_aA)});
            CircuitFabricatorRecipes.addRecipe(advancedWafers, new ItemStack[]{new ItemStack(Items.field_151045_i), silicon, silicon, new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151107_aW)});
        }
        CompressorRecipes.removeRecipe(new ItemStack(GCItems.basicItem, 1, 9));
        boolean steelDone = false;
        if (OreDictionary.getOres((String)"ingotSteel").size() > 0) {
            CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.basicItem, 1, 9), "ingotSteel", "ingotSteel");
            steelDone = true;
        }
        if (!ConfigManagerCore.hardMode || !steelDone) {
            CompressorRecipes.addShapelessRecipe(new ItemStack(GCItems.basicItem, 1, 9), Items.field_151044_h, new ItemStack(GCItems.basicItem, 1, 11), Items.field_151044_h);
        } else {
            CompressorRecipes.addShapelessAdventure(new ItemStack(GCItems.basicItem, 1, 9), Items.field_151044_h, new ItemStack(GCItems.basicItem, 1, 11), Items.field_151044_h);
        }
    }

    private static void addBuildCraftCraftingRecipes() {
        try {
            Class<?> clazz = Class.forName("buildcraft.BuildCraftTransport");
            Object pipeItemsStone = clazz.getField("pipeItemsStone").get(null);
            Object pipeItemsCobblestone = clazz.getField("pipeItemsCobblestone").get(null);
            Object pipeFluidsCobblestone = clazz.getField("pipeFluidsCobblestone").get(null);
            Object pipeFluidsStone = clazz.getField("pipeFluidsStone").get(null);
            Object pipePowerStone = clazz.getField("pipePowerStone").get(null);
            Object pipePowerGold = clazz.getField("pipePowerGold").get(null);
            RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.BC_ITEM_COBBLESTONEPIPE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), pipeItemsCobblestone, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
            RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.BC_ITEM_STONEPIPE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), pipeItemsStone, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
            RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.BC_FLUIDS_COBBLESTONEPIPE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), pipeFluidsCobblestone, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
            RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.BC_FLUIDS_STONEPIPE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), pipeFluidsStone, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
            RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.BC_POWER_STONEPIPE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), pipePowerStone, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
            RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), pipePowerGold, Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addIndustrialCraft2Recipes() {
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.IC2_COPPER_CABLE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), RecipeUtil.getIndustrialCraftItem("insulatedCopperCableItem"), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.IC2_GOLD_CABLE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), RecipeUtil.getIndustrialCraftItem("insulatedGoldCableItem"), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, 4), new Object[]{"XYX", Character.valueOf('Y'), RecipeUtil.getIndustrialCraftItem("insulatedIronCableItem"), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.IC2_GLASS_FIBRE_CABLE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), RecipeUtil.getIndustrialCraftItem("glassFiberCableItem"), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), RecipeUtil.getIndustrialCraftItem("insulatedTinCableItem"), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
    }

    private static void addAppEngRecipes() {
        RecipeUtil.addRecipe(new ItemStack(GCBlocks.sealableBlock, 1, BlockEnclosed.EnumEnclosedBlock.ME_CABLE.getMetadata()), new Object[]{"XYX", Character.valueOf('Y'), AEApi.instance().definitions().parts().cableGlass().stack(AEColor.Transparent, 1), Character.valueOf('X'), new ItemStack(GCBlocks.basicBlock, 1, 4)});
    }

    private static void addExNihiloRecipes() {
        try {
            Class<?> registry = Class.forName("exnihilo.registries.HeatRegistry");
            Method m = registry.getMethod("register", Block.class, Float.TYPE);
            m.invoke(null, GCBlocks.unlitTorchLit, Float.valueOf(0.1f));
            for (Block torch : GCBlocks.otherModTorchesLit) {
                m.invoke(null, torch, Float.valueOf(0.1f));
            }
            GCLog.info("Successfully added space torches as heat sources for Ex Nihilo crucibles etc");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

