/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import codechicken.nei.guihook.GuiContainerManager;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IDragAndDropHandler;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.IVanillaSlot;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.mixins.GuiContainerAccessor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class SlotWidget
extends Widget
implements IVanillaSlot,
Interactable,
ISyncedWidget,
IDragAndDropHandler {
    private boolean needsUpdate;
    public static final Size SIZE = new Size(18, 18);
    private final TextRenderer textRenderer = new TextRenderer();
    private final BaseSlot slot;
    private ItemStack lastStoredPhantomItem = null;
    protected boolean interactionDisabled = false;
    protected boolean handlePhantomActionClient = false;
    protected boolean controlsAmount = false;
    private Function<List<String>, List<String>> overwriteItemStackTooltip;
    protected Consumer<Widget> onDragAndDropComplete;
    private static final NumberFormatMUI numberFormat = new NumberFormatMUI();
    @Nullable
    private String sortAreaName = null;

    public SlotWidget(BaseSlot slot) {
        this.slot = slot;
        slot.setParentWidget(this);
    }

    public SlotWidget(IItemHandlerModifiable handler, int index) {
        this(new BaseSlot(handler, index, false));
    }

    public static SlotWidget phantom(IItemHandlerModifiable handler, int index) {
        return new SlotWidget(BaseSlot.phantom(handler, index));
    }

    public static SlotWidget empty() {
        return new SlotWidget(BaseSlot.empty());
    }

    @Override
    public void onInit() {
        this.getContext().getContainer().func_75146_a(this.slot);
        if (this.getBackground() == null) {
            this.setBackground(ModularUITextures.ITEM_SLOT);
        }
        if (!this.isClient() && this.slot.func_75211_c() != null) {
            this.lastStoredPhantomItem = this.slot.func_75211_c().func_77946_l();
        }
    }

    @Override
    public void onDestroy() {
        this.getContext().getContainer().removeSlot(this.slot);
    }

    @Override
    public BaseSlot getMcSlot() {
        return this.slot;
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return SIZE;
    }

    @Override
    @Nullable
    public String getBackgroundColorKey() {
        return "itemslot";
    }

    @Override
    public Function<List<String>, List<String>> getOverwriteItemStackTooltip() {
        return this.overwriteItemStackTooltip;
    }

    @Override
    public void draw(float partialTicks) {
        RenderHelper.func_74520_c();
        this.drawSlot(this.slot);
        RenderHelper.func_74519_b();
        GlStateManager.disableLighting();
        if (this.isHovering() && !this.getContext().getCursor().hasDraggable()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GlStateManager.colorMask(true, true, true, false);
            ModularGui.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, Theme.INSTANCE.getSlotHighlight());
            GlStateManager.colorMask(true, true, true, true);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public void onRebuild() {
        Pos2d pos = this.getAbsolutePos().subtract(this.getContext().getMainWindow().getPos()).add(1, 1);
        if (this.slot.field_75223_e != pos.x || this.slot.field_75221_f != pos.y) {
            this.slot.field_75223_e = pos.x;
            this.slot.field_75221_f = pos.y;
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (init || this.slot.isNeedsSyncing()) {
            this.getContext().syncSlotContent(this.slot);
            if (this.slot.isNeedsSyncing()) {
                this.markForUpdate();
            }
            this.slot.resetNeedsSyncing();
        }
    }

    @Override
    public void buildTooltip(List<Text> tooltip) {
        super.buildTooltip(tooltip);
        if (this.isPhantom() && this.canControlAmount()) {
            tooltip.add(Text.localised("modularui.item.phantom.control", new Object[0]));
        }
    }

    @Override
    public List<String> getExtraTooltip() {
        ArrayList extraLines = new ArrayList();
        if (this.slot.func_75211_c().field_77994_a >= 1000) {
            extraLines.add(I18n.func_135052_a((String)"modularui.amount", (Object[])new Object[]{this.slot.func_75211_c().field_77994_a}));
        }
        if (this.isPhantom()) {
            if (this.canControlAmount()) {
                String[] lines = I18n.func_135052_a((String)"modularui.item.phantom.control", (Object[])new Object[0]).split("\\\\n");
                extraLines.addAll(Arrays.asList(lines));
            } else if (!this.interactionDisabled) {
                extraLines.add(I18n.func_135052_a((String)"modularui.phantom.single.clear", (Object[])new Object[0]));
            }
        }
        return extraLines.isEmpty() ? Collections.emptyList() : extraLines;
    }

    public boolean isPhantom() {
        return this.slot.isPhantom();
    }

    @Override
    public SlotWidget setPos(Pos2d relativePos) {
        return (SlotWidget)super.setPos(relativePos);
    }

    @Override
    public SlotWidget setSize(Size size) {
        return (SlotWidget)super.setSize(size);
    }

    public SlotWidget applyForSlot(Consumer<BaseSlot> consumer) {
        consumer.accept(this.slot);
        return this;
    }

    public SlotWidget setShiftClickPriority(int priority) {
        this.slot.setShiftClickPriority(priority);
        return this;
    }

    public SlotWidget disableShiftInsert() {
        this.slot.disableShiftInsert();
        return this;
    }

    public SlotWidget disableInteraction() {
        this.interactionDisabled = true;
        this.disableShiftInsert();
        return this;
    }

    public SlotWidget setHandlePhantomActionClient(boolean handlePhantomActionClient) {
        this.handlePhantomActionClient = handlePhantomActionClient;
        return this;
    }

    public SlotWidget setChangeListener(Runnable runnable) {
        this.slot.setChangeListener(runnable);
        return this;
    }

    public SlotWidget setChangeListener(Consumer<SlotWidget> changeListener) {
        return this.setChangeListener(() -> changeListener.accept(this));
    }

    public SlotWidget setFilter(Predicate<ItemStack> filter) {
        this.slot.setFilter(filter);
        return this;
    }

    public SlotWidget setAccess(boolean canTake, boolean canInsert) {
        this.slot.setAccess(canTake, canInsert);
        return this;
    }

    public SlotWidget setIgnoreStackSizeLimit(boolean ignoreStackSizeLimit) {
        this.slot.setIgnoreStackSizeLimit(ignoreStackSizeLimit);
        return this;
    }

    public SlotWidget setSortable(String areaName) {
        if (this.sortAreaName == null ^ areaName == null) {
            this.sortAreaName = areaName;
        }
        return this;
    }

    @Override
    public SlotWidget setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.slot.setEnabled(enabled);
            if (this.isInitialised() && this.isClient()) {
                this.syncToServer(4, buffer -> buffer.writeBoolean(enabled));
            }
        }
        return this;
    }

    public SlotWidget setControlsAmount(boolean controlsAmount) {
        this.controlsAmount = controlsAmount;
        return this;
    }

    public SlotWidget setOverwriteItemStackTooltip(Function<List<String>, List<String>> overwriteItemStackTooltip) {
        this.overwriteItemStackTooltip = overwriteItemStackTooltip;
        return this;
    }

    public SlotWidget setOnDragAndDropComplete(Consumer<Widget> onDragAndDropComplete) {
        this.onDragAndDropComplete = onDragAndDropComplete;
        return this;
    }

    public boolean canControlAmount() {
        return this.controlsAmount && this.slot.func_75219_a() > 1;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.slot.field_75223_e = buf.func_150792_a();
            this.slot.field_75221_f = buf.func_150792_a();
        } else if (id == 2) {
            this.phantomClick(Widget.ClickData.readPacket(buf));
        } else if (id == 3) {
            this.phantomScroll(buf.func_150792_a());
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean());
        } else if (id == 5) {
            this.handleDragAndDropServer(Widget.ClickData.readPacket(buf), NetworkUtils.readItemStack(buf));
            if (this.onDragAndDropComplete != null) {
                this.onDragAndDropComplete.accept(this);
            }
        }
        this.markForUpdate();
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (this.interactionDisabled || !this.getMcSlot().isEnabled()) {
            return Interactable.ClickResult.ACCEPT;
        }
        if (this.isPhantom()) {
            Widget.ClickData clickData = Widget.ClickData.create(buttonId, doubleClick);
            this.syncToServer(2, clickData::writeToPacket);
            if (this.handlePhantomActionClient) {
                this.phantomClick(clickData);
            }
            return Interactable.ClickResult.SUCCESS;
        }
        return Interactable.ClickResult.DELEGATE;
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (this.interactionDisabled || !this.getMcSlot().isEnabled()) {
            return false;
        }
        if (this.isPhantom()) {
            if (Interactable.hasShiftDown()) {
                direction *= 8;
            }
            if (Interactable.hasControlDown()) {
                direction *= 64;
            }
            int finalDirection = direction;
            this.syncToServer(3, buffer -> buffer.func_150787_b(finalDirection));
            if (this.handlePhantomActionClient) {
                this.phantomScroll(finalDirection);
            }
            return true;
        }
        return false;
    }

    protected void phantomClick(Widget.ClickData clickData) {
        this.phantomClick(clickData, this.getContext().getCursor().getItemStack());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
        if (this.interactionDisabled || !this.getMcSlot().isEnabled()) {
            return;
        }
        ItemStack slotStack = this.getMcSlot().func_75211_c();
        if (slotStack == null) {
            ItemStack stackToPut;
            if (cursorStack == null) {
                if (clickData.mouseButton != 1 || this.lastStoredPhantomItem == null) return;
                stackToPut = this.lastStoredPhantomItem.func_77946_l();
            } else {
                stackToPut = cursorStack.func_77946_l();
            }
            this.putClickedStack(stackToPut, clickData.mouseButton);
            return;
        } else if (cursorStack == null) {
            if (clickData.mouseButton == 0) {
                if (clickData.shift) {
                    this.slot.func_75215_d(null);
                    return;
                } else {
                    this.slot.incrementStackCount(-1);
                }
                return;
            } else {
                if (clickData.mouseButton != 1) return;
                this.slot.incrementStackCount(1);
            }
            return;
        } else {
            this.putClickedStack(cursorStack.func_77946_l(), clickData.mouseButton);
        }
    }

    protected void putClickedStack(ItemStack stack, int mouseButton) {
        if (!this.slot.isItemValidPhantom(stack)) {
            return;
        }
        if (mouseButton == 1 || !this.canControlAmount()) {
            stack.field_77994_a = 1;
        }
        stack.field_77994_a = Math.min(stack.field_77994_a, this.slot.getItemStackLimit(stack));
        this.slot.func_75215_d(stack);
        this.lastStoredPhantomItem = stack.func_77946_l();
    }

    protected void phantomScroll(int direction) {
        if (this.interactionDisabled || !this.getMcSlot().isEnabled()) {
            return;
        }
        ItemStack currentItem = this.slot.func_75211_c();
        if (direction > 0 && currentItem == null && this.lastStoredPhantomItem != null) {
            ItemStack stackToPut = this.lastStoredPhantomItem.func_77946_l();
            stackToPut.field_77994_a = direction;
            this.slot.func_75215_d(stackToPut);
        } else {
            this.slot.incrementStackCount(direction);
        }
    }

    @Override
    public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
        if (this.interactionDisabled || !this.getMcSlot().isEnabled()) {
            return false;
        }
        if (!this.isPhantom()) {
            return false;
        }
        Widget.ClickData clickData = Widget.ClickData.create(button, false);
        this.syncToServer(5, buffer -> {
            clickData.writeToPacket((PacketBuffer)buffer);
            NetworkUtils.writeItemStack(buffer, draggedStack);
        });
        if (this.handlePhantomActionClient) {
            this.phantomClick(clickData, draggedStack);
        }
        draggedStack.field_77994_a = 0;
        return true;
    }

    protected void handleDragAndDropServer(Widget.ClickData clickData, ItemStack draggedStack) {
        this.phantomClick(clickData, draggedStack);
    }

    private GuiContainerAccessor getGuiAccessor() {
        return this.getContext().getScreen().getAccessor();
    }

    private ModularGui getScreen() {
        return this.getContext().getScreen();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawSlot(Slot slotIn) {
        this.drawSlot(slotIn, true);
    }

    @SideOnly(value=Side.CLIENT)
    protected ItemStack getItemStackForRendering(Slot slotIn) {
        return slotIn.func_75211_c();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawSlot(Slot slotIn, boolean drawStackSize) {
        ItemStack itemstack = this.getItemStackForRendering(slotIn);
        boolean flag = false;
        boolean flag1 = slotIn == this.getGuiAccessor().getClickedSlot() && this.getGuiAccessor().getDraggedStack() != null && !this.getGuiAccessor().getIsRightMouseClick();
        ItemStack itemstack1 = this.getContext().getPlayer().field_71071_by.func_70445_o();
        int amount = -1;
        String format = null;
        if (slotIn == this.getGuiAccessor().getClickedSlot() && this.getGuiAccessor().getDraggedStack() != null && this.getGuiAccessor().getIsRightMouseClick() && itemstack != null) {
            itemstack = itemstack.func_77946_l();
            itemstack.field_77994_a /= 2;
        } else if (this.getScreen().isDragSplitting() && this.getScreen().getDragSlots().contains(slotIn) && itemstack1 != null) {
            if (this.getScreen().getDragSlots().size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && this.getScreen().field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(this.getScreen().getDragSlots(), (int)this.getGuiAccessor().getDragSplittingLimit(), (ItemStack)itemstack, (int)(slotIn.func_75211_c() == null ? 0 : slotIn.func_75211_c().field_77994_a));
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_75219_a());
                if (itemstack.field_77994_a > k) {
                    amount = k;
                    format = EnumChatFormatting.YELLOW.toString();
                    itemstack.field_77994_a = k;
                }
            } else {
                this.getScreen().getDragSlots().remove(slotIn);
                this.getGuiAccessor().invokeUpdateDragSplitting();
            }
        }
        this.getScreen().setZ(100.0f);
        ModularGui.getItemRenderer().field_77023_b = 100.0f;
        if (!flag1) {
            if (flag) {
                ModularGui.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, -2130706433);
            }
            this.renderSlotUnderlayNEI(slotIn);
            if (itemstack != null) {
                GlStateManager.enableRescaleNormal();
                GlStateManager.enableLighting();
                RenderHelper.func_74520_c();
                GlStateManager.enableDepth();
                GL11.glEnable((int)32826);
                GlStateManager.pushMatrix();
                GlStateManager.translate(0.0f, 0.0f, 150 * this.getWindowLayer());
                ModularGui.getItemRenderer().func_82406_b(this.getScreen().getFontRenderer(), Minecraft.func_71410_x().func_110434_K(), itemstack, 1, 1);
                GuiHelper.afterRenderItemAndEffectIntoGUI(itemstack);
                GL11.glDisable((int)32826);
                GlStateManager.popMatrix();
                if (drawStackSize) {
                    if (amount < 0) {
                        amount = itemstack.field_77994_a;
                    }
                    if (amount > 1 || format != null) {
                        String amountText = numberFormat.formatWithSuffix(amount, new StringBuffer(format == null ? "" : format)).toString();
                        float scale = 1.0f;
                        if (amountText.length() == 3) {
                            scale = 0.8f;
                        } else if (amountText.length() == 4) {
                            scale = 0.6f;
                        } else if (amountText.length() > 4) {
                            scale = 0.5f;
                        }
                        this.textRenderer.setShadow(true);
                        this.textRenderer.setScale(scale);
                        this.textRenderer.setColor(Color.WHITE.normal);
                        this.textRenderer.setAlignment(Alignment.BottomRight, this.size.width - 1, this.size.height - 1);
                        this.textRenderer.setPos(1, 1);
                        GlStateManager.disableLighting();
                        GlStateManager.disableDepth();
                        GlStateManager.disableBlend();
                        this.textRenderer.draw(amountText);
                        GlStateManager.enableLighting();
                        GlStateManager.enableDepth();
                        GlStateManager.enableBlend();
                    }
                }
                int cachedCount = itemstack.field_77994_a;
                itemstack.field_77994_a = 1;
                ModularGui.getItemRenderer().func_94148_a(this.getScreen().getFontRenderer(), Minecraft.func_71410_x().func_110434_K(), itemstack, 1, 1, null);
                itemstack.field_77994_a = cachedCount;
                GlStateManager.disableDepth();
            }
            this.renderSlotOverlayNEI(slotIn);
        }
        GL11.glDisable((int)3042);
        ModularGui.getItemRenderer().field_77023_b = 0.0f;
        this.getScreen().setZ(0.0f);
    }

    protected void renderSlotUnderlayNEI(Slot slotIn) {
        GuiContainerManager manager = GuiContainerManager.getManager();
        ModularGui screen = this.getScreen();
        if (manager != null && manager.window == screen) {
            int xDisplayPosition = slotIn.field_75223_e;
            int yDisplayPosition = slotIn.field_75221_f;
            slotIn.field_75223_e = 1;
            slotIn.field_75221_f = 1;
            manager.renderSlotUnderlay(slotIn);
            slotIn.field_75223_e = xDisplayPosition;
            slotIn.field_75221_f = yDisplayPosition;
        }
    }

    protected void renderSlotOverlayNEI(Slot slotIn) {
        GuiContainerManager manager = GuiContainerManager.getManager();
        ModularGui screen = this.getScreen();
        if (manager != null && manager.window == screen) {
            int xDisplayPosition = slotIn.field_75223_e;
            int yDisplayPosition = slotIn.field_75221_f;
            slotIn.field_75223_e = 1;
            slotIn.field_75221_f = 1;
            manager.renderSlotOverlay(slotIn);
            slotIn.field_75223_e = xDisplayPosition;
            slotIn.field_75221_f = yDisplayPosition;
        }
    }
}

