/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.keridos.floodlights.client.gui.CreativeTabFloodlight;
import de.keridos.floodlights.reference.Textures;
import de.keridos.floodlights.tileentity.TileEntityFL;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFL
extends Block {
    protected String unlocName;
    public IIcon topIcon;
    public IIcon topOnIcon;
    public IIcon sideIcon;
    public IIcon botIcon;

    protected BlockFL(String unlocName, Material material, Block.SoundType type, float hardness) {
        super(material);
        this.func_149672_a(type);
        this.func_149711_c(hardness);
        this.func_149663_c(unlocName);
        this.unlocName = unlocName;
        if (!unlocName.equals("tilePhantomLight") && !unlocName.equals("tileUVLight")) {
            this.func_149647_a(CreativeTabFloodlight.FL_TAB);
        }
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_top")));
        this.topOnIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_top_on")));
        this.botIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_bot")));
        this.sideIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_side")));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == meta - 6) {
            return this.topOnIcon;
        }
        if (meta > 5) {
            meta -= 6;
        }
        if (side == meta) {
            return this.topIcon;
        }
        if (side == ForgeDirection.getOrientation((int)meta).getOpposite().ordinal()) {
            return this.botIcon;
        }
        return this.sideIcon;
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropInventory(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, 0);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityFL) {
            if (itemStack.func_82837_s()) {
                ((TileEntityFL)world.func_147438_o(x, y, z)).setCustomName(itemStack.func_82833_r());
            }
            ((TileEntityFL)world.func_147438_o(x, y, z)).setOrientation(ForgeDirection.getOrientation((int)this.getFacing(entityLiving)));
            world.func_72921_c(x, y, z, this.getFacing(entityLiving), 2);
        }
    }

    protected void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.func_77946_l());
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }

    public int getFacing(EntityLivingBase entityLiving) {
        float rotationYaw = MathHelper.func_76142_g((float)entityLiving.field_70177_z);
        float rotationPitch = entityLiving.field_70125_A;
        int result = rotationPitch < -45.0f ? 1 : (rotationPitch > 45.0f ? 0 : (MathHelper.func_76128_c((double)((double)(rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) + 2);
        ForgeDirection[] direction = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
        return direction[result].ordinal();
    }
}

