/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.events.EventKey;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IBorder;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.MinecraftTooltip;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlSlotBase;
import binnie.core.nei.NEIHook;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCraftGUI
extends GuiContainer {
    private Window window;
    private ItemStack draggedItem;

    public GuiCraftGUI(Window window) {
        super((Container)window.getContainer());
        this.window = window;
        this.resize(window.getSize());
    }

    public void func_73876_c() {
        this.window.updateClient();
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    protected void func_146976_a(float var1, int var2, int var3) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setSize(new IPoint(this.field_146999_f, this.field_147000_g));
        this.window.setPosition(new IPoint(this.field_147003_i, this.field_147009_r));
        this.window.initGui();
    }

    public ItemStack getDraggedItem() {
        return this.draggedItem;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        NEIHook.preDraw();
        this.window.setMousePosition(mouseX - (int)this.window.getPosition().x(), mouseY - (int)this.window.getPosition().y());
        this.func_146276_q_();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiScreen.field_146296_j.field_77023_b = this.field_73735_i = 10.0f;
        this.window.render();
        RenderHelper.func_74520_c();
        NEIHook.renderObjects(this.window, mouseX, mouseY);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        InventoryPlayer playerInventory = this.field_146297_k.field_71439_g.field_71071_by;
        this.draggedItem = playerInventory.func_70445_o();
        if (this.draggedItem != null) {
            this.renderItem(new IPoint(mouseX - 8, mouseY - 8), this.draggedItem, false);
            this.renderItem(new IPoint(mouseX - 8, mouseY - 8), this.draggedItem, false);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        MinecraftTooltip tooltip = new MinecraftTooltip();
        if (this.isHelpMode()) {
            tooltip.setType(Tooltip.Type.HELP);
            this.window.getHelpTooltip(tooltip);
        } else {
            tooltip.setType(Tooltip.Type.STANDARD);
            this.window.getTooltip(tooltip);
            NEIHook.renderToolTips(mouseX, mouseY);
        }
        if (tooltip.exists()) {
            this.renderTooltip(new IPoint(mouseX, mouseY), tooltip);
        } else {
            NEIHook.renderToolTips(mouseX, mouseY);
        }
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void renderTooltip(IPoint mousePosition, MinecraftTooltip tooltip) {
        int j2;
        int mouseX = (int)mousePosition.x();
        int mouseY = (int)mousePosition.y();
        FontRenderer font = this.getFontRenderer();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : tooltip.getList()) {
            if (string == null) continue;
            if (!string.contains("~~~")) {
                strings.addAll(font.func_78271_c(string, tooltip.maxWidth));
                continue;
            }
            strings.add(string);
        }
        for (String s : strings) {
            int l = font.func_78256_a(s);
            if (s.contains("~~~")) {
                l = 12 + font.func_78256_a(s.replaceAll("~~~(.*?)~~~", ""));
            }
            if (l <= k) continue;
            k = l;
        }
        int i1 = mouseX + 12;
        int j1 = mouseY - 12;
        int k2 = 8;
        if (strings.size() > 1) {
            k2 += 2 + (strings.size() - 1) * 10;
        }
        if (i1 + k > this.field_146294_l) {
            i1 -= 28 + k;
        }
        if (j1 + k2 + 6 > this.field_146295_m) {
            j1 = this.field_146295_m - k2 - 6;
        }
        this.field_73735_i = 300.0f;
        GuiScreen.field_146296_j.field_77023_b = 300.0f;
        int l2 = -267386864;
        int i2 = j2 = 0x50000000 + MinecraftTooltip.getOutline(tooltip.getType());
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l2, l2);
        this.func_73733_a(i1 - 3, j1 + k2 + 3, i1 + k + 3, j1 + k2 + 4, l2, l2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k2 + 3, l2, l2);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k2 + 3, l2, l2);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k2 + 3, l2, l2);
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k2 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k2 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k2 + 2, i1 + k + 3, j1 + k2 + 3, j2, j2);
        for (int k3 = 0; k3 < strings.size(); ++k3) {
            String s2 = (String)strings.get(k3);
            s2 = k3 == 0 ? MinecraftTooltip.getTitle(tooltip.getType()) + s2 : MinecraftTooltip.getBody(tooltip.getType()) + s2;
            if (s2.contains("~~~")) {
                String split = s2.split("~~~")[1];
                try {
                    NBTTagCompound nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)split);
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)i1, (float)((float)j1 - 1.5f), (float)0.0f);
                    GL11.glScalef((float)0.6f, (float)0.6f, (float)1.0f);
                    this.renderItem(new IPoint(0.0f, 0.0f), stack, false);
                    GL11.glPopMatrix();
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                s2 = "   " + s2.replaceAll("~~~(.*?)~~~", "");
            }
            font.func_78261_a(s2, i1, j1, -1);
            if (k3 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    protected void func_73864_a(int x, int y, int button) {
        NEIHook.mouseClicked(x, y, button);
        IWidget origin = this.window;
        if (this.window.getMousedOverWidget() != null) {
            origin = this.window.getMousedOverWidget();
        }
        this.window.callEvent(new EventMouse.Down(origin, x, y, button));
    }

    protected void func_73869_a(char c, int key) {
        NEIHook.lastKeyTyped(key, c);
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() && this.window.getFocusedWidget() == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        IWidget origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        this.window.callEvent(new EventKey.Down(origin, c, key));
    }

    protected void func_146286_b(int x, int y, int button) {
        IWidget origin;
        IWidget iWidget = origin = this.window.getMousedOverWidget() == null ? this.window : this.window.getMousedOverWidget();
        if (button != -1) {
            this.window.callEvent(new EventMouse.Up(origin, x, y, button));
        }
        NEIHook.mouseUp(x, y, button);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            this.window.callEvent(new EventMouse.Wheel(this.window, dWheel));
        }
        NEIHook.handleMouseWheel();
    }

    public void func_146281_b() {
        this.window.onClose();
    }

    public void renderTexture(IPoint position, IArea textureArea) {
        this.func_73729_b((int)position.x(), (int)position.y(), (int)textureArea.pos().x(), (int)textureArea.pos().y(), (int)textureArea.size().x(), (int)textureArea.size().y());
    }

    public void renderTexturePadded(IArea area, IArea texture, IBorder padding) {
        int texturingHeight2;
        int texturingWidth;
        int borderLeft = (int)padding.l();
        int borderRight = (int)padding.r();
        int borderTop = (int)padding.t();
        int borderBottom = (int)padding.b();
        int posX = (int)area.pos().x();
        int posY = (int)area.pos().y();
        int width = (int)area.size().x();
        int height = (int)area.size().y();
        int textWidth = (int)texture.w();
        int textHeight = (int)texture.h();
        int u = (int)texture.x();
        int v = (int)texture.y();
        if (borderTop + borderBottom > height) {
            borderTop = height / 2;
            borderBottom = height / 2;
        }
        if (borderLeft + borderRight > width) {
            borderLeft = width / 2;
            borderRight = width / 2;
        }
        this.func_73729_b(posX, posY, u, v, borderLeft, borderTop);
        this.func_73729_b(posX + width - borderRight, posY, u + textWidth - borderRight, v, borderRight, borderTop);
        this.func_73729_b(posX, posY + height - borderBottom, u, v + textHeight - borderBottom, borderLeft, borderBottom);
        this.func_73729_b(posX + width - borderRight, posY + height - borderBottom, u + textWidth - borderRight, v + textHeight - borderBottom, borderRight, borderBottom);
        block0: for (int currentXPos = borderLeft; currentXPos < width - borderRight; currentXPos += texturingWidth) {
            int texturingHeight;
            texturingWidth = textWidth - borderLeft - borderRight;
            int distanceXRemaining = width - borderRight - currentXPos;
            if (texturingWidth > distanceXRemaining) {
                texturingWidth = distanceXRemaining;
            }
            if (texturingWidth <= 0) break;
            this.func_73729_b(posX + currentXPos, posY, u + borderLeft, v, texturingWidth, borderTop);
            this.func_73729_b(posX + currentXPos, posY + height - borderBottom, u + borderLeft, v + textHeight - borderBottom, texturingWidth, borderBottom);
            for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight) {
                texturingHeight = textHeight - borderTop - borderBottom;
                int distanceYRemaining = height - borderBottom - currentYPos;
                if (texturingHeight > distanceYRemaining) {
                    texturingHeight = distanceYRemaining;
                }
                if (texturingHeight <= 0) continue block0;
                this.func_73729_b(posX + currentXPos, posY + currentYPos, u + borderLeft, v + borderTop, texturingWidth, texturingHeight);
            }
        }
        for (int currentYPos2 = borderTop; currentYPos2 < height - borderBottom; currentYPos2 += texturingHeight2) {
            texturingHeight2 = textHeight - borderTop - borderBottom;
            int distanceYRemaining2 = height - borderBottom - currentYPos2;
            if (texturingHeight2 > distanceYRemaining2) {
                texturingHeight2 = distanceYRemaining2;
            }
            if (texturingHeight2 <= 0) break;
            this.func_73729_b(posX, posY + currentYPos2, u, v + borderTop, borderLeft, texturingHeight2);
            this.func_73729_b(posX + width - borderRight, posY + currentYPos2, u + textWidth - borderRight, v + borderTop, borderRight, texturingHeight2);
        }
    }

    public void drawGradientArea(float x, float y, float width, float height, int color1, int color2) {
        float alpha1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float b1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float g1 = (float)(color1 & 0xFF) / 255.0f;
        float alpha2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r1, b1, g1, alpha1);
        tessellator.func_78377_a((double)width, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78369_a(r2, g2, b2, alpha2);
        tessellator.func_78377_a((double)x, (double)height, (double)this.field_73735_i);
        tessellator.func_78377_a((double)width, (double)height, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void renderItem(IPoint pos, ItemStack item, boolean rotating) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glPushAttrib((int)8256);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)2929);
        FontRenderer font = item.func_77973_b().getFontRenderer(item);
        if (font == null) {
            font = this.getFontRenderer();
        }
        BinnieCore.proxy.getMinecraftInstance();
        float phase = (float)Minecraft.func_71386_F() / 20.0f;
        if (rotating) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)8.0f, (float)8.0f, (float)0.0f);
            GL11.glRotatef((float)phase, (float)0.0f, (float)-0.866f, (float)0.5f);
            GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)-67.1f);
        }
        GuiScreen.field_146296_j.func_82406_b(font, this.field_146297_k.field_71446_o, item, (int)pos.x(), (int)pos.y());
        if (rotating) {
            GL11.glPopMatrix();
        }
        GuiScreen.field_146296_j.func_94148_a(font, this.field_146297_k.field_71446_o, item, (int)pos.x(), (int)pos.y(), null);
        GL11.glClear((int)256);
        RenderHelper.func_74518_a();
        GL11.glPopAttrib();
    }

    public void renderIcon(IPoint pos, IIcon icon, ResourceLocation map) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        BinnieCore.proxy.bindTexture(map);
        GuiScreen.field_146296_j.field_77023_b = this.field_73735_i;
        GuiScreen.field_146296_j.func_94149_a((int)pos.x(), (int)pos.y(), icon, 16, 16);
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    public boolean isHelpMode() {
        return Keyboard.isKeyDown((int)15);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void resize(IPoint size) {
        this.field_146999_f = (int)size.x();
        this.field_147000_g = (int)size.y();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.window.setPosition(new IPoint(this.field_147003_i, this.field_147009_r));
    }

    public void limitArea(IArea area) {
        float x = area.pos().x();
        float y = area.pos().y();
        float w = area.size().x();
        float h = area.size().y();
        y = (float)this.field_146295_m - (y + h);
        float scaleX = (float)this.field_146294_l / (float)this.field_146297_k.field_71443_c;
        float scaleY = (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d;
        GL11.glScissor((int)((int)(x / scaleX)), (int)((int)(y / scaleY)), (int)((int)(w / scaleX)), (int)((int)(h / scaleY)));
    }

    public void drawRect(float x, float y, float width, float height, int color) {
        float temp;
        if (x < width) {
            temp = x;
            x = width;
            width = temp;
        }
        if (y < height) {
            temp = y;
            y = height;
            height = temp;
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x, (double)height, 0.0);
        tessellator.func_78377_a((double)width, (double)height, 0.0);
        tessellator.func_78377_a((double)width, (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }

    public ItemStack getStackUnderMouse(int x, int y) {
        for (IWidget widget : this.window.calculateMousedOverWidgets()) {
            if (!(widget instanceof ControlSlotBase) || !widget.isVisible()) continue;
            return ((ControlSlotBase)widget).getItemStack();
        }
        return null;
    }
}

