/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.craftgui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.TopLevelWidget;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.scroll.IControlScrollable;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.TileEntityMachine;
import binnie.core.util.I18N;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignCategory;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.craftgui.WindowWoodworker;
import binnie.extratrees.machines.designer.WoodworkerRecipeComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ControlTileSelect
extends Control
implements IControlValue<IDesign>,
IControlScrollable {
    protected IDesign value = EnumDesign.Blank;
    protected float shownHeight = 92.0f;

    protected ControlTileSelect(IWidget parent, float x, float y) {
        super(parent, x, y, 102.0f, 20 * (CarpentryManager.carpentryInterface.getSortedDesigns().size() / 4) + 22);
        this.refresh("");
    }

    @Override
    public float getPercentageIndex() {
        return 0.0f;
    }

    @Override
    public void setPercentageIndex(float index) {
    }

    @Override
    public float getPercentageShown() {
        return 0.0f;
    }

    @Override
    public IDesign getValue() {
        return this.value;
    }

    @Override
    public void setValue(IDesign value) {
        this.value = value;
    }

    @Override
    public void movePercentage(float percentage) {
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        TileEntityMachine tile = (TileEntityMachine)((Window)Window.get(this)).getInventory();
        if (tile == null) {
            return;
        }
        WoodworkerRecipeComponent recipe = tile.getMachine().getComponent(WoodworkerRecipeComponent.class);
        this.setValue(recipe.getDesign());
    }

    public void refresh(String filterText) {
        this.deleteAllChildren();
        int cy = 2;
        HashMap designs = new HashMap();
        for (IDesignCategory category : CarpentryManager.carpentryInterface.getAllDesignCategories()) {
            designs.put(category, new ArrayList());
            for (IDesign tile : category.getDesigns()) {
                if (!filterText.isEmpty() && !tile.getName().toLowerCase().contains(filterText)) continue;
                ((List)designs.get(category)).add(tile);
            }
            if (!((List)designs.get(category)).isEmpty()) continue;
            designs.remove(category);
        }
        for (IDesignCategory category : designs.keySet()) {
            int cx = 2;
            new ControlText((IWidget)this, new IPoint(cx, cy + 3), category.getName());
            cy += 16;
            for (IDesign tile : (List)designs.get(category)) {
                if (cx > 90) {
                    cx = 2;
                    cy += 20;
                }
                new ControlTile(this, cx, cy, tile);
                cx += 20;
            }
            cy += 20;
        }
        int height = cy;
        this.setSize(new IPoint(this.getSize().x(), height));
    }

    @Override
    public float getMovementRange() {
        return 0.0f;
    }

    public static class ControlTile
    extends Control
    implements IControlValue<IDesign>,
    ITooltip {
        IDesign value;

        protected ControlTile(IWidget parent, float x, float y, IDesign value) {
            super(parent, x, y, 18.0f, 18.0f);
            this.setValue(value);
            this.addAttribute(WidgetAttribute.MOUSE_OVER);
            this.addSelfEventHandler((EventHandler)new MouseDownHandler());
        }

        @Override
        public void getTooltip(Tooltip tooltip) {
            tooltip.add(I18N.localise("binniecore.gui.designer.pattern", this.getValue().getName()));
        }

        @Override
        public IDesign getValue() {
            return this.value;
        }

        @Override
        public void setValue(IDesign value) {
            this.value = value;
        }

        @Override
        public void onRenderBackground() {
            CraftGUI.render.texture((Object)CraftGUITexture.Slot, IPoint.ZERO);
        }

        @Override
        public void onRenderForeground() {
            ItemStack image = ((WindowWoodworker)this.getSuperParent()).getDesignerType().getDisplayStack(this.getValue());
            CraftGUI.render.item(new IPoint(1.0f, 1.0f), image);
            if (((IControlValue)this.getParent()).getValue() == this.getValue()) {
                return;
            }
            if (((TopLevelWidget)Window.get(this)).getMousedOverWidget() == this) {
                CraftGUI.render.gradientRect(this.getArea().inset(1), 0x44FFFFFF, 0x44FFFFFF);
            } else {
                CraftGUI.render.gradientRect(this.getArea().inset(1), -1433892728, -1433892728);
            }
        }

        private class MouseDownHandler
        extends EventMouse.Down.Handler {
            private MouseDownHandler() {
            }

            @Override
            public void onEvent(EventMouse.Down event) {
                TileEntityMachine tile = (TileEntityMachine)((Window)Window.get(ControlTile.this.getWidget())).getInventory();
                if (tile == null) {
                    return;
                }
                tile.getMachine().getComponent(WoodworkerRecipeComponent.class);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74777_a("d", (short)CarpentryManager.carpentryInterface.getDesignIndex(ControlTile.this.getValue()));
                ((Window)Window.get(ControlTile.this.getWidget())).sendClientAction("design", nbt);
            }
        }
    }
}

