/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.tcnodetracker.integration.navigator.journeymap;

import com.dyonovan.tcnodetracker.integration.navigator.ThaumcraftNodeLayerManager;
import com.dyonovan.tcnodetracker.integration.navigator.ThaumcraftNodeLocation;
import com.dyonovan.tcnodetracker.lib.Utils;
import com.gtnewhorizons.navigator.api.journeymap.drawsteps.JMInteractableStep;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import java.awt.geom.Point2D;
import java.util.List;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;

public class ThaumcraftNodeDrawStep
implements JMInteractableStep {
    private static final ResourceLocation markedTextureLocation = new ResourceLocation("tcnodetracker", "textures/gui/node_marked.png");
    private static final ResourceLocation unmarkedTextureLocation = new ResourceLocation("tcnodetracker", "textures/gui/node_unmarked.png");
    private final ThaumcraftNodeLocation thaumcraftNodeLocation;
    private double centerPixelX = 0.0;
    private double centerPixelY = 0.0;
    private double clickableRadiusPixelSquared = 0.0;

    public ThaumcraftNodeDrawStep(ThaumcraftNodeLocation thaumcraftNodeLocation) {
        this.thaumcraftNodeLocation = thaumcraftNodeLocation;
    }

    public void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        double borderSize = 44.0f * drawScale;
        double borderSizeHalf = borderSize / 2.0;
        Point2D.Double blockAsPixel = gridRenderer.getBlockPixelInGrid(this.thaumcraftNodeLocation.getBlockX(), this.thaumcraftNodeLocation.getBlockZ());
        Point2D.Double pixel = new Point2D.Double(blockAsPixel.getX() + draggedPixelX, blockAsPixel.getY() + draggedPixelY);
        this.centerPixelX = pixel.getX();
        this.centerPixelY = pixel.getY();
        this.clickableRadiusPixelSquared = borderSizeHalf * borderSizeHalf;
        int alpha = 204;
        DrawUtils.drawQuad((ResourceLocation)(this.thaumcraftNodeLocation.isActiveAsWaypoint() ? markedTextureLocation : unmarkedTextureLocation), (double)(pixel.getX() - borderSizeHalf), (double)(pixel.getY() - borderSizeHalf), (double)borderSize, (double)borderSize, (int)0xFFFFFF, (float)204.0f);
        int aspectPixelDiameter = 32;
        Utils.drawAspect(pixel.getX(), pixel.getY(), 32.0, this.thaumcraftNodeLocation.getStrongestAspect(), 0);
    }

    public void getTooltip(List<String> tooltip) {
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        double deltaX = (double)mouseX - this.centerPixelX;
        double deltaY = (double)mouseY - this.centerPixelY;
        return deltaX * deltaX + deltaY * deltaY <= this.clickableRadiusPixelSquared;
    }

    public void onActionKeyPressed() {
        ThaumcraftNodeLayerManager.instance.deleteNode(this.thaumcraftNodeLocation);
    }

    public IWaypointAndLocationProvider getLocationProvider() {
        return this.thaumcraftNodeLocation;
    }

    public void drawCustomTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
        boolean isWaypoint = this.thaumcraftNodeLocation.isActiveAsWaypoint();
        String activeWaypointHint = this.thaumcraftNodeLocation.getActiveWaypointHint();
        String title = this.thaumcraftNodeLocation.getTitle();
        String nodeDescription = this.thaumcraftNodeLocation.getDescription();
        String deleteHint = this.thaumcraftNodeLocation.getDeleteHint();
        int maxTextWidth = Math.max(Math.max(fontRenderer.func_78256_a(title), fontRenderer.func_78256_a(nodeDescription)), fontRenderer.func_78256_a(deleteHint));
        if (isWaypoint) {
            maxTextWidth = Math.max(maxTextWidth, fontRenderer.func_78256_a(activeWaypointHint));
        }
        if (fontRenderer.func_78260_a()) {
            maxTextWidth = (int)Math.ceil((float)maxTextWidth * 1.25f);
        }
        int aspectRows = (this.thaumcraftNodeLocation.getAspects().size() + 4) / 5;
        int aspectColumns = Math.min(this.thaumcraftNodeLocation.getAspects().size(), 5);
        int pixelX = mouseX + 12;
        int pixelY = mouseY - 12;
        int tooltipHeight = (isWaypoint ? 44 : 32) + aspectRows * 16;
        int tooltipWidth = Math.max(aspectColumns * 16, maxTextWidth);
        if (pixelX + tooltipWidth > displayWidth) {
            pixelX -= 28 + tooltipWidth;
        }
        if (pixelY + tooltipHeight + 6 > displayHeight) {
            pixelY = displayHeight - tooltipHeight - 6;
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int backgroundColor = -267386864;
        DrawUtils.drawGradientRect((double)(pixelX - 3), (double)(pixelY - 4), (double)(pixelX + tooltipWidth + 3), (double)(pixelY - 3), (int)-267386864, (int)-267386864);
        DrawUtils.drawGradientRect((double)(pixelX - 3), (double)(pixelY + tooltipHeight + 3), (double)(pixelX + tooltipWidth + 3), (double)(pixelY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
        DrawUtils.drawGradientRect((double)(pixelX - 3), (double)(pixelY - 3), (double)(pixelX + tooltipWidth + 3), (double)(pixelY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
        DrawUtils.drawGradientRect((double)(pixelX - 4), (double)(pixelY - 3), (double)(pixelX - 3), (double)(pixelY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
        DrawUtils.drawGradientRect((double)(pixelX + tooltipWidth + 3), (double)(pixelY - 3), (double)(pixelX + tooltipWidth + 4), (double)(pixelY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
        int verdunGreen = 0x505000FF;
        int borderColor = 1344798847;
        DrawUtils.drawGradientRect((double)(pixelX - 3), (double)(pixelY - 3 + 1), (double)(pixelX - 3 + 1), (double)(pixelY + tooltipHeight + 3 - 1), (int)verdunGreen, (int)borderColor);
        DrawUtils.drawGradientRect((double)(pixelX + tooltipWidth + 2), (double)(pixelY - 3 + 1), (double)(pixelX + tooltipWidth + 3), (double)(pixelY + tooltipHeight + 3 - 1), (int)verdunGreen, (int)borderColor);
        DrawUtils.drawGradientRect((double)(pixelX - 3), (double)(pixelY - 3), (double)(pixelX + tooltipWidth + 3), (double)(pixelY - 3 + 1), (int)verdunGreen, (int)verdunGreen);
        DrawUtils.drawGradientRect((double)(pixelX - 3), (double)(pixelY + tooltipHeight + 2), (double)(pixelX + tooltipWidth + 3), (double)(pixelY + tooltipHeight + 3), (int)borderColor, (int)borderColor);
        int offset = 0;
        if (fontRenderer.func_78260_a()) {
            if (isWaypoint) {
                int asWaypointWidth = (int)Math.ceil((float)fontRenderer.func_78256_a(activeWaypointHint) * 1.1f);
                fontRenderer.func_78276_b(title, pixelX + tooltipWidth - asWaypointWidth, pixelY, -1);
                offset += 12;
            }
            int titleWidth = (int)Math.ceil((float)fontRenderer.func_78256_a(title) * 1.1f);
            fontRenderer.func_78276_b(title, pixelX + tooltipWidth - titleWidth, pixelY + offset, -1);
            int nodeDescriptonWidth = (int)Math.ceil((float)fontRenderer.func_78256_a(nodeDescription) * 1.1f);
            fontRenderer.func_78276_b(nodeDescription, pixelX + nodeDescriptonWidth - titleWidth, pixelY + (offset += 12), -1);
            int deleteHintWidth = (int)Math.ceil((float)fontRenderer.func_78256_a(deleteHint) * 1.1f);
            fontRenderer.func_78276_b(deleteHint, pixelX + tooltipWidth - deleteHintWidth, pixelY + aspectRows * 16 + offset + 12, -1);
        } else {
            if (isWaypoint) {
                fontRenderer.func_78276_b(activeWaypointHint, pixelX, pixelY, -1);
                offset += 12;
            }
            fontRenderer.func_78276_b(title, pixelX, pixelY + offset, -1);
            fontRenderer.func_78276_b(nodeDescription, pixelX, pixelY + (offset += 12), -1);
            fontRenderer.func_78276_b(deleteHint, pixelX, pixelY + aspectRows * 16 + offset + 12, -1);
        }
        int aspectX = 0;
        int aspectY = 0;
        for (Aspect aspect : this.thaumcraftNodeLocation.getAspects().getAspectsSortedAmount()) {
            GL11.glPushMatrix();
            UtilsFX.drawTag((int)(pixelX + aspectX * 16), (int)(pixelY + aspectY * 16 + offset + 10), (Aspect)aspect, (float)this.thaumcraftNodeLocation.getAspects().getAmount(aspect), (int)0, (double)0.01, (int)1, (float)1.0f, (boolean)false);
            GL11.glPopMatrix();
            if (++aspectX < 5) continue;
            aspectX = 0;
            ++aspectY;
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }
}

