/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Phase.class})
public class ExtendedScreen
extends GuiScreen {
    private static final int DEFAULT_ELEMENT_PADDING = 5;
    private static final int DEFAULT_ELEMENT_HEIGHT = 20;
    private static int lastIndex = 0;
    private final GuiScreen currentScreen;
    private final List<Gui> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<GuiSlot> extendedLists = StringUtils.newArrayList();
    private String title;
    private String subTitle;
    private GuiScreen parentScreen;
    private Phase currentPhase = Phase.PREINIT;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private float lastPartialTicks = 0.0f;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;
    private boolean canModifyControls;
    private boolean focused;

    public ExtendedScreen(GuiScreen parentScreen, String title, String subTitle) {
        this.setGameInstance(ModUtils.getMinecraft());
        this.setParent(parentScreen);
        this.currentScreen = this;
        this.setScreenTitle(title);
        this.setScreenSubTitle(subTitle);
        this.setCanClose(true);
        this.setCanModifyControls(true);
        this.setContentHeight(0);
        this.setScreenSettings();
    }

    public ExtendedScreen(GuiScreen parentScreen, String title) {
        this(parentScreen, title, null);
    }

    public ExtendedScreen(GuiScreen parentScreen) {
        this(parentScreen, null);
    }

    public ExtendedScreen(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public ExtendedScreen(String title) {
        this(title, null);
    }

    public ExtendedScreen() {
        this((GuiScreen)null);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(String input) {
        ExtendedScreen.func_146275_d((String)StringUtils.normalize(input));
    }

    public static int getProtocol() {
        return ModUtils.MCProtocolID;
    }

    public static int getKeyByVersion(int lwjgl2Key, int lwjgl3Key) {
        return ExtendedScreen.getProtocol() > 340 ? lwjgl3Key : lwjgl2Key;
    }

    public static boolean isEscapeKey(int keyCode) {
        return keyCode == ExtendedScreen.getKeyByVersion(1, 256);
    }

    public static void enableRepeatEvents(boolean enable) {
        Keyboard.enableRepeatEvents((boolean)enable);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.clearData();
        ExtendedScreen.enableRepeatEvents(true);
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (this.currentPhase != Phase.PREINIT) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.field_146292_n.clear();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.currentPhase == Phase.PREINIT) {
            this.func_73866_w_();
            return;
        }
        if (this.currentPhase == Phase.INIT) {
            this.resetMouseScroll();
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.initializeUi();
            }
            this.refreshContentHeight();
        }
    }

    public void reloadUi() {
        this.func_146280_a(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void func_146280_a(@Nonnull Minecraft mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_146280_a(mcIn, w, h);
            }
        }
        super.func_146280_a(mcIn, w, h);
    }

    @Nonnull
    public <T extends Gui> T addControl(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (buttonIn instanceof DynamicWidget) {
            DynamicWidget widget = (DynamicWidget)buttonIn;
            if (!this.extendedWidgets.contains(buttonIn)) {
                this.addWidget(widget);
            }
        }
        if (buttonIn instanceof GuiButton) {
            GuiButton button = (GuiButton)buttonIn;
            if (!this.field_146292_n.contains(buttonIn)) {
                this.field_146292_n.add(button);
            }
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends GuiSlot> T addList(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, double u, double v, ScreenConstants.ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.startColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.endColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.texLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, 300.0, startColor, endColor);
        } else {
            Tuple<Boolean, String, ResourceLocation> textureData = RenderUtils.getTextureData(this.getGameInstance(), data.texLocation());
            boolean usingExternalTexture = textureData.getFirst();
            ResourceLocation texLocation = textureData.getThird();
            this.drawTexture(left, right, top, bottom, usingExternalTexture, offset, u, v, startColor, endColor, texLocation);
        }
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, ScreenConstants.ColorData data) {
        this.drawBackground(left, right, top, bottom, offset, tintFactor, left, top, data);
    }

    public void drawTexture(double left, double right, double top, double bottom, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(this.getGameInstance(), left, right, top, bottom, 0.0, usingExternalTexture, right - left, bottom - top, u, v + offset, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public boolean hasWorld() {
        return WorldUtils.getWorld(this.getGameInstance()) != null;
    }

    public String getScreenTitle() {
        return this.title;
    }

    public void setScreenTitle(String title) {
        this.title = title;
    }

    public String getScreenSubTitle() {
        return this.subTitle;
    }

    public void setScreenSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ScreenConstants.ColorData getScreenBackground() {
        return this.hasWorld() ? ScreenConstants.DEFAULT_ALT_SCREEN_BACKGROUND : ScreenConstants.DEFAULT_SCREEN_BACKGROUND;
    }

    public ScreenConstants.TooltipData getTooltipData(boolean isTooltip) {
        return isTooltip ? ScreenConstants.getDefaultTooltip() : ScreenConstants.getEmptyTooltip();
    }

    public ScreenConstants.TooltipData getTooltipData() {
        return this.getTooltipData(true);
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        this.renderStringData();
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void renderStringData() {
        this.renderTitles(this.getScreenTitle(), this.getScreenSubTitle());
    }

    public void renderTitles(String title, String subTitle) {
        boolean hasSubTitle;
        boolean hasMainTitle = !StringUtils.isNullOrEmpty(title);
        boolean bl = hasSubTitle = !StringUtils.isNullOrEmpty(subTitle);
        if (hasMainTitle) {
            if (hasSubTitle) {
                this.renderScrollingString(title, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
                this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
            } else {
                this.renderScrollingString(title, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
            }
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void func_146270_b(int tint) {
        this.renderCriticalData();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.isLoaded()) {
            this.preRender();
            RenderUtils.enableScissor(this.getGameInstance(), this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            this.func_146276_q_();
            for (GuiSlot listControl : this.getLists()) {
                if (!listControl.func_148125_i()) continue;
                listControl.func_148128_a(mouseX, mouseY, partialTicks);
            }
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastPartialTicks = partialTicks;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146194_f();
            }
            this.renderExtra();
            RenderUtils.disableScissor(this.getGameInstance());
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_73863_a(mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public void func_146274_d() {
        if (this.isLoaded()) {
            this.setMouseScroll(Mouse.getEventDWheel());
            int dw = this.getMouseScroll();
            if (dw != 0) {
                this.mouseScrolled(this.getMouseX(), this.getMouseY(), (int)((double)dw / 60.0));
            }
            super.func_146274_d();
        }
    }

    public void mouseScrolled(int mouseX, int mouseY, int wheelY) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.mouseScrolled(mouseX, mouseY, wheelY);
            }
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) {
        if (this.isOverScreen()) {
            if (button instanceof ExtendedButtonControl) {
                ExtendedButtonControl extendedButton = (ExtendedButtonControl)button;
                extendedButton.onClick();
            }
            super.func_146284_a(button);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.isLoaded()) {
            if (this.isCurrentScreen() && ExtendedScreen.isEscapeKey(keyCode) && this.canClose()) {
                this.openScreen(this.getParent());
                return;
            }
            for (Gui extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.func_146201_a(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_73869_a(typedChar, keyCode);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.func_146192_a(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_73864_a(mouseX, mouseY, mouseButton);
            }
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
            }
            super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_146286_b(mouseX, mouseY, state);
            }
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    public void func_73876_c() {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.func_146178_a();
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_73876_c();
            }
            super.func_73876_c();
        }
    }

    public void func_146281_b() {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.func_146281_b();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
            ExtendedScreen.enableRepeatEvents(false);
        }
    }

    public Minecraft getGameInstance() {
        return this.field_146297_k;
    }

    public void setGameInstance(Minecraft instance) {
        this.field_146297_k = instance;
    }

    public void openScreen(GuiScreen targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public void openScreen(ExtendedScreen targetScreen, GuiScreen parentScreen, boolean setParent) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen, setParent);
    }

    public void openScreen(ExtendedScreen targetScreen, GuiScreen parentScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen);
    }

    public void openScreen(ExtendedScreen targetScreen) {
        this.openScreen(targetScreen, this.getInstance());
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        int topPosition = this.getTop();
        GuiScreen guiScreen = this.getInstance();
        if (guiScreen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)guiScreen;
            topPosition += pane.getPadding();
        }
        return topPosition + 5 * (order + 1) + 20 * order;
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, this.getFontRenderer(), isCentered, isTooltip, colorInfo);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, isCentered, isTooltip, this.getTooltipData(isTooltip));
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, false, true);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        this.drawMultiLineString(textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth());
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderScrollingString(String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, float minX, float minY, float maxX, float maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int minX, int minY, int maxX, int maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderCenteredString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderCenteredString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, float yPos, int color) {
        this.renderCenteredString(text, (float)this.getScreenWidth() / 2.0f, yPos, color);
    }

    public void renderCenteredString(String text, int yPos, int color) {
        this.renderCenteredString(text, this.getScreenWidth() / 2, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.renderString(text, Math.round(xPos), Math.round(yPos), color);
    }

    public void renderString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public int getStringWidth(String string) {
        return RenderUtils.getStringWidth(this.getFontRenderer(), string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public float getPartialTicks() {
        return this.lastPartialTicks;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public boolean isCurrentScreen() {
        return GameUtils.getCurrentScreen(this.getGameInstance()) == this;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public void setScreenSettings() {
    }

    public int getScreenWidth() {
        return this.field_146294_l;
    }

    public void setScreenWidth(int screenWidth) {
        this.field_146294_l = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
    }

    public int getScreenHeight() {
        return this.field_146295_m;
    }

    public void setScreenHeight(int screenHeight) {
        this.field_146295_m = screenHeight;
    }

    public FontRenderer getFontRenderer() {
        return StringUtils.getOrDefault(this.getGameInstance().field_71466_p, RenderUtils.getDefaultFontRenderer());
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public GuiScreen getInstance() {
        return this.currentScreen;
    }

    public GuiScreen getParent() {
        return this.parentScreen;
    }

    public void setParent(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    public boolean canClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public boolean canModifyControls() {
        return this.canModifyControls;
    }

    public void setCanModifyControls(boolean canModifyControls) {
        this.canModifyControls = canModifyControls;
    }

    public void setFocused(boolean hasFocusedControlIn) {
        this.focused = hasFocusedControlIn;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public List<Gui> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<GuiSlot> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    @NestHost(value=ExtendedScreen.class)
    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

