/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public final class GLUtil {
    private GLUtil() {
    }

    public static List<int[]> makeGLState() {
        return new ArrayList<int[]>(8);
    }

    public static List<int[]> makeGLState(int[] saveList) {
        ArrayList<int[]> state = new ArrayList<int[]>(saveList.length);
        int n = saveList.length;
        for (int i = 0; i < n; ++i) {
            state.add(new int[]{0, 0});
        }
        return state;
    }

    public static List<int[]> saveGLState(int[] saveList) {
        List<int[]> state = GLUtil.makeGLState(saveList);
        GLUtil.saveGLStateCore(state, saveList);
        return state;
    }

    public static void saveGLState(List<int[]> state, int[] saveList) {
        int i;
        if (state == null || saveList == null) {
            return;
        }
        int n = saveList.length;
        for (i = state.size(); i < n; ++i) {
            state.add(new int[2]);
        }
        n = state.size();
        for (i = 0; i < n; ++i) {
            state.get((int)i)[0] = 0;
        }
        GLUtil.saveGLStateCore(state, saveList);
    }

    private static void saveGLStateCore(List<int[]> state, int[] saveList) {
        int n = saveList.length;
        for (int i = 0; i < n; ++i) {
            int[] entry = state.get(i);
            entry[0] = saveList[i];
            entry[1] = GL11.glIsEnabled((int)entry[0]) ? 1 : 0;
        }
    }

    public static void restoreGLState(List<int[]> state) {
        int[] entry;
        if (state == null) {
            return;
        }
        int n = state.size();
        for (int i = 0; i < n && (entry = state.get(i))[0] != 0; ++i) {
            if (entry[1] == 0) {
                GL11.glDisable((int)entry[0]);
                continue;
            }
            GL11.glEnable((int)entry[0]);
        }
    }
}

