/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.client;

import com.google.common.collect.Lists;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ItemRelocator;
import gravisuite.network.PacketManagePoints;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiRelocatorDisplay
extends GuiContainer {
    private static ResourceLocation tex = new ResourceLocation("gravisuite", "textures/gui/relocator_display.png");
    private int mouseX;
    private int mouseY;
    private int itemInterval;
    private int firstItemX;
    private int firstItemY;
    private int cancelBtnX1;
    private int cancelBtnSize;
    private int firstSelX;
    private int firstSelY;
    private int selWidth;
    private int selHeight;
    private int firstItemBGX;
    private int firstItemBGY;
    private int itemBGinterval;
    private int cancelBtnWidth;
    private int cancelBtnHeight;
    private int openType;
    private int itemBGX;
    private int itemBGY;
    private int itemBGWidth;
    private int itemBGHeight;
    private int itemBGdefX;
    private int itemBGdefY;
    private int itemBGselX;
    private int itemBGselY;
    private int itemBGdelX;
    private int itemBGdelY;
    public static final int GUI_POINT_DISPLAY_LIST = 0;
    public static final int GUI_POINT_DISPLAY_DEFSELECT = 1;

    public GuiRelocatorDisplay(int guiType) {
        super((Container)new ContainerRelocatorDisplay());
        this.field_146999_f = 162;
        this.field_147000_g = 129;
        this.firstItemX = 17;
        this.firstItemY = 16;
        this.firstItemBGX = 14;
        this.firstItemBGY = 14;
        this.firstSelX = 15;
        this.firstSelY = 15;
        this.selWidth = 132;
        this.selHeight = 9;
        this.itemBGinterval = 10;
        this.itemInterval = 10;
        this.cancelBtnX1 = 138;
        this.cancelBtnWidth = 9;
        this.cancelBtnHeight = 9;
        this.itemBGX = 0;
        this.itemBGY = 131;
        this.itemBGWidth = 134;
        this.itemBGHeight = 11;
        this.itemBGselX = 0;
        this.itemBGselY = 144;
        this.itemBGdelX = 0;
        this.itemBGdelY = 157;
        this.itemBGdefX = 0;
        this.itemBGdefY = 170;
        this.openType = guiType;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public SelectedItem getSelected(List<ItemRelocator.TeleportPoint> tpList) {
        SelectedItem tmpSel = new SelectedItem();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        int realMouseX = this.mouseX - xStart;
        int realMouseY = this.mouseY - yStart;
        int itemsCount = tpList.size();
        if (this.isPointInRegion(this.firstSelX, this.firstSelY + 1, this.selWidth, this.itemInterval * itemsCount - 2, this.mouseX, this.mouseY)) {
            double newCalc = (double)(realMouseY - this.firstSelY + 1) / (double)this.itemBGinterval;
            tmpSel.selItem = (int)Math.ceil(newCalc);
            if (this.isPointInRegion(this.cancelBtnX1, this.firstSelY + 1, this.cancelBtnWidth, this.itemInterval * itemsCount - 1, this.mouseX, this.mouseY)) {
                tmpSel.delFlag = true;
            }
            return tmpSel;
        }
        return null;
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        int realMouseX = this.mouseX - xStart;
        int realMouseY = this.mouseY - yStart;
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentItem()));
        SelectedItem selectedItem = this.getSelected(tpList);
        if (selectedItem != null) {
            if (selectedItem.delFlag) {
                PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ((ItemRelocator.TeleportPoint)tpList.get((int)(selectedItem.selItem - 1))).pointName, (byte)0);
            } else {
                if (this.openType == 0) {
                    PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ((ItemRelocator.TeleportPoint)tpList.get((int)(selectedItem.selItem - 1))).pointName, (byte)2);
                }
                if (this.openType == 1) {
                    PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ((ItemRelocator.TeleportPoint)tpList.get((int)(selectedItem.selItem - 1))).pointName, (byte)3);
                }
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    private boolean isPointInRegion(int left, int top, int width, int height, int mouseX, int mouseY) {
        return this.func_146978_c(left, top, width, height, mouseX, mouseY);
    }

    public ItemStack getCurrentItem() {
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g();
    }

    public void sendPoint() {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    protected void func_146979_b(int x, int y) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        try {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentItem()));
            if (tpList.size() > 0) {
                SelectedItem selectedItem;
                for (int i = 0; i < tpList.size(); ++i) {
                    ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(i);
                    this.field_146289_q.func_78276_b(tmpPoint.pointName, this.firstItemX, this.firstItemY + i * this.itemInterval, 0xFFFFFF);
                }
                GameSettings cfr_ignored_0 = this.field_146297_k.field_71474_y;
                if (GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_74311_E) && (selectedItem = this.getSelected(tpList)) != null) {
                    ArrayList<String> toolTipData = new ArrayList<String>();
                    ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(selectedItem.selItem - 1);
                    int hotKey = selectedItem.selItem;
                    if (hotKey == 10) {
                        hotKey = 0;
                    }
                    toolTipData.add(EnumChatFormatting.GOLD + "Hotkey: " + hotKey);
                    toolTipData.add("Dimension: " + DimensionManager.getProvider((int)tmpPoint.dimID).func_80007_l());
                    toolTipData.add("Height: " + (int)tmpPoint.y);
                    toolTipData.add("X: " + (int)tmpPoint.x);
                    toolTipData.add("Y: " + (int)tmpPoint.z);
                    int realMouseX = this.mouseX - xStart;
                    int realMouseY = this.mouseY - yStart;
                    Helpers.renderTooltip(realMouseX - 2, realMouseY, toolTipData);
                }
            }
        }
        catch (Exception e) {
            GraviSuite.addLog("Error in draw relocatorGui foregroundLayer:" + e.toString());
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int x, int y, float par3) {
        super.func_73863_a(x, y, par3);
        this.mouseX = x;
        this.mouseY = y;
    }

    public void func_73876_c() {
    }

    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (keyCode > 1 && keyCode < 12) {
            ArrayList tpList = Lists.newArrayList();
            tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentItem()));
            if (keyCode - 2 < tpList.size()) {
                ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(keyCode - 2);
                PacketManagePoints.issue((EntityPlayer)Minecraft.func_71410_x().field_71439_g, tmpPoint.pointName, (byte)2);
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    protected void func_146976_a(float opacity, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glDisable((int)3042);
        ArrayList tpList = Lists.newArrayList();
        tpList.addAll(ItemRelocator.loadTeleportPoints(this.getCurrentItem()));
        if (tpList.size() > 0) {
            for (int i = 0; i < tpList.size(); ++i) {
                this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + i * this.itemInterval, this.itemBGX, this.itemBGY, this.itemBGWidth, this.itemBGHeight);
                ItemRelocator.TeleportPoint tmpPoint = (ItemRelocator.TeleportPoint)tpList.get(i);
                if (!tmpPoint.defPoint) continue;
                this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + i * this.itemInterval, this.itemBGdefX, this.itemBGdefY, this.itemBGWidth, this.itemBGHeight);
            }
            SelectedItem selectedItem = this.getSelected(tpList);
            if (selectedItem != null) {
                if (!selectedItem.delFlag) {
                    this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + (selectedItem.selItem - 1) * this.itemInterval, this.itemBGselX, this.itemBGselY, this.itemBGWidth, this.itemBGHeight);
                } else {
                    this.func_73729_b(xStart + this.firstItemBGX, yStart + this.firstItemBGY + (selectedItem.selItem - 1) * this.itemInterval, this.itemBGdelX, this.itemBGdelY, this.itemBGWidth, this.itemBGHeight);
                }
            }
        }
    }

    public static class ContainerRelocatorDisplay
    extends Container {
        public boolean func_75145_c(EntityPlayer var1) {
            return true;
        }

        public Slot func_75139_a(int p_75139_1_) {
            return new Slot(new IInventory(){

                public int func_70302_i_() {
                    return 0;
                }

                public ItemStack func_70301_a(int p_70301_1_) {
                    return null;
                }

                public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
                    return null;
                }

                public ItemStack func_70304_b(int p_70304_1_) {
                    return null;
                }

                public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
                }

                public String func_145825_b() {
                    return null;
                }

                public boolean func_145818_k_() {
                    return false;
                }

                public int func_70297_j_() {
                    return 0;
                }

                public void func_70296_d() {
                }

                public boolean func_70300_a(EntityPlayer p_70300_1_) {
                    return false;
                }

                public void func_70295_k_() {
                }

                public void func_70305_f() {
                }

                public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
                    return false;
                }
            }, 0, 0, 0);
        }
    }

    public static class SelectedItem {
        public int selItem = -1;
        public boolean delFlag = false;
    }
}

