/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.api;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuestingAPI {
    private static final HashMap<ApiKey<?>, Object> apis = new HashMap();
    private static Logger logger = null;

    public static <T> void registerAPI(ApiKey<T> key, T api) {
        if (key == null) {
            throw new NullPointerException("API key can not be NULL");
        }
        if (api == null) {
            throw new NullPointerException("Tried to registed NULL API");
        }
        if (apis.containsKey(key)) {
            throw new IllegalArgumentException("Key cannot be registered twice");
        }
        apis.put(key, api);
    }

    public static <T> T getAPI(ApiKey<T> key) {
        Object obj = apis.get(key);
        return (T)(obj == null ? null : obj);
    }

    public static UUID getQuestingUUID(EntityPlayer player) {
        UUID uuid;
        if (player == null) {
            return null;
        }
        if (player.field_70170_p.field_72995_K && (uuid = QuestingAPI.getAPI(ApiReference.NAME_CACHE).getUUID(player.func_146103_bH().getName())) != null) {
            return uuid;
        }
        return player.func_146103_bH().getId();
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getLogger((String)"betterquesting");
        }
        return logger;
    }

    public static EntityPlayerMP getPlayer(UUID uuid) {
        Optional<Object> onlinePlayer = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.stream().filter(i -> i instanceof EntityPlayerMP).filter(o -> QuestingAPI.getQuestingUUID((EntityPlayer)o).equals(uuid)).findFirst();
        return onlinePlayer.isPresent() ? (EntityPlayerMP)onlinePlayer.get() : null;
    }
}

