/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.Arrays;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tmechworks.blocks.SignalTerminal;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.common.MechContent;
import tmechworks.lib.signal.ISignalTransceiver;

public class SignalTerminalLogic
extends TileEntity
implements ISignalTransceiver {
    private byte[] connectedSides = new byte[6];
    private byte[] receivingSides = new byte[6];
    private byte[] sideChannel = new byte[6];
    private boolean forceUpdateSide;
    private boolean neighborChanged;
    private byte[] cachedSouthboundSignals;
    private int pendingSide = -1;
    private CoordTuple signalBus = null;
    private boolean doUpdate = false;
    private boolean isRegistered = false;

    public SignalTerminalLogic() {
        for (int i = 0; i < 6; ++i) {
            this.connectedSides[i] = -1;
            this.receivingSides[i] = -1;
            this.sideChannel[i] = 0;
            this.forceUpdateSide = false;
        }
        this.neighborChanged = false;
    }

    private void tryRegister() {
        boolean wasRegistered = this.isRegistered;
        if (!(this.field_145850_b instanceof World)) {
            return;
        }
        if (!(this.signalBus instanceof CoordTuple)) {
            return;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.signalBus.x, this.signalBus.y, this.signalBus.z);
        if (!(te instanceof SignalBusLogic)) {
            return;
        }
        this.isRegistered = ((SignalBusLogic)te).registerTerminal(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        if (this.isRegistered != wasRegistered) {
            if (this.isRegistered) {
                this.doUpdate = true;
            } else {
                this.signalBus = null;
                this.doUpdate = true;
            }
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.sideChannel = data.func_74770_j("sideChannel");
        this.receivingSides = data.func_74770_j("receivingSides");
        this.connectedSides = data.func_74770_j("connectedSides");
        if (this.sideChannel.length != 6) {
            this.sideChannel = new byte[]{0, 0, 0, 0, 0, 0};
        }
        if (this.receivingSides.length != 6) {
            this.receivingSides = new byte[]{-1, -1, -1, -1, -1, -1};
        }
        if (this.connectedSides.length != 6) {
            this.connectedSides = new byte[]{-1, -1, -1, -1, -1, -1};
        }
        int tX = data.func_74762_e("BusX");
        int tY = data.func_74762_e("BusY");
        int tZ = data.func_74762_e("BusZ");
        this.signalBus = tX == this.field_145851_c && tY == this.field_145848_d && tZ == this.field_145849_e ? null : new CoordTuple((double)tX, (double)tY, (double)tZ);
        if (!this.isRegistered) {
            this.tryRegister();
        }
        this.doUpdate = true;
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74773_a("sideChannel", this.sideChannel);
        data.func_74773_a("receivingSides", this.receivingSides);
        data.func_74773_a("connectedSides", this.connectedSides);
        if (this.signalBus != null) {
            data.func_74768_a("BusX", this.signalBus.x);
            data.func_74768_a("BusY", this.signalBus.y);
            data.func_74768_a("BusZ", this.signalBus.z);
        } else {
            data.func_74768_a("BusX", this.field_145851_c);
            data.func_74768_a("BusY", this.field_145848_d);
            data.func_74768_a("BusZ", this.field_145849_e);
        }
    }

    public void func_145845_h() {
        if (this.pendingSide >= 0 && this.pendingSide < 6 && this.connectedSides[this.pendingSide] == -1) {
            this.connectedSides[this.pendingSide] = 0;
            this.pendingSide = -1;
            this.forceUpdateSide = true;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.forceUpdateSide || this.neighborChanged) {
            this.checkNeighbors();
            this.neighborChanged = false;
            this.forceUpdateSide = false;
        }
        if (!this.doUpdate) {
            return;
        }
        if (!this.isRegistered) {
            this.tryRegister();
        }
        if (this.cachedSouthboundSignals != null) {
            this.processSignalUpdate(this.cachedSouthboundSignals);
        }
        this.doUpdate = false;
    }

    @Override
    public void receiveSignalUpdate(byte[] signals) {
        if (!Arrays.equals(this.cachedSouthboundSignals, signals)) {
            this.cachedSouthboundSignals = (byte[])signals.clone();
            this.doUpdate = true;
        }
    }

    private void processSignalUpdate(byte[] signals) {
        int targetX = 0;
        int targetY = 0;
        int targetZ = 0;
        for (int i = 0; i < 6; ++i) {
            int oSide;
            if (this.connectedSides[i] == -1) continue;
            byte oldValue = this.connectedSides[i];
            this.connectedSides[i] = signals[this.sideChannel[i]];
            if (oldValue == this.connectedSides[i]) continue;
            targetX = this.field_145851_c;
            targetY = this.field_145848_d;
            targetZ = this.field_145849_e;
            switch (i) {
                case 0: {
                    --targetY;
                    oSide = 1;
                    break;
                }
                case 1: {
                    ++targetY;
                    oSide = 0;
                    break;
                }
                case 2: {
                    ++targetZ;
                    oSide = 2;
                    break;
                }
                case 3: {
                    --targetZ;
                    oSide = 3;
                    break;
                }
                case 4: {
                    --targetX;
                    oSide = 5;
                    break;
                }
                case 5: {
                    ++targetX;
                    oSide = 4;
                    break;
                }
                default: {
                    oSide = 0;
                }
            }
            this.field_145850_b.func_147460_e(targetX, targetY, targetZ, MechContent.signalTerminal);
            this.field_145850_b.func_147441_b(targetX, targetY, targetZ, MechContent.signalTerminal, oSide);
        }
    }

    @Override
    public void setBusCoords(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g && !world.field_72995_K && !this.field_145850_b.field_72995_K) {
            this.signalBus = new CoordTuple((double)x, (double)y, (double)z);
            world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doUpdate = true;
    }

    public int isProvidingWeakPower(int side) {
        return this.isProvidingStrongPower(side);
    }

    public int isProvidingStrongPower(int side) {
        int tside = side;
        switch (side) {
            case 0: {
                tside = 1;
                break;
            }
            case 1: {
                tside = 0;
                break;
            }
            case 2: {
                tside = 2;
                break;
            }
            case 3: {
                tside = 3;
                break;
            }
            case 4: {
                tside = 5;
                break;
            }
            case 5: {
                tside = 4;
                break;
            }
            default: {
                tside = side;
            }
        }
        if (tside >= 0 && tside < 6 && this.connectedSides[tside] > 0) {
            return this.connectedSides[tside] - 1;
        }
        return 0;
    }

    public void addPendingSide(int side) {
        this.pendingSide = side;
    }

    public void connectPending() {
        if (this.pendingSide >= 0 && this.pendingSide < 6 && this.connectedSides[this.pendingSide] == -1) {
            this.connectedSides[this.pendingSide] = 0;
        }
        this.pendingSide = -1;
        this.doUpdate = true;
    }

    public byte[] getConnectedSides() {
        return (byte[])this.connectedSides.clone();
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.func_70296_d();
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.doUpdate = true;
    }

    public static IIcon getChannelIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof SignalTerminalLogic) {
            byte channel = ((SignalTerminalLogic)te).sideChannel[side];
            return ((SignalTerminal)MechContent.signalTerminal).getChannelIcon(channel);
        }
        return ((SignalTerminal)MechContent.signalTerminal).getChannelIcon(0);
    }

    public static IIcon[] getChannelIcons() {
        return ((SignalTerminal)MechContent.signalTerminal).channelIcons;
    }

    public static IIcon getChannelIcon(int channel) {
        return SignalTerminalLogic.getChannelIcons()[channel];
    }

    public IIcon getChannelIconFromLogic(int side) {
        return SignalTerminalLogic.getChannelIcons()[this.sideChannel[side]];
    }

    public void nextChannel(int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int n = side;
        this.sideChannel[n] = (byte)(this.sideChannel[n] + 1);
        if (this.sideChannel[side] >= 16) {
            this.sideChannel[side] = 0;
        }
        this.doUpdate = true;
    }

    public void prevChannel(int side) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int n = side;
        this.sideChannel[n] = (byte)(this.sideChannel[n] - 1);
        if (this.sideChannel[side] < 0) {
            this.sideChannel[side] = 15;
        }
        this.doUpdate = true;
    }

    public void notifyBreak() {
        if (!(this.field_145850_b instanceof World) || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.signalBus instanceof CoordTuple)) {
            return;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.signalBus.x, this.signalBus.y, this.signalBus.z);
        if (te == null || !(te instanceof SignalBusLogic)) {
            return;
        }
        ((SignalBusLogic)te).unregisterTerminal(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onNeighborBlockChange() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.neighborChanged = true;
    }

    public void checkNeighbors() {
        if (this.signalBus != null && this.signalBus instanceof CoordTuple) {
            TileEntity te = this.field_145850_b.func_147438_o(this.signalBus.x, this.signalBus.y, this.signalBus.z);
            if (te instanceof SignalBusLogic) {
                ((SignalBusLogic)te).updateTransceiverSignals(new CoordTuple((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e), this.getReceivedSignals());
            }
        } else {
            this.receiveSignalUpdate(this.getReceivedSignals());
        }
    }

    public IIcon[] getSideIcons() {
        IIcon[] icons = SignalTerminalLogic.getChannelIcons();
        IIcon[] sideIcons = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            sideIcons[i] = this.sideChannel[i] > 0 ? icons[this.sideChannel[i]] : icons[0];
        }
        return sideIcons;
    }

    public byte[] getReceivedSignals(boolean vanillaRedstoneKludge) {
        byte[] highChannel = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] offset = new int[]{0, 0, 0};
        for (int i = 0; i < 6; ++i) {
            int oSide;
            if (this.connectedSides[i] == -1) continue;
            offset[0] = 0;
            offset[1] = 0;
            offset[2] = 0;
            switch (i) {
                case 0: {
                    offset[1] = offset[1] + -1;
                    oSide = 1;
                    break;
                }
                case 1: {
                    offset[1] = offset[1] + 1;
                    oSide = 0;
                    break;
                }
                case 2: {
                    offset[2] = offset[2] + 1;
                    oSide = 3;
                    break;
                }
                case 3: {
                    offset[2] = offset[2] + -1;
                    oSide = 2;
                    break;
                }
                case 4: {
                    offset[0] = offset[0] + -1;
                    oSide = 5;
                    break;
                }
                case 5: {
                    offset[0] = offset[0] + 1;
                    oSide = 4;
                    break;
                }
                default: {
                    oSide = i;
                }
            }
            int tempStrength = 0;
            if (this.connectedSides[i] > 0) {
                byte temporarySide = this.connectedSides[i];
                this.connectedSides[i] = -1;
                tempStrength = this.field_145850_b.func_72878_l(this.field_145851_c + offset[0], this.field_145848_d + offset[1], this.field_145849_e + offset[2], oSide);
                if (tempStrength > 0 && tempStrength == temporarySide - 1) {
                    int power = 0;
                    int temp = 0;
                    for (int j = 0; j < 6; ++j) {
                        Block bid;
                        if (offset[0] + Facing.field_71586_b[j] == 0 && offset[1] + Facing.field_71587_c[j] == 0 && offset[2] + Facing.field_71585_d[j] == 0) continue;
                        temp = this.field_145850_b.func_72878_l(this.field_145851_c + offset[0] + Facing.field_71586_b[j], this.field_145848_d + offset[1] + Facing.field_71587_c[j], this.field_145849_e + offset[2] + Facing.field_71585_d[j], j);
                        if (temp > power && (bid = this.field_145850_b.func_147439_a(this.field_145851_c + offset[0] + Facing.field_71586_b[j], this.field_145848_d + offset[1] + Facing.field_71587_c[j], this.field_145849_e + offset[2] + Facing.field_71585_d[j])) != Blocks.field_150488_af) {
                            power = temp;
                        }
                        if (power == tempStrength) break;
                    }
                    tempStrength = power;
                }
                this.connectedSides[i] = temporarySide;
            } else {
                tempStrength = this.field_145850_b.func_72878_l(this.field_145851_c + offset[0], this.field_145848_d + offset[1], this.field_145849_e + offset[2], oSide);
            }
            this.receivingSides[i] = tempStrength > 0 ? (byte)(tempStrength - 1) : (byte)0;
            if (this.receivingSides[i] <= highChannel[this.sideChannel[i]]) continue;
            highChannel[this.sideChannel[i]] = this.receivingSides[i];
        }
        return highChannel;
    }

    @Override
    public int doUnregister(boolean reHoming) {
        int dropWire = 0;
        if (this.signalBus != null) {
            TileEntity te = this.field_145850_b.func_147438_o(this.signalBus.x, this.signalBus.y, this.signalBus.z);
            dropWire = Math.abs(this.field_145851_c - this.signalBus.x) + Math.abs(this.field_145848_d - this.signalBus.y) + Math.abs(this.field_145849_e - this.signalBus.z);
            if (te instanceof SignalBusLogic) {
                ((SignalBusLogic)te).unregisterTerminal(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        this.signalBus = null;
        this.receiveSignalUpdate(this.getReceivedSignals());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return reHoming ? dropWire : 0;
    }

    @Override
    public byte[] getReceivedSignals() {
        return this.getReceivedSignals(false);
    }

    public int getDroppedTerminals() {
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.connectedSides[i] == -1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getDroppedWire() {
        int calcWire = 0;
        if (this.signalBus instanceof CoordTuple) {
            calcWire += Math.abs(this.signalBus.x - this.field_145851_c);
            calcWire += Math.abs(this.signalBus.y - this.field_145848_d);
            return calcWire += Math.abs(this.signalBus.z - this.field_145849_e);
        }
        return 0;
    }

    @Override
    public CoordTuple getBusCoords() {
        return this.signalBus;
    }
}

