/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class DungeonEniko
extends DungeonBase {
    @Override
    public boolean generate(IWorldEditor editor, Random rand, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getPrimaryStair();
        IBlockFactory walls = theme.getPrimaryWall();
        IBlockFactory floor = theme.getPrimaryFloor();
        ArrayList<Coord> chests = new ArrayList<Coord>();
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.add(new Coord(6, -1, 6));
        end.add(new Coord(-6, 4, -6));
        RectHollow.fill(editor, rand, start, end, walls, false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(6, 4, 6));
        end.add(new Coord(-6, 5, -6));
        RectSolid.fill(editor, rand, start, end, theme.getSecondaryWall(), false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(3, 4, 3));
        end.add(new Coord(-3, 4, -3));
        RectSolid.fill(editor, rand, start, end, air, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, -1, -3));
        end.add(new Coord(3, -1, 3));
        RectSolid.fill(editor, rand, start, end, floor, true, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(origin);
            cursor.add(dir, 5);
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord c = new Coord(cursor);
                c.add(o, 2);
                DungeonEniko.pillar(editor, rand, theme, c);
                c = new Coord(cursor);
                c.add(o, 3);
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, c);
                c.add(o);
                stair.setOrientation(Cardinal.reverse(dir), true).set(editor, c);
                c.add(Cardinal.UP);
                chests.add(new Coord(c));
                c.add(Cardinal.reverse(o));
                chests.add(new Coord(c));
            }
            cursor.add(Cardinal.left(dir), 5);
            DungeonEniko.pillar(editor, rand, theme, cursor);
            if (!Arrays.asList(entrances).contains((Object)dir)) continue;
            start = new Coord(origin);
            start.add(Cardinal.DOWN);
            end = new Coord(start);
            start.add(Cardinal.left(dir));
            end.add(Cardinal.right(dir));
            end.add(dir, 6);
            RectSolid.fill(editor, rand, start, end, floor, true, true);
        }
        Spawner.generate(editor, rand, settings, origin);
        Collections.shuffle(chests);
        Treasure.generate(editor, rand, (Coord)chests.remove(0), settings.getDifficulty(origin), false);
        return true;
    }

    private static void pillar(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        IStair stair = theme.getPrimaryStair();
        IBlockFactory pillar = theme.getPrimaryPillar();
        Coord start = new Coord(origin);
        Coord end = new Coord(start);
        end.add(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, start, end, pillar, true, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(end);
            cursor.add(dir);
            stair.setOrientation(dir, true).set(editor, rand, cursor, true, false);
        }
    }

    @Override
    public int getSize() {
        return 7;
    }
}

