/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;

public class PacketDispSettingsAll
implements IMessage,
IMessageHandler<PacketDispSettingsAll, IMessage> {
    private int x;
    private int y;
    private int z;
    private Map<Byte, Map<UUID, Integer>> settings;

    public PacketDispSettingsAll() {
    }

    public PacketDispSettingsAll(int x, int y, int z, Map<Byte, Map<UUID, Integer>> settings) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.settings = settings;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.settings = new HashMap<Byte, Map<UUID, Integer>>();
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            byte slot = buf.readByte();
            int dCount = buf.readShort();
            HashMap<UUID, Integer> setting = new HashMap<UUID, Integer>();
            for (int j = 0; j < dCount; ++j) {
                long most = buf.readLong();
                long least = buf.readLong();
                setting.put(new UUID(most, least), buf.readInt());
            }
            this.settings.put(slot, setting);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.settings.size());
        for (Map.Entry<Byte, Map<UUID, Integer>> slotData : this.settings.entrySet()) {
            buf.writeByte((int)slotData.getKey().byteValue());
            buf.writeShort(slotData.getValue().size());
            for (Map.Entry<UUID, Integer> item : slotData.getValue().entrySet()) {
                UUID key = item.getKey();
                if (key == null) continue;
                buf.writeLong(key.getMostSignificantBits());
                buf.writeLong(key.getLeastSignificantBits());
                buf.writeInt(item.getValue().intValue());
            }
        }
    }

    public IMessage onMessage(PacketDispSettingsAll message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityInfoPanel)) {
            return null;
        }
        TileEntityInfoPanel panel = (TileEntityInfoPanel)tileEntity;
        for (Map.Entry<Byte, Map<UUID, Integer>> slotData : message.settings.entrySet()) {
            Map<UUID, Integer> setting = panel.getDisplaySettingsForSlot(slotData.getKey());
            for (Map.Entry<UUID, Integer> item : slotData.getValue().entrySet()) {
                UUID key = item.getKey();
                if (key == null) continue;
                setting.put(new UUID(key.getMostSignificantBits(), key.getLeastSignificantBits()), item.getValue());
            }
        }
        panel.resetCardData();
        return null;
    }
}

