/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import bartworks.system.material.Werkstoff;
import bartworks.system.oregen.BWOreLayer;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import com.google.common.collect.ImmutableList;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.veintypes.BartworksOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.GregTechOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreMixes;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.regex.Pattern;
import net.minecraft.util.EnumChatFormatting;

public class VeinTypeCaching
implements Runnable {
    private static final Short2ObjectMap<VeinType> veinTypeLookupTableForIds = new Short2ObjectOpenHashMap();
    private static final Map<String, VeinType> veinTypeLookupTableForNames = new HashMap<String, VeinType>();
    private static final Object2ShortMap<String> veinTypeStorageInfo = new Object2ShortOpenHashMap();
    public static ObjectSet<VeinType> veinTypes;

    @Override
    public void run() {
        veinTypes = new ObjectOpenHashSet();
        veinTypes.add((Object)VeinType.NO_VEIN);
        for (OreMixes mix : OreMixes.values()) {
            veinTypes.add((Object)new VeinType(mix.oreMixBuilder));
        }
        for (BWOreLayer vein : BWOreLayer.sList) {
            IOreMaterialProvider oreMaterialProvider = (vein.bwOres & 8) == 0 ? new GregTechOreMaterialProvider(this.getGregTechMaterial((short)vein.mPrimaryMeta)) : new BartworksOreMaterialProvider((Werkstoff)Werkstoff.werkstoffHashMap.get((short)vein.mPrimaryMeta));
            veinTypes.add((Object)new VeinType(vein.mWorldGenName, oreMaterialProvider, vein.mSize, (short)vein.mPrimaryMeta, (short)vein.mSecondaryMeta, (short)vein.mBetweenMeta, (short)vein.mSporadicMeta, Math.max(0, vein.mMinY), Math.min(255, vein.mMaxY), vein.getDimName()));
        }
        VeinTypeCaching.loadVeinTypeStorageInfo();
        OptionalInt maxVeinTypeIdOptional = veinTypeStorageInfo.values().intStream().max();
        short maxVeinTypeId = (short)maxVeinTypeIdOptional.orElse(0);
        for (VeinType veinType : veinTypes) {
            maxVeinTypeId = (short)(maxVeinTypeId + 1);
            veinType.veinId = veinTypeStorageInfo.getOrDefault((Object)veinType.name, maxVeinTypeId);
            veinTypeStorageInfo.putIfAbsent((Object)veinType.name, veinType.veinId);
            veinTypeLookupTableForIds.put(veinType.veinId, (Object)veinType);
            veinTypeLookupTableForNames.put(veinType.name, veinType);
        }
        VeinTypeCaching.saveVeinTypeStorageInfo();
    }

    private Materials getGregTechMaterial(short metaId) {
        Materials material = GregTechAPI.sGeneratedMaterials[metaId];
        if (material == null) {
            return Materials.getAll().stream().filter(m -> m.mMetaItemSubID == metaId).findAny().orElse(Materials._NULL);
        }
        return material;
    }

    public static VeinType getVeinType(short veinTypeId) {
        return (VeinType)veinTypeLookupTableForIds.getOrDefault(veinTypeId, (Object)VeinType.NO_VEIN);
    }

    public static VeinType getVeinType(String veinTypeName) {
        return veinTypeLookupTableForNames.getOrDefault(veinTypeName, VeinType.NO_VEIN);
    }

    private static File getVeinTypeStorageInfoFile() {
        File directory = Utils.getSubDirectory("visualprospecting/");
        directory.mkdirs();
        return new File(directory, "veintypesLUT");
    }

    private static void loadVeinTypeStorageInfo() {
        veinTypeStorageInfo.putAll(Utils.readFileToMap(VeinTypeCaching.getVeinTypeStorageInfoFile()));
    }

    private static void saveVeinTypeStorageInfo() {
        Utils.writeMapToFile(VeinTypeCaching.getVeinTypeStorageInfoFile(), veinTypeStorageInfo);
    }

    public static void recalculateNEISearch() {
        if (Utils.isNEIInstalled()) {
            boolean isSearchActive = SearchField.searchInventories();
            String searchString = NEIClientConfig.getSearchExpression().toLowerCase();
            Pattern filterPattern = SearchField.getPattern((String)searchString);
            for (VeinType veinType : veinTypes) {
                if (veinType == VeinType.NO_VEIN) continue;
                if (isSearchActive && !searchString.isEmpty()) {
                    ImmutableList<String> searchableStrings = veinType.getOreMaterialNames();
                    boolean match = searchableStrings.stream().map(EnumChatFormatting::func_110646_a).map(String::toLowerCase).anyMatch(searchableString -> filterPattern.matcher((CharSequence)searchableString).find());
                    veinType.setNEISearchHighlight(match);
                    continue;
                }
                veinType.setNEISearchHighlight(true);
            }
        }
    }
}

