/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.lwjgl.input.Keyboard;

public class OreVeinLocation
implements IWaypointAndLocationProvider {
    private static final String depletedHint = EnumChatFormatting.RED + I18n.func_135052_a((String)"visualprospecting.depleted", (Object[])new Object[0]);
    private static final String activeWaypointHint = EnumChatFormatting.GOLD + I18n.func_135052_a((String)"visualprospecting.iswaypoint", (Object[])new Object[0]);
    private static final String toggleDepletedHint = EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"visualprospecting.node.deletehint", (Object[])new Object[]{Keyboard.getKeyName((int)NavigatorApi.ACTION_KEY.func_151463_i())});
    private final OreVeinPosition oreVeinPosition;
    private final String name;
    private final List<String> materialNames;
    private boolean isActiveAsWaypoint;

    public OreVeinLocation(OreVeinPosition oreVeinPosition) {
        this.oreVeinPosition = oreVeinPosition;
        this.name = EnumChatFormatting.WHITE + oreVeinPosition.veinType.getPrimaryOreName();
        this.materialNames = oreVeinPosition.veinType.getOreMaterialNames().stream().map(materialName -> EnumChatFormatting.GRAY + materialName).collect(Collectors.toList());
    }

    public Waypoint toWaypoint() {
        return new Waypoint(this.oreVeinPosition.getBlockX(), 65, this.oreVeinPosition.getBlockZ(), this.oreVeinPosition.dimensionId, I18n.func_135052_a((String)"visualprospecting.tracked", (Object[])new Object[]{this.oreVeinPosition.veinType.getPrimaryOreName()}), this.getColor());
    }

    public boolean isActiveAsWaypoint() {
        return this.isActiveAsWaypoint;
    }

    public void onWaypointCleared() {
        this.isActiveAsWaypoint = false;
    }

    public void onWaypointUpdated(Waypoint waypoint) {
        this.isActiveAsWaypoint = waypoint.dimensionId == this.oreVeinPosition.dimensionId && waypoint.blockX == this.oreVeinPosition.getBlockX() && waypoint.blockZ == this.oreVeinPosition.getBlockZ();
    }

    public void toggleOreVein() {
        ClientCache.instance.toggleOreVein(this.oreVeinPosition.dimensionId, this.oreVeinPosition.chunkX, this.oreVeinPosition.chunkZ);
    }

    public int getDimensionId() {
        return this.oreVeinPosition.dimensionId;
    }

    public double getBlockX() {
        return (double)this.oreVeinPosition.getBlockX() + 0.5;
    }

    public double getBlockZ() {
        return (double)this.oreVeinPosition.getBlockZ() + 0.5;
    }

    public boolean isDepleted() {
        return this.oreVeinPosition.isDepleted();
    }

    public String getDepletedHint() {
        return depletedHint;
    }

    public String getActiveWaypointHint() {
        return activeWaypointHint;
    }

    public String getName() {
        return this.name;
    }

    public String getToggleDepletedHint() {
        return toggleDepletedHint;
    }

    public List<String> getMaterialNames() {
        return this.materialNames;
    }

    public boolean drawSearchHighlight() {
        return this.oreVeinPosition.veinType.isHighlighted();
    }

    public int getColor() {
        return this.oreVeinPosition.veinType.oreMaterialProvider.getColor();
    }

    public IIcon getIconFromPrimaryOre() {
        return this.oreVeinPosition.veinType.oreMaterialProvider.getIcon();
    }
}

