/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.mixins;

import com.gtnewhorizons.gravisuiteneo.common.Achievements;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.util.LevelableToolHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ItemAdvDDrill;
import gravisuite.ServerProxy;
import ic2.api.item.ElectricItem;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemAdvDDrill.class})
public abstract class MixinItemAdvDDrill
extends ItemTool {
    @Unique
    private final int areYouSerious;
    @Unique
    private final int worldShatterer;
    @Shadow(remap=false)
    private float bigHolePower;
    @Shadow(remap=false)
    private float normalPower;
    @Shadow(remap=false)
    private float lowPower;
    @Shadow(remap=false)
    private float ultraLowPower;
    @Shadow(remap=false)
    private int energyPerOperation;
    @Shadow(remap=false)
    private static Material[] materials;

    @Shadow(remap=false)
    public abstract void saveToolMode(ItemStack var1, Integer var2);

    @ModifyConstant(constant={@Constant(floatValue=1.0f, ordinal=0)}, method={"getDigSpeed"}, remap=false)
    private float gravisuiteneo$getDigSpeedUncharged(float original) {
        return 0.0f;
    }

    @Overwrite(remap=false)
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return super.getHarvestLevel(stack, toolClass);
    }

    @Inject(at={@At(remap=false, target="Lgravisuite/ItemAdvDDrill;readToolMode(Lnet/minecraft/item/ItemStack;)Ljava/lang/Integer;", value="INVOKE")}, cancellable=true, method={"onBlockDestroyed"})
    private void gravisuiteneo$onBlockDestroyedExitEarly(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityliving, CallbackInfoReturnable<Boolean> cir) {
        if (!(entityliving instanceof EntityPlayer)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(opcode=178, remap=false, target="Lic2/api/item/ElectricItem;manager:Lic2/api/item/IElectricItemManager;", value="FIELD")}, method={"onBlockDestroyed"})
    private void gravisuiteneo$addXpMode(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityliving, CallbackInfoReturnable<Boolean> cir) {
        LevelableToolHelper.AddXP((EntityPlayer)entityliving, itemstack, 1);
    }

    @ModifyConstant(constant={@Constant(intValue=3)}, method={"readToolMode"}, remap=false)
    private static int gravisuiteneo$getMaxToolMode(int original) {
        return 5;
    }

    @Overwrite
    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        if (!gravisuite.keyboard.Keyboard.isModeKeyDown((EntityPlayer)player)) {
            return itemStackIn;
        }
        int toolMode = ItemAdvDDrill.readToolMode((ItemStack)itemStackIn);
        if (++toolMode > 5) {
            toolMode = 0;
        }
        if (toolMode == 4 && !LevelableToolHelper.hasLevel(itemStackIn, 1)) {
            toolMode = 0;
        }
        if (toolMode == 5 && !LevelableToolHelper.hasLevel(itemStackIn, 2)) {
            toolMode = 0;
        }
        this.saveToolMode(itemStackIn, toolMode);
        StringBuilder message = new StringBuilder();
        message.append(EnumChatFormatting.GREEN);
        message.append(StatCollector.func_74838_a((String)"message.text.mode"));
        message.append(": ");
        switch (toolMode) {
            case 0: {
                message.append(EnumChatFormatting.GREEN);
                message.append(StatCollector.func_74838_a((String)"message.advDDrill.mode.normal"));
                this.field_77864_a = this.normalPower;
                break;
            }
            case 1: {
                message.append(EnumChatFormatting.GOLD);
                message.append(StatCollector.func_74838_a((String)"message.advDDrill.mode.lowPower"));
                this.field_77864_a = this.lowPower;
                break;
            }
            case 2: {
                message.append(EnumChatFormatting.AQUA);
                message.append(StatCollector.func_74838_a((String)"message.advDDrill.mode.fine"));
                this.field_77864_a = this.ultraLowPower;
                break;
            }
            case 3: {
                message.append(EnumChatFormatting.LIGHT_PURPLE);
                message.append(StatCollector.func_74838_a((String)"message.advDDrill.mode.bigHoles"));
                this.field_77864_a = this.bigHolePower;
                break;
            }
            case 4: {
                message.append(EnumChatFormatting.RED);
                message.append(StatCollector.func_74838_a((String)"message.advDDrill.mode.areYouSerious"));
                this.field_77864_a = this.areYouSerious;
                break;
            }
            case 5: {
                message.append(EnumChatFormatting.DARK_RED);
                message.append(StatCollector.func_74838_a((String)"message.advDDrill.mode.worldShatterer"));
                this.field_77864_a = this.worldShatterer;
                break;
            }
        }
        ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)message.toString());
        return itemStackIn;
    }

    @Inject(at={@At(remap=false, target="Lgravisuite/ItemAdvDDrill;readToolMode(Lnet/minecraft/item/ItemStack;)Ljava/lang/Integer;", value="INVOKE")}, method={"addInformation"})
    @SideOnly(value=Side.CLIENT)
    private void gravisuiteneo$addXPInformation(ItemStack itemstack, EntityPlayer player, List<String> tooltip, boolean advancedTooltip, CallbackInfo ci) {
        if (!Keyboard.isKeyDown((int)42)) {
            return;
        }
        int currentTotalXP = (int)LevelableToolHelper.readToolXP(itemstack);
        int currentLevel = LevelableToolHelper.getLevel(itemstack);
        if (currentLevel < 2) {
            tooltip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.xp.youhavecollected") + ": " + EnumChatFormatting.WHITE + currentTotalXP);
            tooltip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.xp.nextLevelUp") + ": " + EnumChatFormatting.WHITE + LevelableToolHelper.getXPForLevel(currentLevel + 1));
            tooltip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.xp.toolLevel") + ": " + EnumChatFormatting.WHITE + currentLevel);
        } else {
            tooltip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.xp.maxLevelReached"));
        }
    }

    @Inject(at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, method={"addInformation"})
    @SideOnly(value=Side.CLIENT)
    private void gravisuiteneo$addOtherModeInformation(ItemStack itemstack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips, CallbackInfo ci, Integer toolMode) {
        if (toolMode == 4) {
            tooltip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"message.advDDrill.mode.areYouSerious"));
            return;
        }
        if (toolMode == 5) {
            tooltip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"message.text.mode") + ": " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"message.advDDrill.mode.worldShatterer"));
        }
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        switch (LevelableToolHelper.getLevel(itemstack)) {
            case 1: {
                return EnumRarity.rare;
            }
            case 2: {
                return EnumRarity.epic;
            }
        }
        return EnumRarity.uncommon;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        int toolMode = ItemAdvDDrill.readToolMode((ItemStack)itemstack);
        if (toolMode >= 3) {
            MovingObjectPosition mop;
            int tTotalToolXPGain = 0;
            boolean canCollectXP = !this.hasMaxLevel(itemstack);
            World world = player.field_70170_p;
            Block block = world.func_147439_a(X, Y, Z);
            int meta = world.func_72805_g(X, Y, Z);
            boolean lowPower = false;
            if (block == null) {
                return super.onBlockStartBreak(itemstack, X, Y, Z, player);
            }
            float blockHardness = block.func_149712_f(world, X, Y, Z);
            boolean validStart = false;
            for (Material material : materials) {
                if (material != block.func_149688_o()) continue;
                validStart = true;
                break;
            }
            if (block == Blocks.field_150418_aU) {
                validStart = true;
            }
            if ((mop = ItemAdvDDrill.raytraceFromEntity((World)world, (Entity)player, (boolean)true, (double)4.5)) == null || !validStart) {
                return super.onBlockStartBreak(itemstack, X, Y, Z, player);
            }
            int xRange = 1 + (toolMode - 3) * 2;
            int yRange = 1 + (toolMode - 3) * 2;
            int zRange = 1 + (toolMode - 3) * 2;
            switch (mop.field_72310_e) {
                case 0: 
                case 1: {
                    yRange = 0;
                    break;
                }
                case 2: 
                case 3: {
                    zRange = 0;
                    break;
                }
                case 4: 
                case 5: {
                    xRange = 0;
                }
            }
            int tFinalEnergyPerOperation = this.energyPerOperation;
            if (toolMode == 4) {
                tFinalEnergyPerOperation = this.areYouSerious;
            } else if (toolMode == 5) {
                tFinalEnergyPerOperation = this.worldShatterer;
            }
            int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            for (int xPos = X - xRange; xPos <= X + xRange; ++xPos) {
                for (int yPos = Y - yRange; yPos <= Y + yRange; ++yPos) {
                    for (int zPos = Z - zRange; zPos <= Z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(itemstack, (double)tFinalEnergyPerOperation)) {
                            float localHardness;
                            Block localBlock = world.func_147439_a(xPos, yPos, zPos);
                            int localMeta = world.func_72805_g(xPos, yPos, zPos);
                            boolean canHarvest = this.canHarvestBlock(block, itemstack);
                            float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                            if (!canHarvest || localBlock == null || !(localHardness >= 0.0f)) continue;
                            for (Material material : materials) {
                                if (material != localBlock.func_149688_o() && localBlock != Blocks.field_150418_aU) continue;
                                if (!player.field_71075_bZ.field_75098_d) {
                                    if (localBlock.removedByPlayer(world, player, xPos, yPos, zPos, true)) {
                                        localBlock.func_149664_b(world, xPos, yPos, zPos, localMeta);
                                    }
                                    int exp = localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune);
                                    if (!canCollectXP) {
                                        localBlock.func_149657_c(world, xPos, yPos, zPos, exp);
                                    } else {
                                        tTotalToolXPGain += Math.max(exp, 1);
                                    }
                                    localBlock.func_149636_a(world, player, xPos, yPos, zPos, localMeta);
                                    localBlock.func_149681_a(world, xPos, yPos, zPos, localMeta, player);
                                    if (blockHardness > 0.0f) {
                                        this.func_150894_a(itemstack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                                    }
                                    world.func_147479_m(X, Y, Z);
                                    ElectricItem.manager.use(itemstack, (double)tFinalEnergyPerOperation, (EntityLivingBase)player);
                                    continue;
                                }
                                Helpers.setBlockToAir((World)world, (int)xPos, (int)yPos, (int)zPos);
                                world.func_147479_m(X, Y, Z);
                            }
                            continue;
                        }
                        lowPower = true;
                    }
                }
            }
            LevelableToolHelper.AddXP(player, itemstack, tTotalToolXPGain);
            if (canCollectXP && LevelableToolHelper.getLevel(itemstack) == 2) {
                player.func_71029_a((StatBase)Achievements.POWERDRILL_MARKIII);
            }
            if (!GraviSuite.isSimulating()) {
                world.func_72926_e(2001, X, Y, Z, Block.func_149682_b((Block)block) + (meta << 12));
            }
            if (lowPower) {
                ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)StatCollector.func_74838_a((String)"message.advDDrill.noEnergy"));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        int level = LevelableToolHelper.getLevel(stack);
        float attackDamage = 1.0f;
        if (level == 1) {
            attackDamage = 10.0f;
        } else if (level == 2) {
            attackDamage = 30.0f;
        }
        if (ElectricItem.manager.use(stack, (double)(this.energyPerOperation * 10), p_77644_3_)) {
            p_77644_2_.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)p_77644_3_)), attackDamage);
        } else {
            p_77644_2_.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)p_77644_3_)), 1.0f);
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        switch (LevelableToolHelper.getLevel(stack)) {
            case 2: {
                return "item.advDDrill_level2";
            }
            case 3: {
                return "item.advDDrill_level3";
            }
        }
        return "item.advDDrill";
    }

    public boolean hasMaxLevel(ItemStack pItemStack) {
        return LevelableToolHelper.getLevel(pItemStack) >= 2;
    }

    public void setXP(ItemStack pItemStack, double pXP) {
        LevelableToolHelper.saveToolXP(pItemStack, Math.min((double)LevelableToolHelper.getXPForLevel(2), pXP));
    }

    public void setLevel(ItemStack pItemStack, int pLevel) {
        LevelableToolHelper.saveToolXP(pItemStack, LevelableToolHelper.getXPForLevel(Math.min(2, pLevel)));
    }

    private MixinItemAdvDDrill(float p_i45333_1_, Item.ToolMaterial p_i45333_2_, Set<Block> p_i45333_3_) {
        super(p_i45333_1_, p_i45333_2_, p_i45333_3_);
        this.areYouSerious = Properties.ElectricPresets.AdvDrill.energyPerOperation * 2;
        this.worldShatterer = Properties.ElectricPresets.AdvDrill.energyPerOperation * 4;
    }
}

