/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import cpw.mods.fml.client.FMLClientHandler;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.log.JMLogger;
import journeymap.client.log.LogFormatter;
import journeymap.common.Journeymap;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.Display;

public class WorldData
extends CacheLoader<Class, WorldData> {
    String name;
    int dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;
    int browser_poll;
    public static TIntObjectMap<String> dimNames = new TIntObjectHashMap();

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.instance().getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            return ForgeHelper.INSTANCE.getRealmsServerName().replace(':', '_');
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName().replace(':', '_');
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            NetworkManager netManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            if (netManager != null && (socketAddress = ForgeHelper.INSTANCE.getSocketAddress(netManager)) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWorldName(Minecraft mc, boolean useLegacyName) {
        String worldName = null;
        if (mc.func_71356_B()) {
            if (!useLegacyName) return mc.func_71401_C().func_71270_I();
            worldName = mc.func_71401_C().func_71221_J();
        } else {
            worldName = mc.field_71441_e.func_72912_H().func_76065_j();
            String serverName = WorldData.getServerName();
            if (serverName == null) {
                return "offline";
            }
            worldName = !"MpServer".equals(worldName) ? serverName + "_" + worldName : serverName;
        }
        worldName = useLegacyName ? WorldData.getLegacyUrlEncodedWorldName(worldName) : worldName.trim();
        if (!Strings.isNullOrEmpty((String)worldName.trim())) return worldName;
        return "unnamed";
    }

    private static String getLegacyUrlEncodedWorldName(String worldName) {
        try {
            return URLEncoder.encode(worldName, "UTF-8").replace("+", " ");
        }
        catch (UnsupportedEncodingException e) {
            return worldName;
        }
    }

    public static List<WorldProvider> getDimensionProviders(List<Integer> requiredDimensionList) {
        try {
            WorldProvider provider;
            HashSet<Integer> requiredDims = new HashSet<Integer>(requiredDimensionList);
            HashMap<Integer, WorldProvider> dimProviders = new HashMap<Integer, WorldProvider>();
            Level logLevel = Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            Integer[] dims = DimensionManager.getIDs();
            Journeymap.getLogger().log(logLevel, String.format("DimensionManager has dims: %s", Arrays.asList(dims)));
            requiredDims.addAll(Arrays.asList(dims));
            dims = DimensionManager.getStaticDimensionIDs();
            Journeymap.getLogger().log(logLevel, String.format("DimensionManager has static dims: %s", Arrays.asList(dims)));
            requiredDims.addAll(Arrays.asList(dims));
            WorldProvider playerProvider = ForgeHelper.INSTANCE.getClient().field_71439_g.field_70170_p.field_73011_w;
            int dimId = ForgeHelper.INSTANCE.getDimension(playerProvider);
            dimProviders.put(dimId, playerProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerProvider)));
            for (int dim : requiredDims) {
                if (dimProviders.containsKey(dim)) continue;
                if (DimensionManager.getWorld((int)dim) != null) {
                    try {
                        WorldProvider dimProvider = DimensionManager.getProvider((int)dim);
                        dimProvider.func_80007_l();
                        dimProviders.put(dim, dimProvider);
                        Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", dim, WorldData.getSafeDimensionName(dimProvider)));
                    }
                    catch (Throwable t) {
                        JMLogger.logOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", dim, t), t);
                    }
                    continue;
                }
                try {
                    provider = DimensionManager.createProviderFor((int)dim);
                    provider.func_80007_l();
                    provider.setDimension(dim);
                    dimProviders.put(dim, provider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.createProviderFor(%s): %s", dim, WorldData.getSafeDimensionName(playerProvider)));
                }
                catch (Throwable t) {
                    JMLogger.logOnce(String.format("Couldn't DimensionManager.createProviderFor(%s) because of error: %s", dim, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (int dim : requiredDims) {
                if (dimProviders.containsKey(dim)) continue;
                provider = new FakeDimensionProvider(dim);
                dimProviders.put(dim, provider);
                Journeymap.getLogger().warn(String.format("Used FakeDimensionProvider for required dim: %s", dim));
            }
            ArrayList<WorldProvider> providerList = new ArrayList<WorldProvider>(dimProviders.values());
            Collections.sort(providerList, new Comparator<WorldProvider>(){

                @Override
                public int compare(WorldProvider o1, WorldProvider o2) {
                    return Integer.valueOf(ForgeHelper.INSTANCE.getDimension(o1)).compareTo(ForgeHelper.INSTANCE.getDimension(o2));
                }
            });
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(WorldProvider worldProvider) {
        if (worldProvider == null) {
            return null;
        }
        try {
            String dimName = (String)dimNames.get(worldProvider.field_76574_g);
            if (dimName == null) {
                String langKey = String.format("jm.common.dimension.%1$d.name", worldProvider.field_76574_g);
                if (langKey.equals(dimName = Constants.getString(langKey))) {
                    dimName = worldProvider.func_80007_l();
                }
                dimNames.put(worldProvider.field_76574_g, (Object)dimName);
            }
            return dimName;
        }
        catch (Exception e) {
            JMLogger.logOnce(String.format("Failed to retrieve dimension %d error: ", worldProvider.field_76574_g), e);
            return Constants.getString("jm.common.dimension", ForgeHelper.INSTANCE.getDimension(worldProvider));
        }
    }

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = ForgeHelper.INSTANCE.getClient();
        WorldInfo worldInfo = mc.field_71441_e.func_72912_H();
        IntegratedServer server = mc.func_71401_C();
        boolean multiplayer = server == null || server.func_71344_c();
        this.name = WorldData.getWorldName(mc, false);
        this.dimension = ForgeHelper.INSTANCE.getDimension(mc.field_71441_e.field_73011_w);
        this.hardcore = worldInfo.func_76093_s();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_71441_e.func_72820_D() % 24000L;
        this.features = FeatureManager.getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = Display.getTitle().split("\\s(?=\\d)")[1];
        this.browser_poll = Math.max(1000, JourneymapClient.getCoreProperties().browserPoll.get());
        this.iconSetName = JourneymapClient.getFullMapProperties().getEntityIconSetName().get();
        this.iconSetNames = IconSetFileHandler.getEntityIconSetNames().toArray(new String[0]);
        return this;
    }

    public long getTTL() {
        return 1000L;
    }

    static {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager p_110549_1_) {
                dimNames.clear();
            }
        });
    }

    static class FakeDimensionProvider
    extends WorldProvider {
        FakeDimensionProvider(int dimension) {
            this.field_76574_g = dimension;
        }

        public String func_80007_l() {
            return Constants.getString("jm.common.dimension", this.field_76574_g);
        }

        public String getInternalNameSuffix() {
            return "fake";
        }
    }
}

