/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.common.carts.EntityCartFiltered;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCartItemFiltered
implements IItemRenderer {
    RenderItem renderItem = new RenderItem();
    private final RendererType rendererType;

    public RenderCartItemFiltered(RendererType rendererType) {
        this.rendererType = rendererType;
    }

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        IIcon cartTexture = stack.func_77954_c();
        this.renderItem.func_94149_a(0, 0, cartTexture, 16, 16);
        ItemStack filter = EntityCartFiltered.getFilterFromCartItem(stack);
        if (filter != null) {
            this.rendererType.setupRender();
            RenderItem.getInstance().func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), filter, 0, 0);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static enum RendererType {
        Tank{

            @Override
            public void setupRender() {
                GL11.glTranslatef((float)-1.0f, (float)6.5f, (float)0.0f);
                float scale = 0.6f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            }
        }
        ,
        Cargo{

            @Override
            public void setupRender() {
                GL11.glTranslatef((float)4.5f, (float)2.0f, (float)0.0f);
                float scale = 0.5f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            }
        };


        public abstract void setupRender();
    }
}

