/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFHoverBeam;
import twilightforest.entity.ai.EntityAITFHoverSummon;
import twilightforest.entity.ai.EntityAITFHoverThenDrop;
import twilightforest.entity.boss.EntityTFIceCrystal;
import twilightforest.entity.boss.EntityTFSnowQueenIceShield;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFSnowQueen
extends EntityMob
implements IBossDisplayData,
IEntityMultiPart,
IBreathAttacker {
    private static final int MAX_SUMMONS = 6;
    private static final int BEAM_FLAG = 21;
    private static final int PHASE_FLAG = 22;
    private static final int MAX_DAMAGE_WHILE_BEAMING = 25;
    private static final float BREATH_DAMAGE = 4.0f;
    public Entity[] iceArray;
    private int summonsRemaining = 0;
    private int successfulDrops;
    private int maxDrops;
    private int damageWhileBeaming;

    public EntityTFSnowQueen(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITFHoverSummon(this, EntityPlayer.class, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITFHoverThenDrop(this, EntityPlayer.class, 80, 20));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITFHoverBeam(this, EntityPlayer.class, 80, 100));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.func_70105_a(0.7f, 2.2f);
        this.iceArray = new Entity[7];
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i] = new EntityTFSnowQueenIceShield(this);
        }
        this.setCurrentPhase(Phase.SUMMON);
        this.field_70178_ae = true;
        this.field_70728_aV = 317;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "TwilightForest:mob.ice.noise";
    }

    public String getTrophySound() {
        return this.func_70639_aQ();
    }

    protected String func_70621_aR() {
        return "TwilightForest:mob.ice.hurt";
    }

    protected String func_70673_aS() {
        return "TwilightForest:mob.ice.death";
    }

    protected Item func_146068_u() {
        return Items.field_151126_ay;
    }

    protected void func_82162_bC() {
        super.func_82162_bC();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData data = super.func_110161_a(par1EntityLivingData);
        return data;
    }

    public void func_70636_d() {
        this.despawnIfInvalid();
        super.func_70636_d();
        for (int i = 0; i < 3; ++i) {
            float px = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
            float py = this.func_70047_e() + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
            float pz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.field_70170_p, "snowguardian", this.field_70142_S + (double)px, this.field_70137_T + (double)py, this.field_70136_U + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.getCurrentPhase() == Phase.DROP) {
            for (Entity entity : this.iceArray) {
                float px = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
                float py = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
                float pz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.5f;
                TwilightForestMod.proxy.spawnParticle(this.field_70170_p, "snowwarning", entity.field_70142_S + (double)px, entity.field_70137_T + (double)py, entity.field_70136_U + (double)pz, 0.0, 0.0, 0.0);
            }
        }
        if (this.isBreathing() && this.func_70089_S()) {
            Vec3 look = this.func_70040_Z();
            double dist = 0.5;
            double px = this.field_70165_t + look.field_72450_a * dist;
            double py = this.field_70163_u + (double)1.7f + look.field_72448_b * dist;
            double pz = this.field_70161_v + look.field_72449_c * dist;
            for (int i = 0; i < 10; ++i) {
                double dx = look.field_72450_a;
                double dy = 0.0;
                double dz = look.field_72449_c;
                double spread = 2.0 + this.func_70681_au().nextDouble() * 2.5;
                double velocity = 2.0 + this.func_70681_au().nextDouble() * 0.15;
                dx += this.func_70681_au().nextGaussian() * 0.0075 * spread;
                dy += this.func_70681_au().nextGaussian() * 0.0075 * spread;
                dz += this.func_70681_au().nextGaussian() * 0.0075 * spread;
                TwilightForestMod.proxy.spawnParticle(this.field_70170_p, "icebeam", px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    protected void despawnIfInvalid() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.despawnMe();
        }
    }

    protected void despawnMe() {
        if (this.func_110175_bO()) {
            ChunkCoordinates home = this.func_110172_bL();
            this.field_70170_p.func_147465_d(home.field_71574_a, home.field_71572_b, home.field_71573_c, TFBlocks.bossSpawner, 5, 2);
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        ChunkCoordinates home = this.func_110172_bL();
        nbttagcompound.func_74782_a("Home", (NBTBase)this.func_70087_a(new double[]{home.field_71574_a, home.field_71572_b, home.field_71573_c}));
        nbttagcompound.func_74757_a("HasHome", this.func_110175_bO());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_150297_b("Home", 9)) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Home", 6);
            int hx = (int)nbttaglist.func_150309_d(0);
            int hy = (int)nbttaglist.func_150309_d(1);
            int hz = (int)nbttaglist.func_150309_d(2);
            this.func_110171_b(hx, hy, hz, 20);
        }
        if (!nbttagcompound.func_74767_n("HasHome")) {
            this.func_110177_bN();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.iceArray.length; ++i) {
            this.iceArray[i].func_70071_h_();
            if (i < this.iceArray.length - 1) {
                Vec3 blockPos = this.getIceShieldPosition(i);
                this.iceArray[i].func_70107_b(blockPos.field_72450_a, blockPos.field_72448_b, blockPos.field_72449_c);
                this.iceArray[i].field_70177_z = this.getIceShieldAngle(i);
            } else {
                this.iceArray[i].func_70107_b(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                this.iceArray[i].field_70177_z = this.getIceShieldAngle(i);
            }
            if (this.field_70170_p.field_72995_K) continue;
            this.applyShieldCollisions(this.iceArray[i]);
        }
        if (this.field_70725_aQ > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                String explosionType = this.field_70146_Z.nextBoolean() ? "hugeexplosion" : "explode";
                this.field_70170_p.func_72869_a(explosionType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
            }
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        int i;
        this.dropBow();
        int totalDrops = this.field_70146_Z.nextInt(4 + par2) + 1;
        for (i = 0; i < totalDrops; ++i) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150403_cj), 7);
        }
        totalDrops = this.field_70146_Z.nextInt(5 + par2) + 5;
        for (i = 0; i < totalDrops; ++i) {
            this.func_145779_a(Items.field_151126_ay, 16);
        }
        this.func_70099_a(new ItemStack(TFItems.trophy, 1, 4), 0.0f);
    }

    private void dropBow() {
        int bowType = this.field_70146_Z.nextInt(2);
        if (bowType == 0) {
            this.func_70099_a(new ItemStack(TFItems.tripleBow), 0.0f);
        } else {
            this.func_70099_a(new ItemStack(TFItems.seekerBow), 0.0f);
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71093_bK == TwilightForestMod.dimensionID) {
            ((EntityPlayer)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TFAchievementPage.twilightProgressGlacier);
        }
        if (!this.field_70170_p.field_72995_K) {
            int dx = MathHelper.func_76128_c((double)this.field_70165_t);
            int dy = MathHelper.func_76128_c((double)this.field_70163_u);
            int dz = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest) {
                ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.field_70170_p.field_73011_w).getChunkProvider();
                TFFeature nearbyFeature = ((TFWorldChunkManager)this.field_70170_p.field_73011_w.field_76578_c).getFeatureAt(dx, dz, this.field_70170_p);
                if (nearbyFeature == TFFeature.lichTower) {
                    chunkProvider.setStructureConquered(dx, dy, dz, true);
                }
            }
        }
    }

    private void applyShieldCollisions(Entity collider) {
        List list = this.field_70170_p.func_72839_b(collider, collider.field_70121_D.func_72314_b((double)-0.2f, (double)-0.2f, (double)-0.2f));
        for (Entity collided : list) {
            if (!collided.func_70104_M()) continue;
            this.applyShieldCollision(collider, collided);
        }
    }

    protected void applyShieldCollision(Entity collider, Entity collided) {
        if (collided != this) {
            boolean attackSuccess;
            collided.func_70108_f(collider);
            if (collided instanceof EntityLivingBase && (attackSuccess = super.func_70652_k(collided))) {
                collided.field_70181_x += (double)0.4f;
                this.func_85030_a("mob.irongolem.throw", 1.0f, 1.0f);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getCurrentPhase() == Phase.SUMMON && this.getSummonsRemaining() == 0 && this.countMyMinions() <= 0) {
            this.setCurrentPhase(Phase.DROP);
        }
        if (this.getCurrentPhase() == Phase.DROP && this.successfulDrops >= this.maxDrops) {
            this.setCurrentPhase(Phase.BEAM);
        }
        if (this.getCurrentPhase() == Phase.BEAM && this.damageWhileBeaming >= 25) {
            this.setCurrentPhase(Phase.SUMMON);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float damage) {
        boolean result = super.func_70097_a(par1DamageSource, damage);
        if (result && this.getCurrentPhase() == Phase.BEAM) {
            this.damageWhileBeaming = (int)((float)this.damageWhileBeaming + damage);
        }
        return result;
    }

    private Vec3 getIceShieldPosition(int i) {
        return this.getIceShieldPosition(this.getIceShieldAngle(i), 1.0f);
    }

    private float getIceShieldAngle(int i) {
        return 60.0f * (float)i + (float)this.field_70173_aa * 5.0f;
    }

    public Vec3 getIceShieldPosition(float angle, float distance) {
        double var1 = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double var3 = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return Vec3.func_72443_a((double)(this.field_70165_t + var1), (double)(this.field_70163_u + this.getShieldYOffset()), (double)(this.field_70161_v + var3));
    }

    public double getShieldYOffset() {
        return 0.1f;
    }

    protected void func_70069_a(float par1) {
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(EntityDragonPart entitydragonpart, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.iceArray;
    }

    public boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int minY = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72337_e);
        int maxZ = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72334_f);
        boolean wasBlocked = false;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block block = this.field_70170_p.func_147439_a(dx, dy, dz);
                    if (block == Blocks.field_150350_a) continue;
                    int currentMeta = this.field_70170_p.func_72805_g(dx, dy, dz);
                    if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) {
                        this.field_70170_p.func_147465_d(dx, dy, dz, Blocks.field_150350_a, 0, 2);
                        this.field_70170_p.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)block) + (currentMeta << 12));
                        continue;
                    }
                    wasBlocked = true;
                }
            }
        }
        return wasBlocked;
    }

    @Override
    public boolean isBreathing() {
        return this.func_70096_w().func_75683_a(21) == 1;
    }

    @Override
    public void setBreathing(boolean flag) {
        this.func_70096_w().func_75692_b(21, (Object)((byte)(flag ? 1 : 0)));
    }

    public Phase getCurrentPhase() {
        return Phase.values()[this.func_70096_w().func_75683_a(22)];
    }

    public void setCurrentPhase(Phase currentPhase) {
        this.func_70096_w().func_75692_b(22, (Object)((byte)currentPhase.ordinal()));
        if (currentPhase == Phase.SUMMON) {
            this.setSummonsRemaining(6);
        }
        if (currentPhase == Phase.DROP) {
            this.successfulDrops = 0;
            this.maxDrops = 2 + this.field_70146_Z.nextInt(3);
        }
        if (currentPhase == Phase.BEAM) {
            this.damageWhileBeaming = 0;
        }
    }

    public int getSummonsRemaining() {
        return this.summonsRemaining;
    }

    public void setSummonsRemaining(int summonsRemaining) {
        this.summonsRemaining = summonsRemaining;
    }

    public void summonMinionAt(EntityLivingBase targetedEntity) {
        Vec3 minionSpot = this.findVecInLOSOf((Entity)targetedEntity);
        EntityTFIceCrystal minion = new EntityTFIceCrystal(this.field_70170_p);
        minion.func_70107_b(minionSpot.field_72450_a, minionSpot.field_72448_b, minionSpot.field_72449_c);
        this.field_70170_p.func_72838_d((Entity)minion);
        minion.func_70624_b(targetedEntity);
        minion.setToDieIn30Seconds();
        --this.summonsRemaining;
    }

    protected Vec3 findVecInLOSOf(Entity targetEntity) {
        if (targetEntity == null) {
            return null;
        }
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        int tries = 100;
        for (int i = 0; i < tries; ++i) {
            float halfWidth;
            AxisAlignedBB destBox;
            tx = targetEntity.field_70165_t + this.field_70146_Z.nextGaussian() * 16.0;
            ty = targetEntity.field_70163_u + this.field_70146_Z.nextGaussian() * 8.0;
            tz = targetEntity.field_70161_v + this.field_70146_Z.nextGaussian() * 16.0;
            boolean groundFlag = false;
            int bx = MathHelper.func_76128_c((double)tx);
            int by = MathHelper.func_76128_c((double)ty);
            int bz = MathHelper.func_76128_c((double)tz);
            while (!groundFlag && ty > 0.0) {
                Block whatsThere = this.field_70170_p.func_147439_a(bx, by - 1, bz);
                if (whatsThere == Blocks.field_150350_a || !whatsThere.func_149688_o().func_76220_a()) {
                    ty -= 1.0;
                    --by;
                    continue;
                }
                groundFlag = true;
            }
            if (by != 0 && this.canEntitySee(targetEntity, tx, ty, tz) && this.field_70170_p.func_72945_a((Entity)this, destBox = AxisAlignedBB.func_72330_a((double)(tx - (double)(halfWidth = this.field_70130_N / 2.0f)), (double)(ty - (double)this.field_70129_M + (double)this.field_70139_V), (double)(tz - (double)halfWidth), (double)(tx + (double)halfWidth), (double)(ty - (double)this.field_70129_M + (double)this.field_70139_V + (double)this.field_70131_O), (double)(tz + (double)halfWidth))).size() <= 0 && !this.field_70170_p.func_72953_d(destBox)) break;
        }
        if (tries == 99) {
            return null;
        }
        return Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v), Vec3.func_72443_a((double)dx, (double)dy, (double)dz)) == null;
    }

    public int countMyMinions() {
        List nearbyMinons = this.field_70170_p.func_72872_a(EntityTFIceCrystal.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(32.0, 16.0, 32.0));
        return nearbyMinons.size();
    }

    public void incrementSuccessfulDrops() {
        ++this.successfulDrops;
    }

    @Override
    public void doBreathAttack(Entity target) {
    }

    public static enum Phase {
        SUMMON,
        DROP,
        BEAM;

    }
}

