/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.tiles;

import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.common.tiles.TileInfusionMatrix;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.tiles.TileInfusionProvider;

public class TileAdvancedInfusionProvider
extends TileInfusionProvider
implements IAspectSource {
    private static final String NBT_MATRIX_X = "MatrixX";
    private static final String NBT_MATRIX_Y = "MatrixY";
    private static final String NBT_MATRIX_Z = "MatrixZ";
    public TileInfusionMatrix matrix = null;
    private Integer matrixX = null;
    private Integer matrixY = null;
    private Integer matrixZ = null;
    private int tickCounter = 0;

    @Override
    protected double getIdlePowerusage() {
        return 50.0;
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().AdvancedInfusionProvider.getStack();
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.matrix == null) {
            if (this.extractEssentiaFromNetwork(tag, amount, true) == amount) {
                this.doParticalFX(tag.getColor());
                return true;
            }
            this.orderSomeEssentia(tag);
        }
        return false;
    }

    public void searchMatrix() {
        if (this.matrix != null || this.field_145850_b == null) {
            return;
        }
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dy = -4; dy <= 4; ++dy) {
                for (int dz = -4; dz <= 4; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0 || !this.bindMatrix(x + dx, y + dy, z + dz)) continue;
                    this.matrixX = x + dx;
                    this.matrixY = y + dy;
                    this.matrixZ = z + dz;
                    return;
                }
            }
        }
    }

    public boolean bindMatrix(int x, int y, int z) {
        TileEntity tileEntity;
        if (this.field_145850_b != null && (tileEntity = this.field_145850_b.func_147438_o(x, y, z)) instanceof TileInfusionMatrix) {
            TileInfusionMatrix tim;
            this.matrix = tim = (TileInfusionMatrix)tileEntity;
            this.markForUpdate();
            this.saveChanges();
            return true;
        }
        return false;
    }

    public boolean bindMatrix() {
        return this.bindMatrix(this.matrixX, this.matrixY, this.matrixZ);
    }

    public void unbindMatrix() {
        this.matrix = null;
        this.matrixX = null;
        this.matrixY = null;
        this.matrixZ = null;
        this.markForUpdate();
        this.saveChanges();
    }

    public void grabAllAspects() {
        if (this.matrix.getAspects().size() != 0) {
            AspectList aspectList = this.matrix.getAspects().copy();
            for (Aspect aspect : aspectList.getAspects()) {
                int extractAmount;
                if (aspect == null) continue;
                int needAspectsAmount = aspectList.getAmount(aspect);
                if (needAspectsAmount != (extractAmount = this.extractEssentiaFromNetwork(aspect, needAspectsAmount, false))) {
                    this.orderSomeEssentia(aspect, needAspectsAmount - extractAmount);
                }
                if (extractAmount <= 0) continue;
                this.doParticalFX(aspect.getColor());
                this.matrix.getAspects().remove(aspect, extractAmount);
            }
        }
    }

    @Override
    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void onSaveNBT(NBTTagCompound data) {
        if (this.matrix != null) {
            data.func_74768_a(NBT_MATRIX_X, this.matrix.field_145851_c);
            data.func_74768_a(NBT_MATRIX_Y, this.matrix.field_145848_d);
            data.func_74768_a(NBT_MATRIX_Z, this.matrix.field_145849_e);
        }
        super.onSaveNBT(data);
    }

    @Override
    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void onLoadNBT(NBTTagCompound data) {
        if (data.func_74764_b(NBT_MATRIX_X) && data.func_74764_b(NBT_MATRIX_Y) && data.func_74764_b(NBT_MATRIX_Z)) {
            this.matrixX = data.func_74762_e(NBT_MATRIX_X);
            this.matrixY = data.func_74762_e(NBT_MATRIX_Y);
            this.matrixZ = data.func_74762_e(NBT_MATRIX_Z);
        }
        super.onLoadNBT(data);
    }

    @Override
    public void addWailaInformation(List<String> tooltip) {
        super.addWailaInformation(tooltip);
        if (this.matrix == null) {
            tooltip.add(ThEStrings.Tooltip_AdvancedInfusionProviderWorkingMode.getLocalized() + ":" + ThEStrings.Tooltip_AdvancedInfusionProviderNormalMode.getLocalized());
        } else {
            tooltip.add(ThEStrings.Tooltip_AdvancedInfusionProviderWorkingMode.getLocalized() + ":" + ThEStrings.Tooltip_AdvancedInfusionProviderAdvancedMode.getLocalized());
            tooltip.add(String.format(ThEStrings.Tooltip_AdvancedInfusionProviderBindTo.getLocalized(), this.matrixX, this.matrixY, this.matrixZ));
        }
    }

    @TileEvent(value=TileEventType.TICK)
    public void onTick() {
        if (++this.tickCounter % 20 == 0 && this.matrix == null && this.isActive) {
            if (this.matrixX == null || this.matrixY == null || this.matrixZ == null) {
                this.searchMatrix();
            } else if (!this.bindMatrix()) {
                this.unbindMatrix();
            }
            this.tickCounter = 0;
        }
        if (this.isActive && this.matrix != null) {
            this.grabAllAspects();
        }
    }
}

