/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.gtnewhorizons.gtnhintergalactic.gui.IG_UITextures;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import com.gtnewhorizons.modularui.api.drawable.FluidDrawable;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.RepeatingDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DropDownWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.SpaceProjectWorldSavedData;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.gui.TecTechUITextures;

public class TileEntityModuleManager
extends TileEntityModuleBase {
    protected static final int MODULE_VOLTAGE_TIER = 12;
    protected static final int MODULE_TIER = 1;
    protected static final int MINIMUM_MOTOR_TIER = 1;
    protected static final int PROJECT_WINDOW_ID = 200;
    private static final int POP_UP_WINDOW_ID = 201;
    private static final String LOCATON_UNSELECTED = "NONE";
    private String popupText = "";
    private ISpaceProject selectedProject;
    private String selectedProjectName;
    private ISpaceProject.ISP_Upgrade selectedUpgrade;
    private ISpaceBody selectedLocation;
    private ISpaceProject projectWorkingOn;
    private boolean upgradeMode = false;
    private boolean projectMode = true;
    private int locationIndex = -1;
    private List<ISpaceProject.ISP_Upgrade> upgradeFromProject;
    private static final IDrawable buttonUp = GTUITextures.BUTTON_STANDARD_TOGGLE.getSubArea(0.0f, 0.0f, 0.5f, 0.5f);
    private static final IDrawable buttonUpDisabled = GTUITextures.BUTTON_STANDARD_TOGGLE_DISABLED.getSubArea(0.0f, 0.0f, 0.5f, 0.5f);
    private static final IDrawable buttonDown = GTUITextures.BUTTON_STANDARD_TOGGLE.getSubArea(0.5f, 0.5f, 1.0f, 1.0f);
    private static final IDrawable buttonDownDisabled = GTUITextures.BUTTON_STANDARD_TOGGLE_DISABLED.getSubArea(0.5f, 0.5f, 1.0f, 1.0f);

    public TileEntityModuleManager(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 12, 1, 1);
    }

    public TileEntityModuleManager(String aName) {
        super(aName, 12, 1, 1);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.manager.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.manager.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT1")).addSeparator().beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic");
        return tt;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityModuleManager(this.mName);
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.spaceProjectFakeRecipes;
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        if (this.projectWorkingOn == null) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_project_selected");
        }
        if (GTValues.V[this.tTier] > this.getEUVar()) {
            return CheckRecipeResultRegistry.insufficientPower((long)GTValues.V[this.tTier]);
        }
        GTRecipe recipe = null;
        if (this.projectWorkingOn.isFinished() && this.projectWorkingOn.getUpgradeBeingBuilt() != null && !this.projectWorkingOn.getUpgradeBeingBuilt().isFinished()) {
            ISpaceProject.ISP_Upgrade upgrade = this.projectWorkingOn.getUpgradeBeingBuilt();
            recipe = new GTRecipe(false, upgrade.getItemsCostPerStage(), null, null, null, upgrade.getFluidsCostPerStage(), null, upgrade.getUpgradeBuildTime(), (int)upgrade.getVoltage(), 0);
        } else if (!this.projectWorkingOn.isFinished()) {
            recipe = new GTRecipe(false, this.projectWorkingOn.getItemsCostPerStage(), null, null, null, this.projectWorkingOn.getFluidsCostPerStage(), null, this.projectWorkingOn.getProjectBuildTime(), (int)this.projectWorkingOn.getProjectVoltage(), 0);
        }
        if (recipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (!recipe.isRecipeInputEqual(true, this.getStoredFluids().toArray(new FluidStack[0]), this.getStoredInputs().toArray(new ItemStack[0]))) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.mMaxProgresstime = this.projectWorkingOn.getProjectBuildTime();
        this.mEUt = recipe.mEUt;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public void outputAfterRecipe_EM() {
        super.outputAfterRecipe_EM();
        this.upgradeProjectOrUpgrade();
    }

    private void upgradeProjectOrUpgrade() {
        if (this.projectWorkingOn != null) {
            if (this.projectWorkingOn.isFinished() && this.projectWorkingOn.getUpgradeBeingBuilt() != null && !this.projectWorkingOn.getUpgradeBeingBuilt().isFinished()) {
                this.projectWorkingOn.getUpgradeBeingBuilt().goToNextStage();
            } else if (!this.projectWorkingOn.isFinished()) {
                this.projectWorkingOn.goToNextStage();
            }
            SpaceProjectWorldSavedData.INSTANCE.func_76185_a();
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("mLocation")) {
            this.selectedLocation = SpaceProjectManager.getLocation((String)aNBT.func_74779_i("mLocation"));
        }
        if (aNBT.func_74764_b("mWorkingProject")) {
            this.projectWorkingOn = SpaceProjectManager.getTeamProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceBody)SpaceProjectManager.getLocation((String)aNBT.func_74779_i("workingLocation")), (String)aNBT.func_74779_i("mWorkingProject"));
        }
        if (aNBT.func_74764_b("mProject")) {
            this.selectedProjectName = aNBT.func_74779_i("mProject");
            this.selectedProject = SpaceProjectManager.getTeamProjectOrCopy((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (String)this.selectedProjectName, (ISpaceBody)this.selectedLocation);
            this.upgradeFromProject = new ArrayList<ISpaceProject.ISP_Upgrade>(this.selectedProject.getAllUpgrades());
            this.selectedUpgrade = this.selectedProject.getUpgradeBeingBuilt();
        }
        this.projectMode = aNBT.func_74767_n("projectMode");
        this.upgradeMode = aNBT.func_74767_n("upgradeMode");
        this.locationIndex = aNBT.func_74762_e("locationIndex");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.selectedProject != null) {
            aNBT.func_74778_a("mProject", this.selectedProject.getProjectName());
        }
        if (this.selectedLocation != null) {
            aNBT.func_74778_a("mLocation", this.selectedLocation.getName());
        }
        if (this.projectWorkingOn != null) {
            aNBT.func_74778_a("mWorkingProject", this.projectWorkingOn.getProjectName());
            aNBT.func_74778_a("workingLocation", this.projectWorkingOn.getProjectLocation().getName());
        }
        aNBT.func_74757_a("projectMode", this.projectMode);
        aNBT.func_74757_a("upgradeMode", this.upgradeMode);
        aNBT.func_74768_a("locationIndex", this.locationIndex);
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.setShowNEI(false);
        buildContext.addSyncedWindow(200, player -> this.createProjectWindow());
        buildContext.addSyncedWindow(201, player -> this.createPopUp());
    }

    private ModularWindow createPopUp() {
        ModularWindow.Builder builder = ModularWindow.builder((int)300, (int)150);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(TextWidget.dynamicString(() -> this.popupText).setTextAlignment(Alignment.Center).setSize(280, 130).setPos(0, 20))).widget(ButtonWidget.closeWindowButton((boolean)true).setSize(20, 20).setPos(280, 0))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.popupText, val -> {
            this.popupText = val;
        }));
        return builder.build();
    }

    protected ButtonWidget createSafeVoidButton() {
        Widget button = ButtonWidget.openSyncedWindowButton((int)200).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_STANDARD_16x16);
            ret.add(IG_UITextures.OVERLAY_BUTTON_PROJECTS);
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, this.doesBindPlayerInventory() ? 132 : 156).setSize(16, 16);
        button.addTooltip(GCCoreUtil.translate((String)"ig.button.projects")).setTooltipShowUpDelay(5);
        return (ButtonWidget)button;
    }

    protected ModularWindow createProjectWindow() {
        DynamicPositionedColumn projects = new DynamicPositionedColumn();
        for (ISpaceProject project : SpaceProjectManager.getAllProjects()) {
            projects.widget(this.generateCustomButton(project));
        }
        Scrollable projectListScrollable = new Scrollable().setVerticalScroll();
        projectListScrollable.widget(projects.setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, SpaceProjectManager.getAllProjects().size() * 40)));
        MultiChildWidget activeProjectDetail = new MultiChildWidget();
        activeProjectDetail.addChild(this.generateCustomButton(StatCollector.func_74838_a((String)"ig.text.project"), (tClickData, tWidget) -> {
            this.projectMode = true;
            this.upgradeMode = false;
        }, () -> this.projectMode, () -> true, (screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.5, (double)parent.getSize().height * 0.05), (screenSize, window, parent) -> new Pos2d(0, 0))).addChild(this.generateCustomButton(StatCollector.func_74838_a((String)"ig.text.upgrades"), (tClickData, tWidget) -> {
            if (this.isUpgradeButtonClickable()) {
                this.projectMode = false;
                this.upgradeMode = true;
            }
        }, () -> this.upgradeMode, this::isUpgradeButtonClickable, (screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.5, (double)parent.getSize().height * 0.05), (screenSize, window, parent) -> new Pos2d((double)parent.getSize().width * 0.5, 0.0))).addChild(this.generateCustomButton(StatCollector.func_74838_a((String)"ig.text.start"), (clickData, widget) -> {
            if (widget.getContext().isClient()) {
                return;
            }
            if (this.selectedLocation != null && !this.selectedLocation.getName().equals(LOCATON_UNSELECTED)) {
                if (this.selectedProject != null) {
                    this.selectedProject.setProjectLocation(this.selectedLocation);
                    if (!this.selectedProject.isFinished()) {
                        if (this.selectedProject.meetsRequirements(this.getBaseMetaTileEntity().getOwnerUuid())) {
                            SpaceProjectManager.addTeamProject((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (ISpaceBody)this.selectedLocation, (String)this.selectedProject.getProjectName(), (ISpaceProject)this.selectedProject);
                            this.projectWorkingOn = this.selectedProject;
                            this.popupText = StatCollector.func_74838_a((String)"ig.text.started");
                            widget.getContext().openSyncedWindow(201);
                        } else {
                            this.popupText = StatCollector.func_74838_a((String)"ig.text.projectrequirements");
                            widget.getContext().openSyncedWindow(201);
                        }
                    } else if (this.selectedUpgrade != null) {
                        if (this.selectedUpgrade.meetsRequirements(this.getBaseMetaTileEntity().getOwnerUuid())) {
                            this.selectedProject.setCurrentUpgradeBeingBuilt(this.selectedUpgrade);
                            this.projectWorkingOn = this.selectedProject;
                            this.popupText = StatCollector.func_74838_a((String)"ig.text.started");
                            widget.getContext().openSyncedWindow(201);
                        } else {
                            this.popupText = StatCollector.func_74838_a((String)"ig.text.upgraderequirements");
                            widget.getContext().openSyncedWindow(201);
                        }
                    } else {
                        this.popupText = StatCollector.func_74838_a((String)"ig.text.finishedproject");
                        widget.getContext().openSyncedWindow(201);
                    }
                } else {
                    this.popupText = StatCollector.func_74838_a((String)"ig.text.noproject");
                    widget.getContext().openSyncedWindow(201);
                }
            } else {
                this.popupText = StatCollector.func_74838_a((String)"ig.text.nolocation");
                widget.getContext().openSyncedWindow(201);
            }
        }, () -> false, () -> true, (screenSize, window, parent) -> new Size((double)parent.getSize().width, (double)parent.getSize().height * 0.05), (screenSize, window, parent) -> new Pos2d(0.0, (double)parent.getSize().height * 0.95)));
        this.generateProjectDetails(activeProjectDetail);
        MultiChildWidget activeProjectDisplay = new MultiChildWidget().addChild(new RepeatingDrawable().setDrawable((IDrawable)IG_UITextures.BACKGROUND_SPACE_WITH_STARS).setDrawableSize(64, 64).asWidget().setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height))).addChild(new DrawableWidget().setDrawable(() -> this.selectedLocation != null && this.selectedLocation.getTexture() != null ? this.selectedLocation.getTexture().withRotationDegree(340.0f) : IG_UITextures.PICTURE_CELESTIAL_BODY_NEPTUNE.withRotationDegree(340.0f)).setEnabled(widget -> this.selectedLocation != null && !this.selectedLocation.getName().equals(LOCATON_UNSELECTED)).setPosProvider((screenSize, window, parent) -> new Pos2d(((double)parent.getSize().width - (double)parent.getSize().width * 0.5) / 2.0, ((double)parent.getSize().height - (double)parent.getSize().width * 0.5) / 2.0)).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.5, (double)parent.getSize().width * 0.5))).addChild(new DrawableWidget().setDrawable(() -> this.selectedProject != null && this.selectedProject.getTexture() != null ? this.selectedProject.getTexture() : IG_UITextures.PICTURE_CELESTIAL_BODY_PROTEUS).setPosProvider((screenSize, window, parent) -> new Pos2d((double)((float)parent.getSize().width / 2.0f), ((double)parent.getSize().height - (double)parent.getSize().width * 0.5) / 2.0)).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.2, (double)parent.getSize().width * 0.2)));
        return ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)ModularWindow.builderFullScreen().setDraggable(false).setBackground(new IDrawable[]{TecTechUITextures.BACKGROUND_SCREEN_BLUE}).widget(projectListScrollable.setPos(20, 20).setSizeProvider((screenSize, window, parent) -> new Size((double)screenSize.width * 0.2, (double)(screenSize.height - 70))))).widget(activeProjectDetail.setPosProvider((screenSize, window, parent) -> new Pos2d((double)screenSize.width * 0.2 + 40.0, 20.0)).setSizeProvider((screenSize, window, parent) -> new Size((double)screenSize.width * 0.2, (double)(screenSize.height - 40))))).widget(activeProjectDisplay.setSizeProvider((screenSize, window, parent) -> new Size(screenSize.width / 2 - 20, screenSize.height - 40)).setPosProvider((screenSize, window, parent) -> new Pos2d(screenSize.width / 2, 20)))).widget(new DrawableWidget().setDrawable((IDrawable)IG_UITextures.PICTURE_ELEVATOR_LOGO_DARK).setSize(36, 36).setPosProvider((screenSize, mainWindow, parent) -> new Pos2d(screenSize.width - 40, screenSize.height - 40)))).widget(new DropDownWidget().addDropDownItemsSimple(new ArrayList(SpaceProjectManager.getLocationNames()), (buttonWidget, index, label, setSelected) -> buttonWidget.setOnClick((clickData, widget) -> {
            this.selectedLocation = SpaceProjectManager.getLocation((String)label);
            this.locationIndex = index;
            this.projectMode = true;
            this.upgradeMode = false;
            if (!widget.getContext().isClient()) {
                this.selectedProject = SpaceProjectManager.getTeamProjectOrCopy((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (String)(this.selectedProject != null ? this.selectedProject.getProjectName() : this.selectedProjectName), (ISpaceBody)this.selectedLocation);
            }
            setSelected.run();
        }), true).setDirection(DropDownWidget.Direction.UP).setTextUnselected(LOCATON_UNSELECTED).setSelected(this.locationIndex).setPos(20, 259).setSize(128, 20).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.selectedLocation != null ? this.selectedLocation.getName() : "", val -> {
            this.selectedLocation = SpaceProjectManager.getLocation((String)val);
            if (this.selectedProject != null) {
                this.projectMode = true;
                this.upgradeMode = false;
            }
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.selectedProject != null ? this.selectedProject.getProjectName() : "", val -> {
            this.selectedProjectName = val;
            this.selectedProject = SpaceProjectManager.getProject((String)val);
            if (this.selectedProject != null) {
                this.upgradeFromProject = new ArrayList<ISpaceProject.ISP_Upgrade>(this.selectedProject.getAllUpgrades());
                this.projectMode = true;
                this.upgradeMode = false;
            }
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.selectedUpgrade != null ? this.selectedUpgrade.getUpgradeName() : "", val -> {
            if (this.selectedProject != null) {
                this.selectedUpgrade = this.selectedProject.getUpgrade(val);
                this.selectedProject.setCurrentUpgradeBeingBuilt(this.selectedUpgrade);
            }
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.selectedProject != null && this.selectedProject.getUpgradeBeingBuilt() != null ? this.selectedProject.getUpgradeBeingBuilt().getUpgradeName() : "", val -> {
            if (this.selectedProject != null) {
                this.selectedProject.setCurrentUpgradeBeingBuilt(this.selectedProject.getUpgrade(val));
            }
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.selectedProject != null ? this.selectedProject.getCurrentStage() : 0, val -> {
            if (this.selectedProject != null) {
                this.selectedProject.setProjectCurrentStage(val.intValue());
            }
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> {
            if (this.selectedProject != null && this.selectedUpgrade != null) {
                ISpaceProject.ISP_Upgrade upgradeFromProject = this.selectedProject.getUpgradeBeingBuilt();
                if (upgradeFromProject != null) {
                    return upgradeFromProject.getCurrentStage();
                }
                upgradeFromProject = this.selectedProject.getUpgrade(this.selectedUpgrade.getUpgradeName());
                if (upgradeFromProject != null) {
                    upgradeFromProject.getCurrentStage();
                } else if (this.selectedProject.hasUpgrade(this.selectedUpgrade.getUpgradeName())) {
                    return this.selectedProject.getTotalStages();
                }
            } else if (this.selectedUpgrade != null) {
                return this.selectedUpgrade.getCurrentStage();
            }
            return 0;
        }, val -> {
            if (this.selectedProject != null && this.selectedProject.getUpgradeBeingBuilt() != null) {
                this.selectedProject.getUpgradeBeingBuilt().setUpgradeCurrentStage(val.intValue());
            }
            if (this.selectedUpgrade != null) {
                this.selectedUpgrade.setUpgradeCurrentStage(val.intValue());
            }
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.projectMode, val -> {
            this.projectMode = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.upgradeMode, val -> {
            this.upgradeMode = val;
        }))).build();
    }

    private void generateProjectDetails(MultiChildWidget projectDetails) {
        projectDetails.addChild(TextWidget.dynamicString(() -> this.selectedProject != null ? this.selectedProject.getLocalizedName() : "").setScale(2.0f).setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.Center).setPosProvider((screenSize, window, parent) -> new Pos2d(0.0, (double)parent.getSize().height * 0.05)).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width, (double)parent.getSize().height * 0.15))).addChild(TextWidget.dynamicString(() -> this.selectedProject != null ? StatCollector.func_74838_a((String)(this.selectedProject.getUnlocalizedName() + ".description")) : "").setDefaultColor(EnumChatFormatting.WHITE).setPosProvider((screenSize, window, parent) -> new Pos2d(0.0, (double)parent.getSize().height * 0.2)).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width, (double)parent.getSize().height * 0.4)).setEnabled(widget -> this.projectMode));
        this.generateProjectCosts(projectDetails);
        this.generateUpgradeCost(projectDetails);
        this.generateUpgrades(projectDetails);
    }

    private void generateProjectCosts(MultiChildWidget projectDetails) {
        int index;
        DynamicPositionedColumn activeProjectItemsAndFluids = new DynamicPositionedColumn();
        DynamicPositionedColumn activeProjectCosts = new DynamicPositionedColumn();
        int i = 0;
        while (i < 12) {
            index = i++;
            activeProjectItemsAndFluids.addChild(new ItemDrawable(() -> this.selectedProject != null ? this.selectedProject.getItemCostPerStage(index) : null).asWidget().dynamicTooltip(() -> {
                ArrayList<String> tTooltip = new ArrayList<String>();
                if (this.selectedProject != null) {
                    tTooltip.add(this.selectedProject.getItemCostPerStage(index) != null ? this.selectedProject.getItemCostPerStage(index).func_82833_r() : "");
                } else {
                    tTooltip.add("");
                }
                return tTooltip;
            }).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().height / 16, parent.getSize().height / 16)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setEnabled(widget -> this.selectedProject != null && this.selectedProject.getItemCostPerStage(index) != null));
        }
        i = 0;
        while (i < 4) {
            index = i++;
            activeProjectItemsAndFluids.addChild(new FluidDrawable().setFluid(() -> this.selectedProject != null ? this.selectedProject.getFluidCostPerStage(index) : null).asWidget().dynamicTooltip(() -> Collections.singletonList(this.selectedProject != null ? this.selectedProject.getFluidCostPerStage(index).getLocalizedName() : "")).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().height / 16, parent.getSize().height / 16)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setEnabled(widget -> this.selectedProject != null && this.selectedProject.getFluidCostPerStage(index) != null));
        }
        i = 0;
        while (i < 12) {
            index = i++;
            activeProjectCosts.addChild(TextWidget.dynamicString(() -> (this.selectedProject != null && this.selectedProject.getItemCostPerStage(index) != null ? Integer.valueOf(this.selectedProject.getItemCostPerStage((int)index).field_77994_a) : "") + " Per Stage (" + (this.selectedProject != null && this.selectedProject.getCurrentItemProgress(index) != null ? Integer.valueOf(this.selectedProject.getCurrentItemProgress((int)index).field_77994_a) : "") + "/" + (this.selectedProject != null && this.selectedProject.getTotalItemCost(index) != null ? Integer.valueOf(this.selectedProject.getTotalItemCost((int)index).field_77994_a) : "") + ")").setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.CenterRight).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height / 16)).setEnabled(widget -> this.selectedProject != null && this.selectedProject.getItemCostPerStage(index) != null));
        }
        i = 0;
        while (i < 4) {
            index = i++;
            activeProjectCosts.addChild(TextWidget.dynamicString(() -> (this.selectedProject != null && this.selectedProject.getCurrentFluidProgress(index) != null ? Integer.valueOf(this.selectedProject.getFluidCostPerStage((int)index).amount) : "") + " Per Stage (" + (this.selectedProject != null && this.selectedProject.getCurrentFluidProgress(index) != null ? Integer.valueOf(this.selectedProject.getCurrentFluidProgress((int)index).amount) : "") + "/" + (this.selectedProject != null && this.selectedProject.getTotalFluidCost(index) != null ? Integer.valueOf(this.selectedProject.getTotalFluidCost((int)index).amount) : "") + ")").setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.CenterRight).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height / 16)).setEnabled(widget -> this.selectedProject != null && this.selectedProject.getFluidCostPerStage(index) != null));
        }
        projectDetails.addChild(((Scrollable)((Scrollable)new Scrollable().setVerticalScroll().widget(activeProjectCosts.setPos(0, 0).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.85, (double)parent.getSize().height * 0.2 * 16.0)))).widget(activeProjectItemsAndFluids.setPosProvider((screenSize, window, parent) -> new Pos2d((double)parent.getSize().width * 0.85, (double)(-((Scrollable)parent).getVerticalScrollOffset()))).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.15, (double)parent.getSize().height * 0.2 * 16.0)))).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width, (double)parent.getSize().height * 0.3)).setPosProvider((screenSize, window, parent) -> new Pos2d(0.0, (double)parent.getSize().height * 0.6)).setEnabled(widget -> this.projectMode));
    }

    private void generateUpgrades(MultiChildWidget projectDetails) {
        DynamicPositionedColumn activeProjectUpgrades = new DynamicPositionedColumn();
        int i = 0;
        while (i < 12) {
            int index = i++;
            activeProjectUpgrades.addChild(this.generateCustomButton(() -> this.upgradeFromProject != null && this.upgradeFromProject.size() > index ? this.upgradeFromProject.get(index) : null));
        }
        projectDetails.addChild(((Scrollable)new Scrollable().setVerticalScroll().widget(activeProjectUpgrades.setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 300)))).setPosProvider((screenSize, window, parent) -> new Pos2d(0.0, (double)parent.getSize().height * 0.2)).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.5, (double)parent.getSize().height * 0.4)).setEnabled(widget -> this.upgradeMode)).addChild(((Scrollable)new Scrollable().setVerticalScroll().widget(TextWidget.dynamicString(() -> this.selectedUpgrade != null ? StatCollector.func_74838_a((String)(this.selectedUpgrade.getUnlocalizedName() + ".description")) : "").setDefaultColor(EnumChatFormatting.WHITE).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 200)))).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width, (double)parent.getSize().height * 0.4)).setPosProvider((screenSize, window, parent) -> new Pos2d((double)parent.getSize().width * 0.5, (double)parent.getSize().height * 0.2)).setEnabled(widget -> this.upgradeMode));
    }

    private void generateUpgradeCost(MultiChildWidget projectDetails) {
        int index;
        DynamicPositionedColumn activeUpgradeItemsAndFluids = new DynamicPositionedColumn();
        DynamicPositionedColumn activeUpgradeCosts = new DynamicPositionedColumn();
        int i = 0;
        while (i < RecipeMaps.spaceProjectFakeRecipes.getFrontend().getUIProperties().maxItemInputs) {
            index = i++;
            activeUpgradeItemsAndFluids.addChild(new ItemDrawable(() -> this.selectedUpgrade != null ? this.selectedUpgrade.getItemCostPerStage(index) : null).asWidget().dynamicTooltip(() -> {
                ArrayList<String> tTooltip = new ArrayList<String>();
                if (this.selectedUpgrade != null) {
                    tTooltip.add(this.selectedUpgrade.getItemCostPerStage(index) != null ? this.selectedUpgrade.getItemCostPerStage(index).func_82833_r() : "");
                } else {
                    tTooltip.add("");
                }
                return tTooltip;
            }).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().height / 16, parent.getSize().height / 16)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setEnabled(widget -> this.selectedUpgrade != null && this.selectedUpgrade.getItemCostPerStage(index) != null));
        }
        i = 0;
        while (i < RecipeMaps.spaceProjectFakeRecipes.getFrontend().getUIProperties().maxFluidInputs) {
            index = i++;
            activeUpgradeItemsAndFluids.addChild(new FluidDrawable().setFluid(() -> this.selectedUpgrade != null ? this.selectedUpgrade.getFluidCostPerStage(index) : null).asWidget().dynamicTooltip(() -> Collections.singletonList(this.selectedUpgrade != null ? this.selectedUpgrade.getFluidCostPerStage(index).getLocalizedName() : "")).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().height / 16, parent.getSize().height / 16)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setEnabled(widget -> this.selectedUpgrade != null && this.selectedUpgrade.getFluidCostPerStage(index) != null));
        }
        i = 0;
        while (i < RecipeMaps.spaceProjectFakeRecipes.getFrontend().getUIProperties().maxItemInputs) {
            index = i++;
            activeUpgradeCosts.addChild(TextWidget.dynamicString(() -> (this.selectedUpgrade != null && this.selectedUpgrade.getItemCostPerStage(index) != null ? Integer.valueOf(this.selectedUpgrade.getItemCostPerStage((int)index).field_77994_a) : "") + " Per Stage (" + (this.selectedUpgrade != null && this.selectedUpgrade.getCurrentItemProgress(index) != null ? Integer.valueOf(this.selectedUpgrade.getCurrentItemProgress((int)index).field_77994_a) : "") + "/" + (this.selectedUpgrade != null && this.selectedUpgrade.getTotalItemCost(index) != null ? Integer.valueOf(this.selectedUpgrade.getTotalItemCost((int)index).field_77994_a) : "") + ")").setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.CenterRight).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height / 16)).setEnabled(widget -> this.selectedUpgrade != null && this.selectedUpgrade.getItemCostPerStage(index) != null));
        }
        i = 0;
        while (i < 4) {
            index = i++;
            activeUpgradeCosts.addChild(TextWidget.dynamicString(() -> (this.selectedUpgrade != null && this.selectedUpgrade.getCurrentFluidProgress(index) != null ? Integer.valueOf(this.selectedUpgrade.getFluidCostPerStage((int)index).amount) : "") + " Per Stage (" + (this.selectedUpgrade != null && this.selectedUpgrade.getCurrentFluidProgress(index) != null ? Integer.valueOf(this.selectedUpgrade.getCurrentFluidProgress((int)index).amount) : "") + "/" + (this.selectedUpgrade != null && this.selectedUpgrade.getTotalFluidCost(index) != null ? Integer.valueOf(this.selectedUpgrade.getTotalFluidCost((int)index).amount) : "") + ")").setDefaultColor(EnumChatFormatting.WHITE).setTextAlignment(Alignment.CenterRight).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height / 16)).setEnabled(widget -> this.selectedUpgrade != null && this.selectedUpgrade.getFluidCostPerStage(index) != null));
        }
        projectDetails.addChild(((Scrollable)((Scrollable)new Scrollable().setVerticalScroll().widget(activeUpgradeCosts.setPos(0, 0).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.85, (double)parent.getSize().height * 0.2 * 16.0)))).widget(activeUpgradeItemsAndFluids.setPosProvider((screenSize, window, parent) -> new Pos2d((double)parent.getSize().width * 0.85, 0.0)).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width * 0.15, (double)parent.getSize().height * 0.2 * 16.0)))).setSizeProvider((screenSize, window, parent) -> new Size((double)parent.getSize().width, (double)parent.getSize().height * 0.3)).setPosProvider((screenSize, window, parent) -> new Pos2d(0.0, (double)parent.getSize().height * 0.6)).setEnabled(widget -> this.upgradeMode));
    }

    private Widget generateCustomButton(ISpaceProject project) {
        MultiChildWidget customButton = new MultiChildWidget();
        ButtonWidget button = new ButtonWidget();
        customButton.addChild(button.setOnClick((clickData, widget) -> {
            this.projectMode = true;
            this.upgradeMode = false;
            this.selectedProject = widget.getContext().isClient() ? SpaceProjectManager.getProject((String)widget.getInternalName()) : SpaceProjectManager.getTeamProjectOrCopy((UUID)this.getBaseMetaTileEntity().getOwnerUuid(), (String)widget.getInternalName(), (ISpaceBody)this.selectedLocation);
            if (this.selectedProject != null) {
                this.upgradeFromProject = new ArrayList<ISpaceProject.ISP_Upgrade>(this.selectedProject.getAllUpgrades());
            }
        }).setBackground(() -> {
            if (this.selectedProject != null && this.selectedProject.getProjectName().equals(button.getInternalName())) {
                return new IDrawable[]{buttonDown};
            }
            return new IDrawable[]{buttonUp};
        }).setInternalName(project.getProjectName()).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 40))).addChild(new TextWidget(project.getLocalizedName()).setTextAlignment(Alignment.Center).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 40)));
        return customButton.setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 45));
    }

    private Widget generateCustomButton(Supplier<ISpaceProject.ISP_Upgrade> supplier) {
        MultiChildWidget customButton = new MultiChildWidget();
        ButtonWidget button = new ButtonWidget();
        customButton.addChild(button.setOnClick((clickData, widget) -> {
            if (this.selectedProject.getUpgradeBeingBuilt() != null && this.selectedProject.getUpgradeBeingBuilt().getUpgradeName().equals(widget.getInternalName())) {
                this.selectedUpgrade = this.selectedProject.getUpgradeBeingBuilt();
            } else {
                this.selectedUpgrade = this.selectedProject.getUpgrade(widget.getInternalName());
                if (this.selectedProject.hasUpgrade(widget.getInternalName())) {
                    this.selectedUpgrade.setUpgradeCurrentStage(this.selectedUpgrade.getTotalStages());
                }
            }
        }).setBackground(() -> {
            if (this.selectedUpgrade != null && this.selectedUpgrade.getUpgradeName().equals(button.getInternalName())) {
                return new IDrawable[]{buttonDown};
            }
            return new IDrawable[]{buttonUp};
        }).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 35)).setInternalName(() -> supplier.get() != null ? ((ISpaceProject.ISP_Upgrade)supplier.get()).getUpgradeName() : "")).addChild(TextWidget.dynamicString(() -> supplier.get() != null ? ((ISpaceProject.ISP_Upgrade)supplier.get()).getLocalizedName() : "").setTextAlignment(Alignment.Center).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 35)));
        return customButton.setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, 40)).setEnabled(widget -> !button.getInternalName().equals(""));
    }

    private Widget generateCustomButton(String text, BiConsumer<Widget.ClickData, Widget> consumer, Supplier<Boolean> isToggledSupplier, Supplier<Boolean> isClickableSupplier, Widget.SizeProvider buttonSize, Widget.PosProvider buttonPos) {
        MultiChildWidget customButton = new MultiChildWidget();
        customButton.addChild(new ButtonWidget().setOnClick(consumer).setBackground(() -> {
            if (!((Boolean)isClickableSupplier.get()).booleanValue()) {
                if (((Boolean)isToggledSupplier.get()).booleanValue()) {
                    return new IDrawable[]{buttonDownDisabled};
                }
                return new IDrawable[]{buttonUpDisabled};
            }
            if (((Boolean)isToggledSupplier.get()).booleanValue()) {
                return new IDrawable[]{buttonDown};
            }
            return new IDrawable[]{buttonUp};
        }).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height))).addChild(new TextWidget(text).setTextAlignment(Alignment.Center).setSizeProvider((screenSize, window, parent) -> new Size(parent.getSize().width, parent.getSize().height)));
        return customButton.setSizeProvider(buttonSize).setPosProvider(buttonPos);
    }

    private boolean isUpgradeButtonClickable() {
        if (this.projectMode) {
            return this.upgradeFromProject != null && this.upgradeFromProject.size() > 0 && this.selectedProject != null && this.selectedProject.isFinished() && this.selectedProject.getAllUpgrades().size() > 0;
        }
        return true;
    }
}

