/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.selection;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.Expression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.ManyStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.Statement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.Root;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.traversal.ASTVisitor;
import java.util.List;
import java.util.stream.Stream;

public class SelectionStatement
extends ManyStatement {
    protected ChildNodeList<Expression> conditions;

    public SelectionStatement(Stream<Expression> conditions, Stream<Statement> statements) {
        super(statements);
        this.conditions = ChildNodeList.collect(conditions, this);
    }

    public SelectionStatement(Expression condition, Statement statement) {
        this(Stream.of(condition), Stream.of(statement));
    }

    public SelectionStatement(Expression condition, Statement ifTrue, Statement ifFalse) {
        this(Stream.of(condition, null), Stream.of(ifTrue, ifFalse));
    }

    public SelectionStatement(Expression firstCondition, Statement firstStatement, Expression secondCondition, Statement secondStatement, Statement elseStatement) {
        this(Stream.of(firstCondition, secondCondition, null), Stream.of(firstStatement, secondStatement, elseStatement));
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }

    @Override
    public Statement.StatementType getStatementType() {
        return Statement.StatementType.SELECTION;
    }

    @Override
    public <R> R statementAccept(ASTVisitor<R> visitor) {
        return visitor.visitSelectionStatement(this);
    }

    @Override
    public void enterNode(ASTListener listener) {
        super.enterNode(listener);
        listener.enterSelectionStatement(this);
    }

    @Override
    public void exitNode(ASTListener listener) {
        super.exitNode(listener);
        listener.exitSelectionStatement(this);
    }

    @Override
    public SelectionStatement clone() {
        return new SelectionStatement(SelectionStatement.clone(this.conditions), SelectionStatement.clone(this.statements));
    }

    @Override
    public SelectionStatement cloneInto(Root root) {
        return (SelectionStatement)super.cloneInto(root);
    }

    @Override
    public SelectionStatement cloneSeparate() {
        return (SelectionStatement)super.cloneSeparate();
    }
}

