/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.print;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.Identifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.IterationConditionInitializer;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.VersionStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.FunctionDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.FunctionParameter;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.InterfaceBlockDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.PrecisionDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.declaration.VariableDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.ConditionExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.Expression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.SequenceExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.AdditionAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.AdditionExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.ArrayAccessExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.AssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseAndAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseAndExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseOrAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseOrExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseXorAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseXorExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BooleanAndExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BooleanOrExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.BooleanXorExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.DivisionAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.DivisionExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.EqualityExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.GreaterThanEqualExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.GreaterThanExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.InequalityExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.LeftShiftAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.LeftShiftExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.LessThanEqualExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.LessThanExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.ModuloAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.ModuloExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.MultiplicationAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.MultiplicationExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.RightShiftAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.RightShiftExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.SubtractionAssignmentExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.binary.SubtractionExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.BitwiseNotExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.BooleanNotExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.DecrementPostfixExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.DecrementPrefixExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.FunctionCallExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.GroupingExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.IdentityExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.IncrementPostfixExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.IncrementPrefixExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.LengthAccessExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.MemberAccessExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.expression.unary.NegationExpression;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.EmptyDeclaration;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.ExtensionStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.LayoutDefaults;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.external_declaration.PragmaStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.CompoundStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.EmptyStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.Statement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.loop.DoWhileLoopStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.loop.ForLoopStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.loop.WhileLoopStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.selection.SelectionStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.selection.SwitchStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.BreakStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.CaseLabelStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.CaseStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.ContinueStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.DefaultStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.DemoteStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.DiscardStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.ExpressionStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.statement.terminal.ReturnStatement;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.FullySpecifiedType;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.initializer.NestedInitializer;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.InterpolationQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.InvariantQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.NamedLayoutQualifierPart;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.PreciseQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.PrecisionQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.SharedLayoutQualifierPart;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.ArraySpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinFixedTypeSpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.FunctionPrototype;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.struct.StructBody;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.struct.StructDeclarator;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.struct.StructMember;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.type.struct.StructSpecifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.print.ASTPrinterBase;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.print.PrintType;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.print.TokenProcessor;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.print.token.EOFToken;
import java.util.ArrayDeque;
import java.util.Deque;

public class ASTPrinter
extends ASTPrinterBase {
    private final Deque<Expression> precedenceWrapped = new ArrayDeque<Expression>();

    public ASTPrinter(TokenProcessor tokenProcessor) {
        super(tokenProcessor);
    }

    public static String printAST(TokenProcessor tokenProcessor, ASTNode node) {
        ASTPrinter printer = new ASTPrinter(tokenProcessor);
        printer.startVisit(node);
        printer.finalizePrinting();
        return printer.generateString();
    }

    public static String print(PrintType type, ASTNode node) {
        return ASTPrinter.printAST(type.getTokenProcessor(), node);
    }

    public static String printSimple(ASTNode node) {
        return ASTPrinter.print(PrintType.SIMPLE, node);
    }

    public static String printIndented(ASTNode node) {
        return ASTPrinter.print(PrintType.INDENTED, node);
    }

    public static String printCompact(ASTNode node) {
        return ASTPrinter.print(PrintType.COMPACT, node);
    }

    public static String printIndentedAnnotated(ASTNode node) {
        return ASTPrinter.print(PrintType.INDENTED_ANNOTATED, node);
    }

    @Override
    public Void startVisit(ASTNode node) {
        this.precedenceWrapped.clear();
        return (Void)super.startVisit(node);
    }

    @Override
    public Void visitTranslationUnit(TranslationUnit node) {
        this.visitSafe(node.getVersionStatement());
        this.emitLiteralSafe(node.outputOptions.getPrintHeader());
        this.visitChildren(node);
        this.emitToken(new EOFToken());
        return null;
    }

    @Override
    public Void visitVersionStatement(VersionStatement node) {
        this.emitType(256, 264);
        this.emitExtendableSpace();
        this.emitType(node.version.tokenType);
        if (node.profile != null) {
            this.emitExtendableSpace();
            this.emitType(node.profile.tokenType);
        }
        this.emitExactNewline();
        return null;
    }

    @Override
    public Void visitFunctionDefinition(FunctionDefinition node) {
        this.visit(node.getFunctionPrototype());
        this.emitBreakableSpace();
        this.visit(node.getBody());
        return null;
    }

    @Override
    public Void visitEmptyDeclaration(EmptyDeclaration node) {
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitPragmaStatement(PragmaStatement node) {
        this.emitType(256, 265);
        this.emitExtendableSpace();
        if (node.stdGL) {
            this.emitType(279);
            this.emitExtendableSpace();
        }
        if (node.type == PragmaStatement.PragmaType.CUSTOM) {
            this.emitLiteral(node.customName);
        } else {
            this.emitType(node.type.tokenType, 277, node.state.tokenType, 278);
        }
        this.emitExactNewline();
        return null;
    }

    @Override
    public Void visitExtensionStatement(ExtensionStatement node) {
        this.emitType(256, 263);
        this.emitExtendableSpace();
        this.emitLiteral(node.name);
        if (node.behavior != null) {
            this.emitType(276);
            this.emitExtendableSpace();
            this.emitType(node.behavior.tokenType);
        }
        this.emitExactNewline();
        return null;
    }

    @Override
    public void exitLayoutDefaults(LayoutDefaults node) {
        this.emitType(node.mode.tokenType);
        this.emitBreakableSpace();
        this.emitStatementEnd();
    }

    @Override
    public void enterExpression(Expression node) {
        ASTNode aSTNode = node.getParent();
        if (aSTNode instanceof Expression) {
            ArrayAccessExpression access;
            Expression expression;
            Expression parent = (Expression)aSTNode;
            Expression.ExpressionType parentType = parent.getExpressionType();
            Expression.ExpressionType ownType = node.getExpressionType();
            if (!(parentType == Expression.ExpressionType.GROUPING || ownType == Expression.ExpressionType.GROUPING || parentType.precedence >= ownType.precedence || parentType.operandStructure != Expression.ExpressionType.OperandStructure.UNARY && parentType.operandStructure != Expression.ExpressionType.OperandStructure.BINARY && parentType.operandStructure != Expression.ExpressionType.OperandStructure.TERNARY && parentType != Expression.ExpressionType.SEQUENCE || (expression = parent) instanceof ArrayAccessExpression && (access = (ArrayAccessExpression)expression).getRight() == node)) {
                this.emitType(277);
                this.precedenceWrapped.add(node);
            }
        }
    }

    @Override
    public void exitExpression(Expression node) {
        if (this.precedenceWrapped.peekLast() == node) {
            this.emitType(278);
            this.precedenceWrapped.removeLast();
        }
    }

    @Override
    public void enterBitwiseNotExpression(BitwiseNotExpression node) {
        this.emitType(243);
    }

    @Override
    public void enterBooleanNotExpression(BooleanNotExpression node) {
        this.emitType(242);
    }

    @Override
    public void enterDecrementPrefixExpression(DecrementPrefixExpression node) {
        this.emitType(241, 241);
    }

    @Override
    public Void visitGroupingExpression(GroupingExpression node) {
        Expression operand = node.getOperand();
        if (operand.getExpressionType() == Expression.ExpressionType.GROUPING) {
            this.visit(operand);
        } else {
            this.emitType(231);
            this.visit(operand);
            this.emitType(232);
        }
        return null;
    }

    @Override
    public void enterIncrementPrefixExpression(IncrementPrefixExpression node) {
        this.emitType(240, 240);
    }

    @Override
    public void enterNegationExpression(NegationExpression node) {
        this.emitType(241);
    }

    @Override
    public void enterIdentityExpression(IdentityExpression node) {
        this.emitType(240);
    }

    @Override
    public void exitDecrementPostfixExpression(DecrementPostfixExpression node) {
        this.emitType(241, 241);
    }

    @Override
    public void exitIncrementPostfixExpression(IncrementPostfixExpression node) {
        this.emitType(240, 240);
    }

    @Override
    public Void visitFunctionCallExpression(FunctionCallExpression node) {
        this.visit(node.getReference());
        this.emitType(231);
        this.visitCommaSpaced(node.getParameters());
        this.emitType(232);
        return null;
    }

    @Override
    public Void visitMemberAccessExpression(MemberAccessExpression node) {
        this.visit(node.getOperand());
        this.emitType(239);
        this.visit(node.getMember());
        return null;
    }

    @Override
    public void exitLengthAccessExpression(LengthAccessExpression node) {
        this.emitType(22, 231, 232);
    }

    @Override
    public Void visitConditionExpression(ConditionExpression node) {
        this.visit(node.getCondition());
        this.emitBreakableSpace();
        this.emitType(252);
        this.emitExtendableSpace();
        this.visit(node.getTrueExpression());
        this.emitBreakableSpace();
        this.emitType(1);
        this.emitExtendableSpace();
        this.visit(node.getFalseExpression());
        return null;
    }

    @Override
    public Void visitSequenceExpression(SequenceExpression node) {
        this.visitCommaSpaced(node.getExpressions());
        return null;
    }

    @Override
    public Void visitLiteralExpression(LiteralExpression node) {
        block0 : switch (node.getNumberType()) {
            case BOOLEAN: {
                this.emitLiteral(node.getBoolean() ? "true" : "false");
                break;
            }
            case SIGNED_INTEGER: 
            case UNSIGNED_INTEGER: {
                int radix = node.getIntegerRadix();
                String intString = Long.toString(node.getInteger(), radix);
                if (radix == 16) {
                    intString = "0x" + intString;
                } else if (radix == 8) {
                    intString = "0" + intString;
                }
                switch (node.getType()) {
                    case INT16: {
                        this.emitLiteral(intString + "s");
                        break block0;
                    }
                    case UINT16: {
                        this.emitLiteral(intString + "us");
                        break block0;
                    }
                    case INT32: {
                        this.emitLiteral(intString);
                        break block0;
                    }
                    case UINT32: {
                        this.emitLiteral(intString + "u");
                        break block0;
                    }
                    case INT64: {
                        this.emitLiteral(intString + "l");
                        break block0;
                    }
                    case UINT64: {
                        this.emitLiteral(intString + "ul");
                        break block0;
                    }
                }
                throw new IllegalStateException("Unexpected int type: " + node.getType());
            }
            case FLOATING_POINT: {
                switch (node.getType()) {
                    case FLOAT16: {
                        this.emitLiteral(Double.toString(node.getFloating()) + "hf");
                        break block0;
                    }
                    case FLOAT32: {
                        this.emitLiteral(Double.toString(node.getFloating()) + "f");
                        break block0;
                    }
                    case FLOAT64: {
                        this.emitLiteral(Double.toString(node.getFloating()) + "lf");
                        break block0;
                    }
                }
                throw new IllegalStateException("Unexpected float type: " + node.getType());
            }
        }
        return null;
    }

    @Override
    public Void visitArrayAccessExpression(ArrayAccessExpression node) {
        this.visit(node.getLeft());
        this.emitType(236);
        this.visit(node.getRight());
        this.emitType(237);
        return null;
    }

    @Override
    public Void visitMultiplicationExpression(MultiplicationExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(244);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitDivisionExpression(DivisionExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(245);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitModuloExpression(ModuloExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(246);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitAdditionExpression(AdditionExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(240);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitSubtractionExpression(SubtractionExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(241);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitLeftShiftExpression(LeftShiftExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(212);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitRightShiftExpression(RightShiftExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(213);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitLessThanExpression(LessThanExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(247);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitGreaterThanExpression(GreaterThanExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(248);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitLessThanEqualExpression(LessThanEqualExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(214);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitGreaterThanEqualExpression(GreaterThanEqualExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(215);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitEqualityExpression(EqualityExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(216);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitInequalityExpression(InequalityExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(217);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBitwiseAndExpression(BitwiseAndExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(249);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBitwiseXorExpression(BitwiseXorExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(251);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBitwiseOrExpression(BitwiseOrExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(250);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBooleanAndExpression(BooleanAndExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(218);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBooleanXorExpression(BooleanXorExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(219);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBooleanOrExpression(BooleanOrExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(220);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(253);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitMultiplicationAssignmentExpression(MultiplicationAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(221);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitDivisionAssignmentExpression(DivisionAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(222);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitModuloAssignmentExpression(ModuloAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(223);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitAdditionAssignmentExpression(AdditionAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(224);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitSubtractionAssignmentExpression(SubtractionAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(225);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitLeftShiftAssignmentExpression(LeftShiftAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(226);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitRightShiftAssignmentExpression(RightShiftAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(227);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBitwiseAndAssignmentExpression(BitwiseAndAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(228);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBitwiseXorAssignmentExpression(BitwiseXorAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(229);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitBitwiseOrAssignmentExpression(BitwiseOrAssignmentExpression node) {
        this.visit(node.getLeft());
        this.emitBreakableSpace();
        this.emitType(230);
        this.emitBreakableSpace();
        this.visit(node.getRight());
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatement node) {
        this.emitStatementEnd();
        return null;
    }

    @Override
    public void enterCompoundStatement(CompoundStatement node) {
        this.emitType(233);
        this.emitCommonNewline();
        this.indent();
        if (node.getParent() instanceof SwitchStatement) {
            this.indent();
        }
    }

    @Override
    public void exitCompoundStatement(CompoundStatement node) {
        this.unindent();
        if (node.getParent() instanceof SwitchStatement) {
            this.unindent();
        }
        this.emitType(234);
        this.emitCommonNewline();
    }

    @Override
    public void exitExpressionStatement(ExpressionStatement node) {
        this.emitStatementEnd();
    }

    @Override
    public Void visitSelectionStatement(SelectionStatement node) {
        int size = node.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                this.compactCommonNewline(CompoundStatement.class);
            }
            Expression condition = node.getConditions().get(i);
            if (i > 0) {
                this.emitType(39);
                if (condition != null) {
                    this.emitExactSpace();
                }
            }
            if (condition != null) {
                this.emitType(38);
                this.emitExtendableSpace();
                this.emitType(231);
                this.visit(node.getConditions().get(i));
                this.emitType(232);
            }
            this.emitBreakableSpace();
            this.visit(node.getStatements().get(i));
        }
        return null;
    }

    @Override
    public Void visitSwitchStatement(SwitchStatement node) {
        this.emitType(40);
        this.emitExtendableSpace();
        this.emitType(231);
        this.visit(node.getExpression());
        this.emitType(232);
        this.emitBreakableSpace();
        this.visit(node.getStatement());
        return null;
    }

    @Override
    public void enterCaseLabelStatement(CaseLabelStatement node) {
        this.unindent();
    }

    @Override
    public void exitCaseLabelStatement(CaseLabelStatement node) {
        this.indent();
    }

    @Override
    public Void visitCaseStatement(CaseStatement node) {
        this.emitType(41);
        this.emitBreakableSpace();
        this.visit(node.getExpression());
        this.emitType(1);
        this.emitCommonNewline();
        return null;
    }

    @Override
    public Void visitDefaultStatement(DefaultStatement node) {
        this.emitType(42, 1);
        this.emitCommonNewline();
        return null;
    }

    private void visitLoopBody(Statement statement) {
        if (!(statement instanceof EmptyStatement)) {
            this.emitBreakableSpace();
        }
        this.visit(statement);
    }

    @Override
    public Void visitForLoopStatement(ForLoopStatement node) {
        this.emitType(45);
        this.emitBreakableSpace();
        this.emitType(231);
        if (this.visitSafe(node.getInitDeclaration())) {
            this.compactCommonNewline();
        } else {
            if (!this.visitSafe(node.getInitExpression())) {
                this.emitExactSpace();
            }
            this.emitType(235);
            this.emitBreakableSpace();
        }
        if (!this.visitSafe(node.getCondition())) {
            this.visitSafe(node.getIterationConditionInitializer());
        }
        this.emitType(235);
        this.emitBreakableSpace();
        this.visitSafe(node.getIncrementer());
        this.emitType(232);
        this.visitLoopBody(node.getStatement());
        return null;
    }

    @Override
    public Void visitWhileLoopStatement(WhileLoopStatement node) {
        this.emitType(43);
        this.emitBreakableSpace();
        this.emitType(231);
        if (!this.visitSafe(node.getCondition())) {
            this.visitSafe(node.getIterationConditionInitializer());
        }
        this.emitType(232);
        this.visitLoopBody(node.getStatement());
        return null;
    }

    @Override
    public Void visitDoWhileLoopStatement(DoWhileLoopStatement node) {
        this.emitType(44);
        this.visitLoopBody(node.getStatement());
        this.compactCommonNewline(CompoundStatement.class);
        this.emitType(43);
        this.emitBreakableSpace();
        this.emitType(231);
        this.visit(node.getCondition());
        this.emitType(232);
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitContinueStatement(ContinueStatement node) {
        this.emitType(46);
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitBreakStatement(BreakStatement node) {
        this.emitType(47);
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitReturnStatement(ReturnStatement node) {
        this.emitType(48);
        if (node.getExpression() != null) {
            this.emitBreakableSpace();
            this.visit(node.getExpression());
        }
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitDiscardStatement(DiscardStatement node) {
        this.emitType(49);
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitDemoteStatement(DemoteStatement node) {
        this.emitType(50);
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitDeclarationMember(DeclarationMember node) {
        this.visit(node.getName());
        this.visitSafe(node.getArraySpecifier());
        if (node.getInitializer() != null) {
            this.emitBreakableSpace();
            this.emitType(253);
            this.emitBreakableSpace();
            this.visit(node.getInitializer());
        }
        return null;
    }

    @Override
    public Void visitFunctionPrototype(FunctionPrototype node) {
        this.visit(node.getReturnType());
        this.emitBreakableSpace();
        this.visit(node.getName());
        this.emitType(231);
        if (node.getParameters().size() >= 7) {
            this.emitCommonNewline();
            this.indent();
            this.visitWithSeparator(node.getParameters(), () -> {
                this.emitType(238);
                this.emitCommonNewline();
            });
            this.emitCommonNewline();
            this.unindent();
        } else {
            this.visitCommaSpaced(node.getParameters());
        }
        this.emitType(232);
        return null;
    }

    @Override
    public Void visitFunctionParameter(FunctionParameter node) {
        this.visit(node.getType());
        if (node.getName() != null) {
            this.emitBreakableSpace();
            this.visit(node.getName());
            if (node.getArraySpecifier() != null) {
                this.visit(node.getArraySpecifier());
            }
        }
        return null;
    }

    @Override
    public void exitFunctionDeclaration(FunctionDeclaration node) {
        this.emitStatementEnd();
    }

    @Override
    public Void visitInterfaceBlockDeclaration(InterfaceBlockDeclaration node) {
        this.visit(node.getTypeQualifier());
        this.emitBreakableSpace();
        this.visit(node.getBlockName());
        this.emitBreakableSpace();
        this.visit(node.getStructBody());
        if (node.getVariableName() != null) {
            this.emitBreakableSpace();
            this.visit(node.getVariableName());
            this.visitSafe(node.getArraySpecifier());
        }
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitPrecisionDeclaration(PrecisionDeclaration node) {
        this.emitType(10);
        this.emitBreakableSpace();
        this.visit(node.getPrecisionQualifier());
        this.emitBreakableSpace();
        this.visit(node.getTypeSpecifier());
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitTypeAndInitDeclaration(TypeAndInitDeclaration node) {
        this.visit(node.getType());
        if (!node.getMembers().isEmpty()) {
            this.emitBreakableSpace();
            this.visitCommaSpaced(node.getMembers());
        }
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration node) {
        this.visit(node.getTypeQualifier());
        if (!node.getNames().isEmpty()) {
            this.emitBreakableSpace();
            this.visitCommaSpaced(node.getNames());
        }
        this.emitStatementEnd();
        return null;
    }

    @Override
    public Void visitNestedInitializer(NestedInitializer node) {
        this.emitType(233);
        this.emitBreakableSpace();
        this.visitCommaSpaced(node.getInitializers());
        this.emitBreakableSpace();
        this.emitType(234);
        return null;
    }

    @Override
    public Void visitInterpolationQualifier(InterpolationQualifier node) {
        this.emitType(node.interpolationType.tokenType);
        return null;
    }

    @Override
    public Void visitInvariantQualifier(InvariantQualifier node) {
        this.emitType(13);
        return null;
    }

    @Override
    public Void visitLayoutQualifier(LayoutQualifier node) {
        this.emitType(21, 231);
        this.visitCommaSpaced(node.getParts());
        this.emitType(232);
        return null;
    }

    @Override
    public Void visitNamedLayoutQualifierPart(NamedLayoutQualifierPart node) {
        this.visit(node.getName());
        if (node.getExpression() != null) {
            this.emitBreakableSpace();
            this.emitType(253);
            this.emitBreakableSpace();
            this.visit(node.getExpression());
        }
        return null;
    }

    @Override
    public Void visitSharedLayoutQualifierPart(SharedLayoutQualifierPart node) {
        this.emitType(20);
        return null;
    }

    @Override
    public Void visitPreciseQualifier(PreciseQualifier node) {
        this.emitType(12);
        return null;
    }

    @Override
    public Void visitPrecisionQualifier(PrecisionQualifier node) {
        this.emitType(node.precisionLevel.tokenType);
        return null;
    }

    @Override
    public Void visitStorageQualifier(StorageQualifier node) {
        this.emitType(node.storageType.tokenType);
        if (node.getTypeNames() != null) {
            this.emitType(231);
            this.visitCommaSpaced(node.getTypeNames());
            this.emitType(232);
        }
        return null;
    }

    @Override
    public Void visitTypeQualifier(TypeQualifier node) {
        this.visitWithSeparator(node.getParts(), this::emitBreakableSpace);
        return null;
    }

    @Override
    public Void visitArraySpecifier(ArraySpecifier node) {
        for (Expression dimension : node.getDimensions()) {
            this.emitType(236);
            this.visitSafe(dimension);
            this.emitType(237);
        }
        return null;
    }

    @Override
    public void exitTypeSpecifier(TypeSpecifier node) {
        this.visitSafe(node.getArraySpecifier());
    }

    @Override
    public Void visitBuiltinFixedTypeSpecifier(BuiltinFixedTypeSpecifier node) {
        this.emitType(node.type.tokenType);
        return null;
    }

    @Override
    public Void visitBuiltinNumericTypeSpecifier(BuiltinNumericTypeSpecifier node) {
        this.emitLiteral(node.type.getMostCompactName());
        return null;
    }

    @Override
    public Void visitStructBody(StructBody node) {
        this.emitType(233);
        if (node.getMembers().size() <= 1) {
            this.emitBreakableSpace();
            this.visitWithSeparator(node.getMembers(), this::emitBreakableSpace);
            this.emitBreakableSpace();
        } else {
            this.emitCommonNewline();
            this.indent();
            this.visitWithSeparator(node.getMembers(), this::emitCommonNewline);
            this.unindent();
            this.emitCommonNewline();
        }
        this.emitType(234);
        return null;
    }

    @Override
    public Void visitStructDeclarator(StructDeclarator node) {
        this.visit(node.getName());
        this.visitSafe(node.getArraySpecifier());
        return null;
    }

    @Override
    public Void visitStructMember(StructMember node) {
        this.visit(node.getType());
        this.emitBreakableSpace();
        this.visitCommaSpaced(node.getDeclarators());
        this.emitType(235);
        return null;
    }

    @Override
    public Void visitStructSpecifier(StructSpecifier node) {
        this.emitType(37);
        this.emitBreakableSpace();
        if (node.getName() != null) {
            this.visit(node.getName());
            this.emitBreakableSpace();
        }
        this.visit(node.getStructBody());
        return null;
    }

    @Override
    public Void visitFullySpecifiedType(FullySpecifiedType node) {
        if (node.getTypeQualifier() != null) {
            this.visit(node.getTypeQualifier());
            this.emitBreakableSpace();
        }
        this.visit(node.getTypeSpecifier());
        return null;
    }

    @Override
    public Void visitIterationConditionInitializer(IterationConditionInitializer node) {
        this.visit(node.getType());
        this.emitBreakableSpace();
        this.visit(node.getName());
        this.emitBreakableSpace();
        this.emitType(253);
        this.emitBreakableSpace();
        this.visit(node.getInitializer());
        return null;
    }

    @Override
    public Void visitIdentifier(Identifier node) {
        this.emitLiteral(node.getName());
        return null;
    }
}

