/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render;

import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.mojang.ChunkPos;
import com.gtnewhorizons.angelica.compat.toremove.MatrixStack;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import jss.notfine.core.SettingsManager;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.compat.FogHelper;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderManager;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.backends.oneshot.ChunkRenderBackendOneshot;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.DefaultModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheShared;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.common.util.ListUtil;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.coderbot.iris.sodium.shadow_map.SwappableChunkRenderManager;
import net.coderbot.iris.sodium.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import org.joml.Vector3d;

public class SodiumWorldRenderer
implements ChunkStatusListener {
    private static SodiumWorldRenderer instance;
    private final Minecraft client;
    private WorldClient world;
    private int renderDistance;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private float lastFov;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private float lastFogDistance;
    private boolean useEntityCulling;
    private final LongSet loadedChunkPositions = new LongOpenHashSet();
    private final Set<TileEntity> globalTileEntities = new ObjectOpenHashSet();
    private Frustrum frustum;
    private ChunkRenderManager<?> chunkRenderManager;
    private ChunkRenderBackend<?> chunkRenderBackend;
    private boolean wasRenderingShadows = false;
    private double iris$swapLastCameraX;
    private double iris$swapLastCameraY;
    private double iris$swapLastCameraZ;
    private double iris$swapLastCameraPitch;
    private double iris$swapLastCameraYaw;
    public static boolean hasChanges;

    public static SodiumWorldRenderer create(Minecraft mc) {
        if (instance == null) {
            instance = new SodiumWorldRenderer(mc);
        }
        return instance;
    }

    public static SodiumWorldRenderer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Renderer not initialized");
        }
        return instance;
    }

    private SodiumWorldRenderer(Minecraft client) {
        this.client = client;
    }

    public void setWorld(WorldClient world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            if (DynamicLights.isEnabled()) {
                DynamicLights.get().clearLightSources();
            }
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    private void loadWorld(WorldClient world) {
        this.world = world;
        ChunkRenderCacheShared.createRenderContext(this.world);
        this.initRenderer();
    }

    private void unloadWorld() {
        ChunkRenderCacheShared.destroyRenderContext(this.world);
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.loadedChunkPositions.clear();
        this.globalTileEntities.clear();
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.chunkRenderManager != null) {
            if (AngelicaConfig.enableIris) {
                this.iris$ensureStateSwapped();
            }
            this.chunkRenderManager.markDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.chunkRenderManager.isBuildComplete();
    }

    public void updateChunks(Camera camera, Frustrum frustum, boolean hasForcedFrustum, int frame, boolean spectator) {
        boolean dirty;
        this.frustum = frustum;
        this.useEntityCulling = SodiumClientMod.options().advanced.useEntityCulling;
        if (this.client.field_71474_y.field_151451_c != this.renderDistance) {
            this.reload();
        }
        Profiler profiler = this.client.field_71424_I;
        profiler.func_76320_a("camera_setup");
        EntityClientPlayerMP player = this.client.field_71439_g;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        Vector3d pos = camera.getPos();
        this.chunkRenderManager.setCameraPosition(pos.x, pos.y, pos.z);
        float pitch = camera.getPitch();
        float yaw = camera.getYaw();
        float fogDistance = FogHelper.getFogCutoff();
        float fov = RenderingState.INSTANCE.getFov();
        boolean bl = dirty = pos.x != this.lastCameraX || pos.y != this.lastCameraY || pos.z != this.lastCameraZ || (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw || fogDistance != this.lastFogDistance || fov != this.lastFov;
        if (AngelicaConfig.enableIris) {
            this.iris$ensureStateSwapped();
            if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                dirty = true;
            }
        }
        if (dirty) {
            this.chunkRenderManager.markDirty();
        }
        this.lastCameraX = pos.x;
        this.lastCameraY = pos.y;
        this.lastCameraZ = pos.z;
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        this.lastFogDistance = fogDistance;
        this.lastFov = fov;
        profiler.func_76318_c("chunk_update");
        this.chunkRenderManager.updateChunks();
        if (!hasForcedFrustum && this.chunkRenderManager.isDirty()) {
            profiler.func_76318_c("chunk_graph_rebuild");
            this.chunkRenderManager.update(camera, (FrustumExtended)frustum, frame, spectator);
        }
        profiler.func_76318_c("visible_chunk_tick");
        this.chunkRenderManager.tickVisibleRenders();
        profiler.func_76319_b();
        SodiumGameOptions.EntityRenderDistance.setRenderDistanceMult(MathHelper.func_151237_a((double)((double)this.client.field_71474_y.field_151451_c / 8.0), (double)1.0, (double)2.5) * 1.0 * SettingsManager.entityRenderScaleFactor);
        if (AngelicaConfig.enableIris && ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            ShadowRenderer.visibleTileEntities.addAll(this.chunkRenderManager.getVisibleTileEntities());
        }
    }

    public void drawChunkLayer(BlockRenderPass pass, MatrixStack matrixStack, double x, double y, double z) {
        GLStateManager.enableCull();
        if (AngelicaConfig.enableIris) {
            this.iris$ensureStateSwapped();
        }
        this.chunkRenderManager.renderLayer(matrixStack, pass, x, y, z);
        GLStateManager.clearCurrentColor();
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        this.initRenderer();
    }

    private void initRenderer() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.globalTileEntities.clear();
        RenderDevice device = RenderDevice.INSTANCE;
        this.renderDistance = this.client.field_71474_y.field_151451_c;
        SodiumGameOptions opts = SodiumClientMod.options();
        ChunkVertexType vertexFormat = AngelicaConfig.enableIris && BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat() ? IrisModelVertexFormats.MODEL_VERTEX_XHFP : (opts.advanced.useCompactVertexFormat ? DefaultModelVertexFormats.MODEL_VERTEX_HFP : DefaultModelVertexFormats.MODEL_VERTEX_SFP);
        this.chunkRenderBackend = SodiumWorldRenderer.createChunkRenderBackend(device, opts, vertexFormat);
        this.chunkRenderBackend.createShaders(device);
        this.chunkRenderManager = new ChunkRenderManager(this, this.chunkRenderBackend, this.world, this.renderDistance);
        this.chunkRenderManager.restoreChunks((LongCollection)this.loadedChunkPositions);
    }

    private static ChunkRenderBackend<?> createChunkRenderBackend(RenderDevice device, SodiumGameOptions options, ChunkVertexType vertexFormat) {
        boolean disableBlacklist = SodiumClientMod.options().advanced.ignoreDriverBlacklist;
        if (options.advanced.useChunkMultidraw && MultidrawChunkRenderBackend.isSupported(disableBlacklist)) {
            return new MultidrawChunkRenderBackend(device, vertexFormat);
        }
        return new ChunkRenderBackendOneshot(vertexFormat);
    }

    private boolean checkBEVisibility(TileEntity entity) {
        return this.frustum.func_78546_a(entity.getRenderBoundingBox());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTE(TileEntity tileEntity, int pass, float partialTicks) {
        block9: {
            if (!tileEntity.shouldRenderInPass(pass) || !this.checkBEVisibility(tileEntity)) {
                return;
            }
            try {
                if (AngelicaConfig.enableIris) {
                    Block block = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                    CapturedRenderingState.INSTANCE.setCurrentBlockEntity(Block.func_149682_b((Block)block));
                    GbufferPrograms.beginBlockEntities();
                }
                TileEntityRendererDispatcher.field_147556_a.func_147544_a(tileEntity, partialTicks);
            }
            catch (RuntimeException e) {
                if (tileEntity.func_145837_r()) {
                    SodiumClientMod.logger().error("Suppressing crash from invalid tile entity", (Throwable)e);
                    break block9;
                }
                throw e;
            }
            finally {
                if (AngelicaConfig.enableIris) {
                    CapturedRenderingState.INSTANCE.setCurrentBlockEntity(-1);
                    GbufferPrograms.endBlockEntities();
                }
            }
        }
    }

    public void renderTileEntities(EntityLivingBase entity, ICamera camera, float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        for (TileEntity tileEntity : this.chunkRenderManager.getVisibleTileEntities()) {
            this.renderTE(tileEntity, pass, partialTicks);
        }
        for (TileEntity tileEntity : this.globalTileEntities) {
            this.renderTE(tileEntity, pass, partialTicks);
        }
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.loadedChunkPositions.add(ChunkPos.toLong(x, z));
        this.chunkRenderManager.onChunkAdded(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.loadedChunkPositions.remove(ChunkPos.toLong(x, z));
        this.chunkRenderManager.onChunkRemoved(x, z);
    }

    public void onChunkRenderUpdated(int x, int y, int z, ChunkRenderData meshBefore, ChunkRenderData meshAfter) {
        ListUtil.updateList(this.globalTileEntities, meshBefore.getGlobalTileEntities(), meshAfter.getGlobalTileEntities());
        this.chunkRenderManager.onChunkRenderUpdates(x, y, z, meshAfter);
    }

    private static boolean isInfiniteExtentsBox(AxisAlignedBB box) {
        return Double.isInfinite(box.field_72340_a) || Double.isInfinite(box.field_72338_b) || Double.isInfinite(box.field_72339_c) || Double.isInfinite(box.field_72336_d) || Double.isInfinite(box.field_72337_e) || Double.isInfinite(box.field_72334_f);
    }

    public boolean isEntityVisible(Entity entity) {
        EntityLiving living;
        if (!this.useEntityCulling || entity.field_70158_ak) {
            return true;
        }
        AxisAlignedBB box = entity.field_70121_D;
        if (box.field_72337_e < 0.5 || box.field_72338_b > 255.5) {
            return true;
        }
        if (SodiumWorldRenderer.isInfiniteExtentsBox(box)) {
            return true;
        }
        if (entity instanceof EntityLiving && (living = (EntityLiving)entity).func_94056_bM()) {
            return true;
        }
        int minX = MathHelper.func_76128_c((double)(box.field_72340_a - 0.5)) >> 4;
        int minY = MathHelper.func_76128_c((double)(box.field_72338_b - 0.5)) >> 4;
        int minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 0.5)) >> 4;
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 0.5)) >> 4;
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 0.5)) >> 4;
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 0.5)) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.chunkRenderManager.isChunkVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getChunksDebugString() {
        return String.format("C: %s/%s S: %s Q: %s+%si ", this.chunkRenderManager.getVisibleChunkCount(), this.chunkRenderManager.getTotalSections(), this.chunkRenderManager.getSubmitted(), this.chunkRenderManager.getRebuildQueueSize(), this.chunkRenderManager.getImportantRebuildQueueSize());
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.chunkRenderManager.scheduleRebuild(x, y, z, important);
    }

    public ChunkRenderBackend<?> getChunkRenderer() {
        return this.chunkRenderBackend;
    }

    private void swapCachedCameraPositions() {
        double tmp = this.lastCameraX;
        this.lastCameraX = this.iris$swapLastCameraX;
        this.iris$swapLastCameraX = tmp;
        tmp = this.lastCameraY;
        this.lastCameraY = this.iris$swapLastCameraY;
        this.iris$swapLastCameraY = tmp;
        tmp = this.lastCameraZ;
        this.lastCameraZ = this.iris$swapLastCameraZ;
        this.iris$swapLastCameraZ = tmp;
        tmp = this.lastCameraPitch;
        this.lastCameraPitch = this.iris$swapLastCameraPitch;
        this.iris$swapLastCameraPitch = tmp;
        tmp = this.lastCameraYaw;
        this.lastCameraYaw = this.iris$swapLastCameraYaw;
        this.iris$swapLastCameraYaw = tmp;
    }

    private void iris$ensureStateSwapped() {
        if (!this.wasRenderingShadows && ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (this.chunkRenderManager instanceof SwappableChunkRenderManager) {
                ((SwappableChunkRenderManager)((Object)this.chunkRenderManager)).iris$swapVisibilityState();
                this.swapCachedCameraPositions();
            }
            this.wasRenderingShadows = true;
        } else if (this.wasRenderingShadows && !ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (this.chunkRenderManager instanceof SwappableChunkRenderManager) {
                ((SwappableChunkRenderManager)((Object)this.chunkRenderManager)).iris$swapVisibilityState();
                this.swapCachedCameraPositions();
            }
            this.wasRenderingShadows = false;
        }
    }

    public Frustrum getFrustum() {
        return this.frustum;
    }

    static {
        hasChanges = false;
    }
}

