/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.Identifier;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.node.Version;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.print.PrintType;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.query.Root;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.ast.transform.EnumASTTransformer;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.cst.core.SemanticException;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.cst.token_filter.ChannelFilter;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.cst.token_filter.TokenChannel;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.cst.token_filter.TokenFilter;
import com.gtnewhorizons.angelica.shadow.io.github.douira.glsl_transformer.util.LRUCache;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.RecognitionException;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.Token;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.transform.AttributeParameters;
import net.coderbot.iris.pipeline.transform.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.CompositeTransformer;
import net.coderbot.iris.pipeline.transform.Parameters;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.SodiumTerrainTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformPatcher {
    static Logger LOGGER = LogManager.getLogger(TransformPatcher.class);
    private static EnumASTTransformer<Parameters, PatchShaderType> transformer;
    private static final boolean useCache = true;
    private static final Map<CacheKey, Map<PatchShaderType, String>> cache;
    static TokenFilter<Parameters> parseTokenFilter;
    private static final Pattern versionPattern;

    private static Map<PatchShaderType, String> transform(String vertex, String geometry, String fragment, Parameters parameters) {
        if (vertex == null && geometry == null && fragment == null) {
            return null;
        }
        Map result = null;
        CacheKey key = new CacheKey(parameters, vertex, geometry, fragment);
        if (cache.containsKey(key)) {
            result = cache.get(key);
        }
        if (result == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            inputs.put(PatchShaderType.VERTEX, vertex);
            inputs.put(PatchShaderType.GEOMETRY, geometry);
            inputs.put(PatchShaderType.FRAGMENT, fragment);
            result = transformer.transform(inputs, parameters);
            cache.put(key, result);
        }
        return result;
    }

    public static Map<PatchShaderType, String> patchAttributes(String vertex, String geometry, String fragment, InputAvailability inputs) {
        return TransformPatcher.transform(vertex, geometry, fragment, new AttributeParameters(Patch.ATTRIBUTES, geometry != null, inputs));
    }

    public static Map<PatchShaderType, String> patchSodiumTerrain(String vertex, String geometry, String fragment) {
        return TransformPatcher.transform(vertex, geometry, fragment, new Parameters(Patch.SODIUM_TERRAIN));
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String fragment) {
        return TransformPatcher.transform(vertex, geometry, fragment, new Parameters(Patch.COMPOSITE));
    }

    static {
        cache = new LRUCache<CacheKey, Map<PatchShaderType, String>>(400);
        parseTokenFilter = new ChannelFilter<Parameters>(TokenChannel.PREPROCESSOR){

            @Override
            public boolean isTokenAllowed(Token token) {
                if (!super.isTokenAllowed(token)) {
                    throw new SemanticException("Unparsed preprocessor directives such as '" + token.getText() + "' may not be present at this stage of shader processing!");
                }
                return true;
            }
        };
        transformer = new EnumASTTransformer<Parameters, PatchShaderType>(PatchShaderType.class){

            @Override
            public TranslationUnit parseTranslationUnit(String input) throws RecognitionException {
                Version version;
                Matcher matcher = versionPattern.matcher(input);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
                }
                transformer.getLexer().version = version = Version.fromNumber(Integer.parseInt(matcher.group(1)));
                return super.parseTranslationUnit(input);
            }
        };
        transformer.setTransformation((trees, parameters) -> {
            for (PatchShaderType type : PatchShaderType.values()) {
                TranslationUnit tree = (TranslationUnit)trees.get((Object)type);
                if (tree == null) continue;
                parameters.type = type;
                Root root = tree.getRoot();
                Optional<Identifier> violation = root.identifierIndex.prefixQueryFlat("iris_").findAny();
                if (!violation.isPresent()) {
                    violation = root.identifierIndex.prefixQueryFlat("irisMain").findAny();
                }
                violation.ifPresent(id -> {
                    throw new SemanticException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_ and irisMain). This isn't currently supported. Violation: " + id.getName() + ". See debugging.md for more information.");
                });
                Root.indexBuildSession(tree, () -> {
                    switch (parameters.patch) {
                        case ATTRIBUTES: {
                            AttributeTransformer.transform(transformer, tree, root, (AttributeParameters)parameters);
                            break;
                        }
                        case SODIUM_TERRAIN: {
                            SodiumTerrainTransformer.transform(transformer, tree, root, parameters);
                            break;
                        }
                        case COMPOSITE: {
                            CompositeTransformer.transform(transformer, tree, root);
                        }
                    }
                    CompatibilityTransformer.transformEach(transformer, tree, root, parameters);
                });
            }
            CompatibilityTransformer.transformGrouped(transformer, trees, parameters);
        });
        transformer.setParseTokenFilter(parseTokenFilter);
        versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);
    }

    private static class CacheKey {
        final Parameters parameters;
        final String vertex;
        final String geometry;
        final String fragment;

        public CacheKey(Parameters parameters, String vertex, String geometry, String fragment) {
            this.parameters = parameters;
            this.vertex = vertex;
            this.geometry = geometry;
            this.fragment = fragment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
            result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.vertex == null ? 0 : this.vertex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
                return false;
            }
            if (this.geometry == null ? other.geometry != null : !this.geometry.equals(other.geometry)) {
                return false;
            }
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            return !(this.vertex == null ? other.vertex != null : !this.vertex.equals(other.vertex));
        }
    }
}

