/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigFieldParser;
import com.gtnewhorizon.gtnhlib.config.IConfigElementProxy;
import cpw.mods.fml.client.config.IConfigElement;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConfigurationManager {
    static final Logger LOGGER = LogManager.getLogger((String)"GTNHLibConfig");
    private static final Map<String, Configuration> configs = new HashMap<String, Configuration>();
    private static final Map<Configuration, Map<String, Set<Class<?>>>> configToCategoryClassMap = new HashMap();
    private static final String[] langKeyPlaceholders = new String[]{"%mod", "%file", "%cat", "%field"};
    private static final Boolean PRINT_KEYS = Boolean.getBoolean("gtnhlib.printkeys");
    private static final ConfigurationManager instance = new ConfigurationManager();
    private static boolean initialized = false;
    private static Path configDir;

    public static void registerConfig(Class<?> configClass) throws ConfigException {
        ConfigurationManager.init();
        Config cfg = Optional.ofNullable(configClass.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + configClass.getName() + " does not have a @Config annotation!"));
        String category = cfg.category().trim().toLowerCase();
        String modid = cfg.modid();
        String filename = Optional.of(cfg.filename().trim()).filter(s -> !s.isEmpty()).orElse(modid);
        Configuration rawConfig = configs.computeIfAbsent(ConfigurationManager.getConfigKey(cfg), ignored -> {
            Path newConfigDir = configDir;
            if (!cfg.configSubDirectory().trim().isEmpty()) {
                newConfigDir = newConfigDir.resolve(cfg.configSubDirectory().trim());
            }
            File configFile = newConfigDir.resolve(filename + ".cfg").toFile();
            Configuration config = new Configuration(configFile);
            config.load();
            return config;
        });
        configToCategoryClassMap.computeIfAbsent(rawConfig, ignored -> new HashMap()).computeIfAbsent(category, ignored -> new HashSet()).add(configClass);
        try {
            ConfigurationManager.processConfigInternal(configClass, category, rawConfig, null);
            rawConfig.save();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigException(e);
        }
    }

    public static void save(Class<?> ... configClasses) {
        if (configClasses.length == 0) {
            return;
        }
        HashSet<Configuration> savedConfigs = new HashSet<Configuration>();
        for (Class<?> clazz : configClasses) {
            try {
                Config cfg = Optional.ofNullable(clazz.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + clazz.getName() + " does not have a @Config annotation!"));
                String category = cfg.category().trim().toLowerCase();
                Configuration rawConfig = configs.get(ConfigurationManager.getConfigKey(cfg));
                ConfigurationManager.save(clazz, null, rawConfig, category);
                savedConfigs.add(rawConfig);
            }
            catch (ConfigException | IllegalAccessException e) {
                LOGGER.error("Failed to save config for class {}", new Object[]{clazz.getName(), e});
            }
        }
        savedConfigs.forEach(Configuration::save);
    }

    private static void save(Class<?> configClass, Object instance, Configuration rawConfig, String category) throws IllegalAccessException, ConfigException {
        for (Field field : configClass.getDeclaredFields()) {
            if (field.getAnnotation(Config.Ignore.class) != null) continue;
            field.setAccessible(true);
            if (!ConfigFieldParser.canParse(field)) {
                if (!ConfigurationManager.isFieldSubCategory(field)) continue;
                String cat = (category.isEmpty() ? "" : category + ".") + ConfigFieldParser.getFieldName(field).toLowerCase();
                Object subInstance = field.get(instance);
                ConfigurationManager.save(field.getType(), subInstance, rawConfig, cat);
                continue;
            }
            if (category.isEmpty()) continue;
            ConfigFieldParser.saveField(instance, field, rawConfig, category);
        }
    }

    private static void processSubCategory(Object instance, Configuration config, Field subCategoryField, String category) throws ConfigException {
        String name = ConfigFieldParser.getFieldName(subCategoryField);
        String cat = (category.isEmpty() ? "" : category + ".") + name.toLowerCase();
        ConfigCategory subCat = config.getCategory(cat);
        Optional.ofNullable(subCategoryField.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).ifPresent(arg_0 -> ((ConfigCategory)subCat).setComment(arg_0));
        Optional.ofNullable(subCategoryField.getAnnotation(Config.LangKey.class)).map(Config.LangKey::value).ifPresent(arg_0 -> ((ConfigCategory)subCat).setLanguageKey(arg_0));
        if (subCategoryField.isAnnotationPresent(Config.RequiresMcRestart.class)) {
            subCat.setRequiresMcRestart(true);
        }
        if (subCategoryField.isAnnotationPresent(Config.RequiresWorldRestart.class)) {
            subCat.setRequiresWorldRestart(true);
        }
        try {
            Object subInstance = subCategoryField.get(instance);
            ConfigurationManager.processConfigInternal(subCategoryField.getType(), cat, config, subInstance);
            config.save();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigException(e);
        }
    }

    private static void processConfigInternal(Class<?> configClass, String category, Configuration rawConfig, @Nullable Object instance) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException, ConfigException {
        boolean foundCategory = !category.isEmpty();
        ConfigCategory cat = foundCategory ? rawConfig.getCategory(category) : null;
        boolean requiresMcRestart = ConfigurationManager.getClassOrBaseAnnotation(configClass, Config.RequiresMcRestart.class) != null || foundCategory && cat.requiresMcRestart();
        boolean requiresWorldRestart = ConfigurationManager.getClassOrBaseAnnotation(configClass, Config.RequiresWorldRestart.class) != null || foundCategory && cat.requiresWorldRestart();
        for (Field field : configClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(Config.Ignore.class)) continue;
            if (instance != null && Modifier.isStatic(field.getModifiers())) {
                throw new ConfigException("Illegal config field: " + field.getName() + " in " + configClass.getName() + ": Static field in instance context! Did you forget an @Config.Ignore annotation?");
            }
            field.setAccessible(true);
            if (!ConfigFieldParser.canParse(field)) {
                if (ConfigurationManager.isFieldSubCategory(field)) {
                    ConfigurationManager.processSubCategory(instance, rawConfig, field, category);
                    foundCategory = true;
                    continue;
                }
                throw new ConfigException("Illegal config field: " + field.getName() + " in " + configClass.getName() + ": Unsupported type " + field.getType().getName() + "! Did you forget an @Ignore annotation?");
            }
            if (category.isEmpty()) continue;
            String langKey = ConfigurationManager.getLangKey(configClass, field.getAnnotation(Config.LangKey.class), ConfigFieldParser.getFieldName(field), cat);
            ConfigFieldParser.loadField(instance, field, rawConfig, category, langKey);
            if (!requiresMcRestart) {
                requiresMcRestart = field.isAnnotationPresent(Config.RequiresMcRestart.class);
            }
            if (requiresWorldRestart) continue;
            requiresWorldRestart = field.isAnnotationPresent(Config.RequiresWorldRestart.class);
        }
        if (!foundCategory) {
            throw new ConfigException("No category found for config class " + configClass.getName() + "!");
        }
        if (category.isEmpty()) {
            return;
        }
        if (cat.getLanguagekey().equals(category)) {
            String langKey = ConfigurationManager.getLangKey(configClass, configClass.getAnnotation(Config.LangKey.class), null, cat);
            cat.setLanguageKey(langKey);
        }
        cat.setRequiresMcRestart(requiresMcRestart);
        cat.setRequiresWorldRestart(requiresWorldRestart);
        Optional.ofNullable(configClass.getAnnotation(Config.Comment.class)).map(Config.Comment::value).map(lines -> String.join((CharSequence)"\n", lines)).ifPresent(arg_0 -> ((ConfigCategory)cat).setComment(arg_0));
    }

    public static List<IConfigElement> getConfigElements(Class<?> configClass) throws ConfigException {
        return ConfigurationManager.getConfigElements(configClass, false);
    }

    public static List<IConfigElement> getConfigElements(Class<?> configClass, boolean categorized) throws ConfigException {
        ConfigurationManager.init();
        Config cfg = Optional.ofNullable(configClass.getAnnotation(Config.class)).orElseThrow(() -> new ConfigException("Class " + configClass.getName() + " does not have a @Config annotation!"));
        Configuration rawConfig = Optional.ofNullable(configs.get(ConfigurationManager.getConfigKey(cfg))).map(conf -> Optional.ofNullable(configToCategoryClassMap.get(conf)).map(map -> ((Set)map.get(cfg.category().trim().toLowerCase())).contains(configClass)).orElse(false) != false ? conf : null).orElseThrow(() -> new ConfigException("Tried to get config elements for non-registered config class!"));
        String category = cfg.category().toLowerCase();
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        if (categorized) {
            if (category.isEmpty()) {
                return ConfigurationManager.getSubcategoryElements(configClass, category, rawConfig, true);
            }
            if (category.indexOf(46) != -1) {
                return Collections.emptyList();
            }
            result.add(ConfigurationManager.getProxyElement(new ConfigElement(rawConfig.getCategory(category)), configClass, rawConfig, category));
        } else {
            List elements = category.isEmpty() ? ConfigurationManager.getSubcategoryElements(configClass, category, rawConfig, false) : new ConfigElement(rawConfig.getCategory(category)).getChildElements();
            elements.stream().map(element -> ConfigurationManager.getProxyElement(element, configClass, rawConfig, category)).forEach(result::add);
        }
        return result;
    }

    public static List<IConfigElement> getConfigElementsMulti(Class<?> ... configClasses) throws ConfigException {
        return ConfigurationManager.getConfigElementsMulti(false, configClasses);
    }

    public static List<IConfigElement> getConfigElementsMulti(boolean categorized, Class<?> ... configClasses) throws ConfigException {
        switch (configClasses.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return ConfigurationManager.getConfigElements(configClasses[0], categorized);
            }
        }
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        for (Class<?> configClass : configClasses) {
            List<IConfigElement> elements = ConfigurationManager.getConfigElements(configClass, categorized);
            result.addAll(elements);
        }
        return result;
    }

    private static List<IConfigElement> getSubcategoryElements(Class<?> configClass, String category, Configuration rawConfig, boolean categorized) {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (Field field : configClass.getDeclaredFields()) {
            if (!ConfigurationManager.isFieldSubCategory(field)) continue;
            String name = ConfigFieldParser.getFieldName(field).toLowerCase();
            elements.add(ConfigurationManager.getProxyElement(new ConfigElement(rawConfig.getCategory(name)), configClass, rawConfig, category));
        }
        if (categorized) {
            return elements;
        }
        return elements.stream().flatMap(element -> element.getChildElements().stream()).collect(Collectors.toList());
    }

    private static IConfigElementProxy<?> getProxyElement(IConfigElement<?> element, Class<?> configClass, Configuration rawConfig, String category) {
        if (element instanceof IConfigElementProxy) {
            IConfigElementProxy proxy = (IConfigElementProxy)element;
            return proxy;
        }
        return new IConfigElementProxy(element, () -> {
            try {
                ConfigurationManager.processConfigInternal(configClass, category, rawConfig, null);
                rawConfig.save();
            }
            catch (ConfigException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    private static String getLangKey(Class<?> configClass, @Nullable Config.LangKey langKey, @Nullable String fieldName, @NotNull ConfigCategory category) throws ConfigException {
        String categoryName;
        if (langKey != null) {
            return langKey.value();
        }
        Config.LangKeyPattern pattern = ConfigurationManager.getClassOrBaseAnnotation(configClass, Config.LangKeyPattern.class);
        String name = Optional.ofNullable(fieldName).orElse(category.getQualifiedName());
        if (pattern == null) {
            return name;
        }
        String patternStr = pattern.pattern();
        if (!patternStr.contains("%field") || !patternStr.contains(".")) {
            throw new ConfigException("Invalid pattern for class " + configClass.getName() + ": " + patternStr);
        }
        Config cfg = ConfigurationManager.getClassOrBaseAnnotation(configClass, Config.class);
        assert (cfg != null);
        String string = categoryName = pattern.fullyQualified() ? category.getQualifiedName() : category.getName();
        if (fieldName == null) {
            name = categoryName;
        }
        String key = ConfigurationManager.buildKeyFromPattern(patternStr, cfg.modid(), cfg.filename(), categoryName, name);
        if (PRINT_KEYS.booleanValue()) {
            if (fieldName != null) {
                LOGGER.info("Lang key for field {} in category {}: {}", new Object[]{fieldName, category.getName(), key});
            } else {
                LOGGER.info("Lang key for category {}: {}", new Object[]{category.getName(), key});
            }
        }
        return key;
    }

    private static String buildKeyFromPattern(String pattern, String modId, String fileName, String categoryName, String fieldName) {
        StringBuilder s = new StringBuilder(pattern);
        String[] replacements = new String[]{modId, fileName, categoryName, fieldName};
        boolean isCategory = categoryName.equals(fieldName);
        for (int i = 0; i < langKeyPlaceholders.length; ++i) {
            String placeholder = langKeyPlaceholders[i];
            int index = s.indexOf(placeholder);
            if (index == -1) continue;
            int nextIndex = index + placeholder.length();
            if (isCategory && "%field".equals(placeholder)) {
                if (nextIndex + 1 <= s.length() && s.charAt(nextIndex + 1) == '.') {
                    s.delete(index, nextIndex + 1);
                    continue;
                }
                s.delete(index - 1, nextIndex);
                continue;
            }
            s.replace(index, nextIndex, replacements[i].toLowerCase());
        }
        return s.toString();
    }

    @Nullable
    private static <A extends Annotation> A getClassOrBaseAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A annotation = clazz.getAnnotation(annotationClass);
        while (annotation == null && clazz.isMemberClass()) {
            clazz = clazz.getDeclaringClass();
            annotation = clazz.getAnnotation(annotationClass);
        }
        return annotation;
    }

    private static boolean isFieldSubCategory(@Nullable Field field) {
        if (field == null) {
            return false;
        }
        Class<?> fieldClass = field.getType();
        return !ConfigFieldParser.canParse(field) && fieldClass.getSuperclass() != null && fieldClass.getSuperclass().equals(Object.class);
    }

    private static String getConfigKey(Config cfg) {
        return cfg.modid() + "|" + cfg.configSubDirectory() + "|" + cfg.filename();
    }

    private static File minecraftHome() {
        return Launch.minecraftHome != null ? Launch.minecraftHome : new File(".");
    }

    private static void init() {
        if (initialized) {
            return;
        }
        configDir = ConfigurationManager.minecraftHome().toPath().resolve("config");
        initialized = true;
    }

    private ConfigurationManager() {
    }
}

