/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fluid;

import com.cleanroommc.modularui.utils.fluid.IFluidTankLong;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.Nullable;

public class FluidTankLong
implements IFluidTankLong {
    @Nullable
    private Fluid fluid;
    private long amount;
    private long capacity;
    private boolean locked = false;

    public FluidTankLong() {
        this(null, 0L, 0L);
    }

    public FluidTankLong(@Nullable Fluid fluid) {
        this(fluid, 0L, 0L);
    }

    public FluidTankLong(@Nullable Fluid fluid, long capacity) {
        this(fluid, capacity, 0L);
    }

    public FluidTankLong(long capacity) {
        this(null, capacity, 0L);
    }

    public FluidTankLong(@Nullable Fluid fluid, long capacity, long amount) {
        this.fluid = fluid;
        this.capacity = capacity;
        this.amount = amount;
    }

    @Override
    public long drainLong(long maxDrain, boolean doDrain) {
        long toDrain = Math.min(maxDrain, this.amount);
        if (doDrain) {
            this.amount -= toDrain;
            if (this.amount <= 0L && !this.locked) {
                this.fluid = null;
            }
        }
        return toDrain;
    }

    @Override
    public long fillLong(Fluid fluid, long amount, boolean doFill) {
        if (fluid == null) {
            return 0L;
        }
        if (!doFill && this.fluid == null) {
            return amount;
        }
        if (doFill && this.fluid == null) {
            this.fluid = fluid;
        }
        if (this.fluid != fluid) {
            return 0L;
        }
        long toFill = Math.min(amount, this.getCapacityLong() - this.getFluidAmountLong());
        if (doFill) {
            amount += toFill;
        }
        return toFill;
    }

    @Override
    public long getCapacityLong() {
        return this.capacity;
    }

    @Override
    public long getFluidAmountLong() {
        return this.amount;
    }

    @Override
    public Fluid getRealFluid() {
        return this.fluid;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setFluid(Fluid fluid, long amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    @Override
    public IFluidTankLong copy() {
        return new FluidTankLong(this.getRealFluid(), this.getCapacityLong(), this.getFluidAmountLong());
    }

    @Override
    public IFluidTankLong readFromNBT(NBTTagCompound nbt) {
        this.fluid = nbt.func_74764_b("FluidName") ? FluidRegistry.getFluid((String)nbt.func_74779_i("FluidName")) : null;
        this.amount = nbt.func_74763_f("Amount");
        this.capacity = nbt.func_74763_f("Capacity");
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.fluid != null) {
            nbt.func_74778_a("FluidName", FluidRegistry.getFluidName((Fluid)this.fluid));
        }
        nbt.func_74772_a("Amount", this.getFluidAmountLong());
        nbt.func_74772_a("Capacity", this.getCapacityLong());
        return nbt;
    }
}

