/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.item;

import com.cleanroommc.modularui.utils.item.EmptyHandlerLong;
import com.cleanroommc.modularui.utils.item.IItemHandlerLong;
import com.cleanroommc.modularui.utils.item.IItemStackLong;

public class CombinedInvWrapperLong
implements IItemHandlerLong {
    protected final IItemHandlerLong[] itemHandler;
    protected final int[] baseIndex;
    protected final int slotCount;

    public CombinedInvWrapperLong(IItemHandlerLong ... itemHandler) {
        this.itemHandler = itemHandler;
        this.baseIndex = new int[itemHandler.length];
        int index = 0;
        for (int i = 0; i < itemHandler.length; ++i) {
            this.baseIndex[i] = index += itemHandler[i].getSlots();
        }
        this.slotCount = index;
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    protected IItemHandlerLong getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.itemHandler.length) {
            return EmptyHandlerLong.INSTANCE;
        }
        return this.itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    @Override
    public void setStackInSlotLong(int slot, IItemStackLong stack) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerLong handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        handler.setStackInSlotLong(slot, stack);
    }

    @Override
    public int getSlots() {
        return this.slotCount;
    }

    @Override
    public IItemStackLong getStackInSlotLong(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerLong handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.getStackInSlotLong(slot);
    }

    @Override
    public IItemStackLong insertItemLong(int slot, IItemStackLong stack, boolean simulate) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerLong handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.insertItemLong(slot, stack, simulate);
    }

    @Override
    public IItemStackLong extractItemLong(int slot, long amount, boolean simulate) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerLong handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.extractItemLong(slot, amount, simulate);
    }

    @Override
    public long getSlotLimitLong(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerLong handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.getSlotLimitLong(localSlot);
    }

    @Override
    public boolean isItemValidLong(int slot, IItemStackLong stack) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerLong handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.isItemValidLong(localSlot, stack);
    }
}

