/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.item.IItemStackLong;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import com.cleanroommc.modularui.utils.item.ItemStackLong;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.slot.ModularSlotLong;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ItemSlotLongSH
extends SyncHandler {
    private final ModularSlotLong slot;
    private IItemStackLong lastStoredItem;
    private IItemStackLong lastStoredPhantomItem = null;

    @ApiStatus.Internal
    public ItemSlotLongSH(ModularSlotLong slot) {
        this.slot = slot;
    }

    @Override
    public void init(String key, PanelSyncManager syncHandler) {
        super.init(key, syncHandler);
        syncHandler.getContainer().registerSlot(syncHandler.getPanelName(), this.slot);
        IItemStackLong currentStack = this.getSlot().getStackLong();
        IItemStackLong iItemStackLong = this.lastStoredItem = currentStack != null ? currentStack.copy() : null;
        if (this.isPhantom() && currentStack != null) {
            this.lastStoredPhantomItem = currentStack.copy();
            this.lastStoredPhantomItem.setStackSize(1L);
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        IItemStackLong itemStack = this.getSlot().getStackLong();
        if (itemStack == null && this.lastStoredItem == null) {
            return;
        }
        boolean onlyAmountChanged = false;
        if (init || !ItemHandlerHelper.canItemStacksStack(this.lastStoredItem, itemStack) || (onlyAmountChanged = itemStack.getStackSize() != this.lastStoredItem.getStackSize())) {
            this.getSlot().onSlotChangedRealLong(itemStack, onlyAmountChanged, false, init);
            if (onlyAmountChanged) {
                this.lastStoredItem.setStackSize(itemStack.getStackSize());
            } else {
                this.lastStoredItem = itemStack == null ? null : itemStack.copy();
            }
            boolean finalOnlyAmountChanged = onlyAmountChanged;
            this.syncToClient(1, buffer -> {
                buffer.writeBoolean(finalOnlyAmountChanged);
                NetworkUtils.writeItemStackLong(buffer, itemStack);
                buffer.writeBoolean(init);
            });
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 1) {
            boolean onlyAmountChanged = buf.readBoolean();
            this.lastStoredItem = NetworkUtils.readItemStackLong(buf);
            this.getSlot().onSlotChangedRealLong(this.lastStoredItem, onlyAmountChanged, true, buf.readBoolean());
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 2) {
            this.phantomClick(MouseData.readPacket(buf));
        } else if (id == 3) {
            this.phantomScroll(MouseData.readPacket(buf));
        } else if (id == 4) {
            this.setEnabled(buf.readBoolean(), false);
        } else if (id == 5) {
            if (!this.isPhantom()) {
                return;
            }
            ItemStack stack = NetworkUtils.readItemStack(buf);
            this.slot.func_75215_d(stack);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(MouseData mouseData) {
        ItemStack cursorStackItem = this.getSyncManager().getCursorItem();
        ItemStackLong cursorStack = cursorStackItem == null ? null : new ItemStackLong(cursorStackItem);
        IItemStackLong slotStack = this.getSlot().getStackLong();
        if (cursorStack != null && slotStack != null && !ItemHandlerHelper.canItemStacksStack(cursorStack, slotStack)) {
            IItemStackLong stackToPut = cursorStack.copy();
            if (mouseData.mouseButton == 1) {
                stackToPut.setStackSize(1L);
            }
            this.getSlot().putStackLong(stackToPut);
            this.lastStoredPhantomItem = stackToPut.copy();
            return;
        } else if (slotStack == null) {
            IItemStackLong stackToPut;
            if (cursorStack == null) {
                if (mouseData.mouseButton != 1 || this.lastStoredPhantomItem == null) return;
                stackToPut = this.lastStoredPhantomItem.copy();
            } else {
                stackToPut = cursorStack.copy();
            }
            if (mouseData.mouseButton == 1) {
                stackToPut.setStackSize(1L);
            }
            this.getSlot().putStackLong(stackToPut);
            this.lastStoredPhantomItem = stackToPut.copy();
            return;
        } else if (mouseData.mouseButton == 0) {
            if (mouseData.shift) {
                this.slot.func_75215_d(null);
                return;
            } else {
                this.incrementStackCount(-1L);
            }
            return;
        } else {
            if (mouseData.mouseButton != 1) return;
            this.incrementStackCount(1L);
        }
    }

    protected void phantomScroll(MouseData mouseData) {
        IItemStackLong currentItem = this.slot.getStackLong();
        long amount = mouseData.mouseButton;
        if (mouseData.shift) {
            amount *= 4L;
        }
        if (mouseData.ctrl) {
            amount *= 16L;
        }
        if (mouseData.alt) {
            amount *= 64L;
        }
        if (amount > 0L && currentItem == null && this.lastStoredPhantomItem != null) {
            IItemStackLong stackToPut = this.lastStoredPhantomItem.copy();
            stackToPut.setStackSize(amount);
            this.slot.putStackLong(stackToPut);
        } else {
            this.incrementStackCount(amount);
        }
    }

    public void incrementStackCount(long amount) {
        IItemStackLong stack = this.getSlot().getStackLong();
        if (stack == null) {
            return;
        }
        long oldAmount = stack.getStackSize();
        if (amount < 0L) {
            amount = Math.max(0L, oldAmount + amount);
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            long maxSize = this.getSlot().getSlotStackLimitLong();
            if (!this.slot.isIgnoreMaxStackSize() && stack.getMaxStackSize() < maxSize) {
                maxSize = stack.getMaxStackSize();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack = stack.copy();
            stack.setStackSize(amount);
            this.getSlot().putStackLong(stack);
        }
    }

    public void setEnabled(boolean enabled, boolean sync) {
        this.slot.setEnabled(enabled);
        if (sync) {
            this.sync(4, buffer -> buffer.writeBoolean(enabled));
        }
    }

    public void updateFromClient(IItemStackLong stack) {
        this.syncToServer(5, buf -> NetworkUtils.writeItemStackLong(buf, stack));
    }

    public ModularSlotLong getSlot() {
        return this.slot;
    }

    public boolean isItemValid(IItemStackLong itemStack) {
        return this.getSlot().isItemValidLong(itemStack);
    }

    public boolean isPhantom() {
        return this.slot.isPhantom();
    }

    @Nullable
    public String getSlotGroup() {
        return this.slot.getSlotGroupName();
    }
}

