/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTextFieldTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.ScrollWidget;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widgets.textfield.TextFieldHandler;
import com.cleanroommc.modularui.widgets.textfield.TextFieldRenderer;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.NotNull;

public class BaseTextFieldWidget<W extends BaseTextFieldWidget<W>>
extends ScrollWidget<W>
implements IFocusedWidget {
    public static final DecimalFormat format = new DecimalFormat("###.###");
    public static final Pattern NATURAL_NUMS = Pattern.compile("[0-9]*([+\\-*/%^][0-9]*)*");
    public static final Pattern WHOLE_NUMS = Pattern.compile("-?[0-9]*([+\\-*/%^][0-9]*)*");
    public static final Pattern DECIMALS = Pattern.compile("[0-9]*(" + BaseTextFieldWidget.getDecimalSeparator() + "[0-9]*)?([+\\-*/%^][0-9]*(" + BaseTextFieldWidget.getDecimalSeparator() + "[0-9]*)?)*");
    public static final Pattern LETTERS = Pattern.compile("[a-zA-Z]*");
    public static final Pattern ANY = Pattern.compile(".*");
    private static final Pattern BASE_PATTERN = Pattern.compile("[^\u00a7]");
    protected TextFieldHandler handler = new TextFieldHandler(this);
    protected TextFieldRenderer renderer = new TextFieldRenderer(this.handler);
    protected Alignment textAlignment = Alignment.CenterLeft;
    protected int scrollOffset = 0;
    protected float scale = 1.0f;
    private int cursorTimer;
    protected boolean changedTextColor = false;

    public BaseTextFieldWidget() {
        super(new HorizontalScrollData());
        this.handler.setRenderer(this.renderer);
        this.handler.setScrollArea(this.getScrollArea());
        this.padding(4, 0);
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean addChild(IWidget child, int index) {
        return false;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.handler.setGuiContext(this.getContext());
        if (!this.changedTextColor) {
            this.renderer.setColor(this.getWidgetTheme(this.getContext().getTheme()).getTextColor());
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.isFocused() && ++this.cursorTimer == 30) {
            this.renderer.toggleCursor();
            this.cursorTimer = 0;
        }
    }

    @Override
    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (transformed) {
            this.drawText(context);
        } else {
            Stencil.apply(1, 1, this.getArea().w() - 2, this.getArea().h() - 2, context);
        }
    }

    public void drawText(ModularGuiContext context) {
        this.renderer.setSimulate(false);
        this.renderer.setScale(this.scale);
        this.renderer.setAlignment(this.textAlignment, -2.0f, this.getArea().height);
        this.renderer.draw(this.handler.getText());
        this.getScrollArea().getScrollX().setScrollSize(Math.max(0, (int)(this.renderer.getLastWidth() + 0.5f)));
    }

    @Override
    public WidgetTextFieldTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getTextFieldTheme();
    }

    @Override
    public boolean isFocused() {
        return this.getContext().isFocused(this);
    }

    @Override
    public void onFocus(ModularGuiContext context) {
        this.cursorTimer = 0;
        this.renderer.setCursor(true);
    }

    @Override
    public void onRemoveFocus(ModularGuiContext context) {
        this.renderer.setCursor(false);
        this.cursorTimer = 0;
        this.scrollOffset = 0;
        this.handler.setCursor(0, 0, true, true);
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        Interactable.Result result = super.onMousePressed(mouseButton);
        if (result != Interactable.Result.IGNORE) {
            return result;
        }
        if (!this.isHovering()) {
            return Interactable.Result.IGNORE;
        }
        int x = this.getContext().getMouseX() + this.getScrollX();
        int y = this.getContext().getMouseY() + this.getScrollY();
        this.handler.setCursor(this.renderer.getCursorPos(this.handler.getText(), x, y), true);
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        if (this.isFocused()) {
            int x = this.getContext().getMouseX() + this.getScrollX();
            int y = this.getContext().getMouseY() + this.getScrollY();
            this.handler.setMainCursor(this.renderer.getCursorPos(this.handler.getText(), x, y), true);
        }
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char character, int keyCode) {
        if (!this.isFocused()) {
            return Interactable.Result.IGNORE;
        }
        switch (keyCode) {
            case 28: {
                if (this.getMaxLines() > 1) {
                    this.handler.newLine();
                } else {
                    this.getContext().removeFocus();
                }
                return Interactable.Result.SUCCESS;
            }
            case 1: {
                this.getContext().removeFocus();
                return Interactable.Result.SUCCESS;
            }
            case 203: {
                this.handler.moveCursorLeft(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 205: {
                this.handler.moveCursorRight(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 200: {
                this.handler.moveCursorUp(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 208: {
                this.handler.moveCursorDown(Interactable.hasControlDown(), Interactable.hasShiftDown());
                return Interactable.Result.SUCCESS;
            }
            case 211: {
                this.handler.delete(true);
                return Interactable.Result.SUCCESS;
            }
            case 14: {
                this.handler.delete();
                return Interactable.Result.SUCCESS;
            }
        }
        if (character == '\u0000') {
            return Interactable.Result.STOP;
        }
        if (Interactable.isKeyComboCtrlC(keyCode)) {
            GuiScreen.func_146275_d((String)this.handler.getSelectedText());
            return Interactable.Result.SUCCESS;
        }
        if (Interactable.isKeyComboCtrlV(keyCode)) {
            this.handler.insert(GuiScreen.func_146277_j());
            return Interactable.Result.SUCCESS;
        }
        if (Interactable.isKeyComboCtrlX(keyCode) && this.handler.hasTextMarked()) {
            GuiScreen.func_146275_d((String)this.handler.getSelectedText());
            this.handler.delete();
            return Interactable.Result.SUCCESS;
        }
        if (Interactable.isKeyComboCtrlA(keyCode)) {
            this.handler.markAll();
            return Interactable.Result.SUCCESS;
        }
        if (BASE_PATTERN.matcher(String.valueOf(character)).matches()) {
            this.handler.insert(String.valueOf(character));
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.STOP;
    }

    public int getMaxLines() {
        return this.handler.getMaxLines();
    }

    public ScrollData getScrollData() {
        return this.getScrollArea().getScrollX();
    }

    public W setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setScale(float scale) {
        this.scale = scale;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setTextColor(int color) {
        this.renderer.setColor(color);
        this.changedTextColor = true;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public static char getDecimalSeparator() {
        return format.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public static char getGroupSeparator() {
        return format.getDecimalFormatSymbols().getGroupingSeparator();
    }
}

